/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.glue.CloudWatchEncryption;
import software.amazon.awscdk.services.glue.ISecurityConfiguration;
import software.amazon.awscdk.services.glue.JobBookmarksEncryption;
import software.amazon.awscdk.services.glue.S3Encryption;
import software.amazon.awscdk.services.glue.SecurityConfigurationProps;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_glue.SecurityConfiguration")
public class SecurityConfiguration
extends Resource
implements ISecurityConfiguration {
    protected SecurityConfiguration(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecurityConfiguration(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SecurityConfiguration(@NotNull Construct scope, @NotNull String id, @NotNull SecurityConfigurationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ISecurityConfiguration fromSecurityConfigurationName(@NotNull Construct scope, @NotNull String id, @NotNull String securityConfigurationName) {
        return (ISecurityConfiguration)JsiiObject.jsiiStaticCall(SecurityConfiguration.class, (String)"fromSecurityConfigurationName", (NativeType)NativeType.forClass(ISecurityConfiguration.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(securityConfigurationName, "securityConfigurationName is required")});
    }

    @Override
    @NotNull
    public String getSecurityConfigurationName() {
        return (String)Kernel.get((Object)this, (String)"securityConfigurationName", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public IKey getCloudWatchEncryptionKey() {
        return (IKey)Kernel.get((Object)this, (String)"cloudWatchEncryptionKey", (NativeType)NativeType.forClass(IKey.class));
    }

    @Nullable
    public IKey getJobBookmarksEncryptionKey() {
        return (IKey)Kernel.get((Object)this, (String)"jobBookmarksEncryptionKey", (NativeType)NativeType.forClass(IKey.class));
    }

    @Nullable
    public IKey getS3EncryptionKey() {
        return (IKey)Kernel.get((Object)this, (String)"s3EncryptionKey", (NativeType)NativeType.forClass(IKey.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SecurityConfiguration> {
        private final Construct scope;
        private final String id;
        private final SecurityConfigurationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new SecurityConfigurationProps.Builder();
        }

        public Builder securityConfigurationName(String securityConfigurationName) {
            this.props.securityConfigurationName(securityConfigurationName);
            return this;
        }

        public Builder cloudWatchEncryption(CloudWatchEncryption cloudWatchEncryption) {
            this.props.cloudWatchEncryption(cloudWatchEncryption);
            return this;
        }

        public Builder jobBookmarksEncryption(JobBookmarksEncryption jobBookmarksEncryption) {
            this.props.jobBookmarksEncryption(jobBookmarksEncryption);
            return this;
        }

        public Builder s3Encryption(S3Encryption s3Encryption) {
            this.props.s3Encryption(s3Encryption);
            return this;
        }

        public SecurityConfiguration build() {
            return new SecurityConfiguration(this.scope, this.id, this.props.build());
        }
    }
}

