/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kendra;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.kendra.CfnDataSource;
import software.amazon.awscdk.services.kendra.CfnDataSourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource")
public class CfnDataSource
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDataSource.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDataSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDataSource(@NotNull Construct scope, @NotNull String id, @NotNull CfnDataSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getIndexId() {
        return (String)Kernel.get((Object)this, (String)"indexId", (NativeType)NativeType.forClass(String.class));
    }

    public void setIndexId(@NotNull String value) {
        Kernel.set((Object)this, (String)"indexId", (Object)Objects.requireNonNull(value, "indexId is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@NotNull String value) {
        Kernel.set((Object)this, (String)"type", (Object)Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public Object getDataSourceConfiguration() {
        return Kernel.get((Object)this, (String)"dataSourceConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDataSourceConfiguration(@Nullable DataSourceConfigurationProperty value) {
        Kernel.set((Object)this, (String)"dataSourceConfiguration", (Object)value);
    }

    public void setDataSourceConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"dataSourceConfiguration", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)value);
    }

    @Nullable
    public String getSchedule() {
        return (String)Kernel.get((Object)this, (String)"schedule", (NativeType)NativeType.forClass(String.class));
    }

    public void setSchedule(@Nullable String value) {
        Kernel.set((Object)this, (String)"schedule", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDataSource> {
        private final Construct scope;
        private final String id;
        private final CfnDataSourceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDataSourceProps.Builder();
        }

        public Builder indexId(String indexId) {
            this.props.indexId(indexId);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder dataSourceConfiguration(DataSourceConfigurationProperty dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }

        public Builder dataSourceConfiguration(IResolvable dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder schedule(String schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnDataSource build() {
            return new CfnDataSource(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.SqlConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SqlConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getQueryIdentifiersEnclosingOption() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SqlConfigurationProperty> {
            private String queryIdentifiersEnclosingOption;

            public Builder queryIdentifiersEnclosingOption(String queryIdentifiersEnclosingOption) {
                this.queryIdentifiersEnclosingOption = queryIdentifiersEnclosingOption;
                return this;
            }

            public SqlConfigurationProperty build() {
                return new Jsii.Proxy(this.queryIdentifiersEnclosingOption);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.SharePointConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SharePointConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSecretArn();

        @NotNull
        public String getSharePointVersion();

        @NotNull
        public List<String> getUrls();

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        @Nullable
        default public Object getDisableLocalGroups() {
            return null;
        }

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public List<String> getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getUseChangeLog() {
            return null;
        }

        @Nullable
        default public Object getVpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SharePointConfigurationProperty> {
            private String secretArn;
            private String sharePointVersion;
            private List<String> urls;
            private Object crawlAttachments;
            private Object disableLocalGroups;
            private String documentTitleFieldName;
            private List<String> exclusionPatterns;
            private Object fieldMappings;
            private List<String> inclusionPatterns;
            private Object useChangeLog;
            private Object vpcConfiguration;

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder sharePointVersion(String sharePointVersion) {
                this.sharePointVersion = sharePointVersion;
                return this;
            }

            public Builder urls(List<String> urls) {
                this.urls = urls;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder disableLocalGroups(Boolean disableLocalGroups) {
                this.disableLocalGroups = disableLocalGroups;
                return this;
            }

            public Builder disableLocalGroups(IResolvable disableLocalGroups) {
                this.disableLocalGroups = disableLocalGroups;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder exclusionPatterns(List<String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder inclusionPatterns(List<String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public Builder useChangeLog(Boolean useChangeLog) {
                this.useChangeLog = useChangeLog;
                return this;
            }

            public Builder useChangeLog(IResolvable useChangeLog) {
                this.useChangeLog = useChangeLog;
                return this;
            }

            public Builder vpcConfiguration(DataSourceVpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public Builder vpcConfiguration(IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public SharePointConfigurationProperty build() {
                return new Jsii.Proxy(this.secretArn, this.sharePointVersion, this.urls, this.crawlAttachments, this.disableLocalGroups, this.documentTitleFieldName, this.exclusionPatterns, this.fieldMappings, this.inclusionPatterns, this.useChangeLog, this.vpcConfiguration);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ServiceNowServiceCatalogConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceNowServiceCatalogConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public List<String> getExcludeAttachmentFilePatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public List<String> getIncludeAttachmentFilePatterns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceNowServiceCatalogConfigurationProperty> {
            private String documentDataFieldName;
            private Object crawlAttachments;
            private String documentTitleFieldName;
            private List<String> excludeAttachmentFilePatterns;
            private Object fieldMappings;
            private List<String> includeAttachmentFilePatterns;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder excludeAttachmentFilePatterns(List<String> excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder includeAttachmentFilePatterns(List<String> includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            public ServiceNowServiceCatalogConfigurationProperty build() {
                return new Jsii.Proxy(this.documentDataFieldName, this.crawlAttachments, this.documentTitleFieldName, this.excludeAttachmentFilePatterns, this.fieldMappings, this.includeAttachmentFilePatterns);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceNowKnowledgeArticleConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public List<String> getExcludeAttachmentFilePatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public List<String> getIncludeAttachmentFilePatterns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceNowKnowledgeArticleConfigurationProperty> {
            private String documentDataFieldName;
            private Object crawlAttachments;
            private String documentTitleFieldName;
            private List<String> excludeAttachmentFilePatterns;
            private Object fieldMappings;
            private List<String> includeAttachmentFilePatterns;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder excludeAttachmentFilePatterns(List<String> excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder includeAttachmentFilePatterns(List<String> includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            public ServiceNowKnowledgeArticleConfigurationProperty build() {
                return new Jsii.Proxy(this.documentDataFieldName, this.crawlAttachments, this.documentTitleFieldName, this.excludeAttachmentFilePatterns, this.fieldMappings, this.includeAttachmentFilePatterns);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ServiceNowConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceNowConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getHostUrl();

        @NotNull
        public String getSecretArn();

        @NotNull
        public String getServiceNowBuildVersion();

        @Nullable
        default public Object getKnowledgeArticleConfiguration() {
            return null;
        }

        @Nullable
        default public Object getServiceCatalogConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceNowConfigurationProperty> {
            private String hostUrl;
            private String secretArn;
            private String serviceNowBuildVersion;
            private Object knowledgeArticleConfiguration;
            private Object serviceCatalogConfiguration;

            public Builder hostUrl(String hostUrl) {
                this.hostUrl = hostUrl;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder serviceNowBuildVersion(String serviceNowBuildVersion) {
                this.serviceNowBuildVersion = serviceNowBuildVersion;
                return this;
            }

            public Builder knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfigurationProperty knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            public Builder knowledgeArticleConfiguration(IResolvable knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            public Builder serviceCatalogConfiguration(ServiceNowServiceCatalogConfigurationProperty serviceCatalogConfiguration) {
                this.serviceCatalogConfiguration = serviceCatalogConfiguration;
                return this;
            }

            public Builder serviceCatalogConfiguration(IResolvable serviceCatalogConfiguration) {
                this.serviceCatalogConfiguration = serviceCatalogConfiguration;
                return this;
            }

            public ServiceNowConfigurationProperty build() {
                return new Jsii.Proxy(this.hostUrl, this.secretArn, this.serviceNowBuildVersion, this.knowledgeArticleConfiguration, this.serviceCatalogConfiguration);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.SalesforceStandardObjectConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceStandardObjectConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @NotNull
        public String getName();

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceStandardObjectConfigurationProperty> {
            private String documentDataFieldName;
            private String name;
            private String documentTitleFieldName;
            private Object fieldMappings;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public SalesforceStandardObjectConfigurationProperty build() {
                return new Jsii.Proxy(this.documentDataFieldName, this.name, this.documentTitleFieldName, this.fieldMappings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.SalesforceStandardObjectAttachmentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceStandardObjectAttachmentConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceStandardObjectAttachmentConfigurationProperty> {
            private String documentTitleFieldName;
            private Object fieldMappings;

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public SalesforceStandardObjectAttachmentConfigurationProperty build() {
                return new Jsii.Proxy(this.documentTitleFieldName, this.fieldMappings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceStandardKnowledgeArticleTypeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceStandardKnowledgeArticleTypeConfigurationProperty> {
            private String documentDataFieldName;
            private String documentTitleFieldName;
            private Object fieldMappings;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public SalesforceStandardKnowledgeArticleTypeConfigurationProperty build() {
                return new Jsii.Proxy(this.documentDataFieldName, this.documentTitleFieldName, this.fieldMappings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceKnowledgeArticleConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getIncludedStates();

        @Nullable
        default public Object getCustomKnowledgeArticleTypeConfigurations() {
            return null;
        }

        @Nullable
        default public Object getStandardKnowledgeArticleTypeConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceKnowledgeArticleConfigurationProperty> {
            private List<String> includedStates;
            private Object customKnowledgeArticleTypeConfigurations;
            private Object standardKnowledgeArticleTypeConfiguration;

            public Builder includedStates(List<String> includedStates) {
                this.includedStates = includedStates;
                return this;
            }

            public Builder customKnowledgeArticleTypeConfigurations(IResolvable customKnowledgeArticleTypeConfigurations) {
                this.customKnowledgeArticleTypeConfigurations = customKnowledgeArticleTypeConfigurations;
                return this;
            }

            public Builder customKnowledgeArticleTypeConfigurations(List<? extends Object> customKnowledgeArticleTypeConfigurations) {
                this.customKnowledgeArticleTypeConfigurations = customKnowledgeArticleTypeConfigurations;
                return this;
            }

            public Builder standardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfigurationProperty standardKnowledgeArticleTypeConfiguration) {
                this.standardKnowledgeArticleTypeConfiguration = standardKnowledgeArticleTypeConfiguration;
                return this;
            }

            public Builder standardKnowledgeArticleTypeConfiguration(IResolvable standardKnowledgeArticleTypeConfiguration) {
                this.standardKnowledgeArticleTypeConfiguration = standardKnowledgeArticleTypeConfiguration;
                return this;
            }

            public SalesforceKnowledgeArticleConfigurationProperty build() {
                return new Jsii.Proxy(this.includedStates, this.customKnowledgeArticleTypeConfigurations, this.standardKnowledgeArticleTypeConfiguration);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceCustomKnowledgeArticleTypeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @NotNull
        public String getName();

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceCustomKnowledgeArticleTypeConfigurationProperty> {
            private String documentDataFieldName;
            private String name;
            private String documentTitleFieldName;
            private Object fieldMappings;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public SalesforceCustomKnowledgeArticleTypeConfigurationProperty build() {
                return new Jsii.Proxy(this.documentDataFieldName, this.name, this.documentTitleFieldName, this.fieldMappings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.SalesforceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSecretArn();

        @NotNull
        public String getServerUrl();

        @Nullable
        default public Object getChatterFeedConfiguration() {
            return null;
        }

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        @Nullable
        default public List<String> getExcludeAttachmentFilePatterns() {
            return null;
        }

        @Nullable
        default public List<String> getIncludeAttachmentFilePatterns() {
            return null;
        }

        @Nullable
        default public Object getKnowledgeArticleConfiguration() {
            return null;
        }

        @Nullable
        default public Object getStandardObjectAttachmentConfiguration() {
            return null;
        }

        @Nullable
        default public Object getStandardObjectConfigurations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceConfigurationProperty> {
            private String secretArn;
            private String serverUrl;
            private Object chatterFeedConfiguration;
            private Object crawlAttachments;
            private List<String> excludeAttachmentFilePatterns;
            private List<String> includeAttachmentFilePatterns;
            private Object knowledgeArticleConfiguration;
            private Object standardObjectAttachmentConfiguration;
            private Object standardObjectConfigurations;

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder serverUrl(String serverUrl) {
                this.serverUrl = serverUrl;
                return this;
            }

            public Builder chatterFeedConfiguration(SalesforceChatterFeedConfigurationProperty chatterFeedConfiguration) {
                this.chatterFeedConfiguration = chatterFeedConfiguration;
                return this;
            }

            public Builder chatterFeedConfiguration(IResolvable chatterFeedConfiguration) {
                this.chatterFeedConfiguration = chatterFeedConfiguration;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder excludeAttachmentFilePatterns(List<String> excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            public Builder includeAttachmentFilePatterns(List<String> includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            public Builder knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfigurationProperty knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            public Builder knowledgeArticleConfiguration(IResolvable knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            public Builder standardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfigurationProperty standardObjectAttachmentConfiguration) {
                this.standardObjectAttachmentConfiguration = standardObjectAttachmentConfiguration;
                return this;
            }

            public Builder standardObjectAttachmentConfiguration(IResolvable standardObjectAttachmentConfiguration) {
                this.standardObjectAttachmentConfiguration = standardObjectAttachmentConfiguration;
                return this;
            }

            public Builder standardObjectConfigurations(IResolvable standardObjectConfigurations) {
                this.standardObjectConfigurations = standardObjectConfigurations;
                return this;
            }

            public Builder standardObjectConfigurations(List<? extends Object> standardObjectConfigurations) {
                this.standardObjectConfigurations = standardObjectConfigurations;
                return this;
            }

            public SalesforceConfigurationProperty build() {
                return new Jsii.Proxy(this.secretArn, this.serverUrl, this.chatterFeedConfiguration, this.crawlAttachments, this.excludeAttachmentFilePatterns, this.includeAttachmentFilePatterns, this.knowledgeArticleConfiguration, this.standardObjectAttachmentConfiguration, this.standardObjectConfigurations);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.SalesforceChatterFeedConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SalesforceChatterFeedConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDocumentDataFieldName();

        @Nullable
        default public String getDocumentTitleFieldName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public List<String> getIncludeFilterTypes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SalesforceChatterFeedConfigurationProperty> {
            private String documentDataFieldName;
            private String documentTitleFieldName;
            private Object fieldMappings;
            private List<String> includeFilterTypes;

            public Builder documentDataFieldName(String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            public Builder documentTitleFieldName(String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder includeFilterTypes(List<String> includeFilterTypes) {
                this.includeFilterTypes = includeFilterTypes;
                return this;
            }

            public SalesforceChatterFeedConfigurationProperty build() {
                return new Jsii.Proxy(this.documentDataFieldName, this.documentTitleFieldName, this.fieldMappings, this.includeFilterTypes);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.S3PathProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3PathProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3PathProperty> {
            private String bucket;
            private String key;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public S3PathProperty build() {
                return new Jsii.Proxy(this.bucket, this.key);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.S3DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3DataSourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        @Nullable
        default public Object getAccessControlListConfiguration() {
            return null;
        }

        @Nullable
        default public Object getDocumentsMetadataConfiguration() {
            return null;
        }

        @Nullable
        default public List<String> getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPatterns() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPrefixes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3DataSourceConfigurationProperty> {
            private String bucketName;
            private Object accessControlListConfiguration;
            private Object documentsMetadataConfiguration;
            private List<String> exclusionPatterns;
            private List<String> inclusionPatterns;
            private List<String> inclusionPrefixes;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder accessControlListConfiguration(AccessControlListConfigurationProperty accessControlListConfiguration) {
                this.accessControlListConfiguration = accessControlListConfiguration;
                return this;
            }

            public Builder accessControlListConfiguration(IResolvable accessControlListConfiguration) {
                this.accessControlListConfiguration = accessControlListConfiguration;
                return this;
            }

            public Builder documentsMetadataConfiguration(DocumentsMetadataConfigurationProperty documentsMetadataConfiguration) {
                this.documentsMetadataConfiguration = documentsMetadataConfiguration;
                return this;
            }

            public Builder documentsMetadataConfiguration(IResolvable documentsMetadataConfiguration) {
                this.documentsMetadataConfiguration = documentsMetadataConfiguration;
                return this;
            }

            public Builder exclusionPatterns(List<String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder inclusionPatterns(List<String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public Builder inclusionPrefixes(List<String> inclusionPrefixes) {
                this.inclusionPrefixes = inclusionPrefixes;
                return this;
            }

            public S3DataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this.bucketName, this.accessControlListConfiguration, this.documentsMetadataConfiguration, this.exclusionPatterns, this.inclusionPatterns, this.inclusionPrefixes);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.OneDriveUsersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OneDriveUsersProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getOneDriveUserList() {
            return null;
        }

        @Nullable
        default public Object getOneDriveUserS3Path() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OneDriveUsersProperty> {
            private List<String> oneDriveUserList;
            private Object oneDriveUserS3Path;

            public Builder oneDriveUserList(List<String> oneDriveUserList) {
                this.oneDriveUserList = oneDriveUserList;
                return this;
            }

            public Builder oneDriveUserS3Path(S3PathProperty oneDriveUserS3Path) {
                this.oneDriveUserS3Path = oneDriveUserS3Path;
                return this;
            }

            public Builder oneDriveUserS3Path(IResolvable oneDriveUserS3Path) {
                this.oneDriveUserS3Path = oneDriveUserS3Path;
                return this;
            }

            public OneDriveUsersProperty build() {
                return new Jsii.Proxy(this.oneDriveUserList, this.oneDriveUserS3Path);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.OneDriveConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OneDriveConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getOneDriveUsers();

        @NotNull
        public String getSecretArn();

        @NotNull
        public String getTenantDomain();

        @Nullable
        default public Object getDisableLocalGroups() {
            return null;
        }

        @Nullable
        default public List<String> getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPatterns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OneDriveConfigurationProperty> {
            private Object oneDriveUsers;
            private String secretArn;
            private String tenantDomain;
            private Object disableLocalGroups;
            private List<String> exclusionPatterns;
            private Object fieldMappings;
            private List<String> inclusionPatterns;

            public Builder oneDriveUsers(OneDriveUsersProperty oneDriveUsers) {
                this.oneDriveUsers = oneDriveUsers;
                return this;
            }

            public Builder oneDriveUsers(IResolvable oneDriveUsers) {
                this.oneDriveUsers = oneDriveUsers;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder tenantDomain(String tenantDomain) {
                this.tenantDomain = tenantDomain;
                return this;
            }

            public Builder disableLocalGroups(Boolean disableLocalGroups) {
                this.disableLocalGroups = disableLocalGroups;
                return this;
            }

            public Builder disableLocalGroups(IResolvable disableLocalGroups) {
                this.disableLocalGroups = disableLocalGroups;
                return this;
            }

            public Builder exclusionPatterns(List<String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder inclusionPatterns(List<String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public OneDriveConfigurationProperty build() {
                return new Jsii.Proxy(this.oneDriveUsers, this.secretArn, this.tenantDomain, this.disableLocalGroups, this.exclusionPatterns, this.fieldMappings, this.inclusionPatterns);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.GoogleDriveConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GoogleDriveConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSecretArn();

        @Nullable
        default public List<String> getExcludeMimeTypes() {
            return null;
        }

        @Nullable
        default public List<String> getExcludeSharedDrives() {
            return null;
        }

        @Nullable
        default public List<String> getExcludeUserAccounts() {
            return null;
        }

        @Nullable
        default public List<String> getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPatterns() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GoogleDriveConfigurationProperty> {
            private String secretArn;
            private List<String> excludeMimeTypes;
            private List<String> excludeSharedDrives;
            private List<String> excludeUserAccounts;
            private List<String> exclusionPatterns;
            private Object fieldMappings;
            private List<String> inclusionPatterns;

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder excludeMimeTypes(List<String> excludeMimeTypes) {
                this.excludeMimeTypes = excludeMimeTypes;
                return this;
            }

            public Builder excludeSharedDrives(List<String> excludeSharedDrives) {
                this.excludeSharedDrives = excludeSharedDrives;
                return this;
            }

            public Builder excludeUserAccounts(List<String> excludeUserAccounts) {
                this.excludeUserAccounts = excludeUserAccounts;
                return this;
            }

            public Builder exclusionPatterns(List<String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder inclusionPatterns(List<String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public GoogleDriveConfigurationProperty build() {
                return new Jsii.Proxy(this.secretArn, this.excludeMimeTypes, this.excludeSharedDrives, this.excludeUserAccounts, this.exclusionPatterns, this.fieldMappings, this.inclusionPatterns);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.DocumentsMetadataConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DocumentsMetadataConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getS3Prefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DocumentsMetadataConfigurationProperty> {
            private String s3Prefix;

            public Builder s3Prefix(String s3Prefix) {
                this.s3Prefix = s3Prefix;
                return this;
            }

            public DocumentsMetadataConfigurationProperty build() {
                return new Jsii.Proxy(this.s3Prefix);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.DatabaseConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatabaseConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumnConfiguration();

        @NotNull
        public Object getConnectionConfiguration();

        @NotNull
        public String getDatabaseEngineType();

        @Nullable
        default public Object getAclConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSqlConfiguration() {
            return null;
        }

        @Nullable
        default public Object getVpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatabaseConfigurationProperty> {
            private Object columnConfiguration;
            private Object connectionConfiguration;
            private String databaseEngineType;
            private Object aclConfiguration;
            private Object sqlConfiguration;
            private Object vpcConfiguration;

            public Builder columnConfiguration(ColumnConfigurationProperty columnConfiguration) {
                this.columnConfiguration = columnConfiguration;
                return this;
            }

            public Builder columnConfiguration(IResolvable columnConfiguration) {
                this.columnConfiguration = columnConfiguration;
                return this;
            }

            public Builder connectionConfiguration(ConnectionConfigurationProperty connectionConfiguration) {
                this.connectionConfiguration = connectionConfiguration;
                return this;
            }

            public Builder connectionConfiguration(IResolvable connectionConfiguration) {
                this.connectionConfiguration = connectionConfiguration;
                return this;
            }

            public Builder databaseEngineType(String databaseEngineType) {
                this.databaseEngineType = databaseEngineType;
                return this;
            }

            public Builder aclConfiguration(AclConfigurationProperty aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            public Builder aclConfiguration(IResolvable aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            public Builder sqlConfiguration(SqlConfigurationProperty sqlConfiguration) {
                this.sqlConfiguration = sqlConfiguration;
                return this;
            }

            public Builder sqlConfiguration(IResolvable sqlConfiguration) {
                this.sqlConfiguration = sqlConfiguration;
                return this;
            }

            public Builder vpcConfiguration(DataSourceVpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public Builder vpcConfiguration(IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public DatabaseConfigurationProperty build() {
                return new Jsii.Proxy(this.columnConfiguration, this.connectionConfiguration, this.databaseEngineType, this.aclConfiguration, this.sqlConfiguration, this.vpcConfiguration);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.DataSourceVpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceVpcConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnetIds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceVpcConfigurationProperty> {
            private List<String> securityGroupIds;
            private List<String> subnetIds;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public DataSourceVpcConfigurationProperty build() {
                return new Jsii.Proxy(this.securityGroupIds, this.subnetIds);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.DataSourceToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceToIndexFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSourceFieldName();

        @NotNull
        public String getIndexFieldName();

        @Nullable
        default public String getDateFieldFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceToIndexFieldMappingProperty> {
            private String dataSourceFieldName;
            private String indexFieldName;
            private String dateFieldFormat;

            public Builder dataSourceFieldName(String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            public Builder indexFieldName(String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            public Builder dateFieldFormat(String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            public DataSourceToIndexFieldMappingProperty build() {
                return new Jsii.Proxy(this.dataSourceFieldName, this.indexFieldName, this.dateFieldFormat);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConfluenceConfiguration() {
            return null;
        }

        @Nullable
        default public Object getDatabaseConfiguration() {
            return null;
        }

        @Nullable
        default public Object getGoogleDriveConfiguration() {
            return null;
        }

        @Nullable
        default public Object getOneDriveConfiguration() {
            return null;
        }

        @Nullable
        default public Object getS3Configuration() {
            return null;
        }

        @Nullable
        default public Object getSalesforceConfiguration() {
            return null;
        }

        @Nullable
        default public Object getServiceNowConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSharePointConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceConfigurationProperty> {
            private Object confluenceConfiguration;
            private Object databaseConfiguration;
            private Object googleDriveConfiguration;
            private Object oneDriveConfiguration;
            private Object s3Configuration;
            private Object salesforceConfiguration;
            private Object serviceNowConfiguration;
            private Object sharePointConfiguration;

            public Builder confluenceConfiguration(ConfluenceConfigurationProperty confluenceConfiguration) {
                this.confluenceConfiguration = confluenceConfiguration;
                return this;
            }

            public Builder confluenceConfiguration(IResolvable confluenceConfiguration) {
                this.confluenceConfiguration = confluenceConfiguration;
                return this;
            }

            public Builder databaseConfiguration(DatabaseConfigurationProperty databaseConfiguration) {
                this.databaseConfiguration = databaseConfiguration;
                return this;
            }

            public Builder databaseConfiguration(IResolvable databaseConfiguration) {
                this.databaseConfiguration = databaseConfiguration;
                return this;
            }

            public Builder googleDriveConfiguration(GoogleDriveConfigurationProperty googleDriveConfiguration) {
                this.googleDriveConfiguration = googleDriveConfiguration;
                return this;
            }

            public Builder googleDriveConfiguration(IResolvable googleDriveConfiguration) {
                this.googleDriveConfiguration = googleDriveConfiguration;
                return this;
            }

            public Builder oneDriveConfiguration(OneDriveConfigurationProperty oneDriveConfiguration) {
                this.oneDriveConfiguration = oneDriveConfiguration;
                return this;
            }

            public Builder oneDriveConfiguration(IResolvable oneDriveConfiguration) {
                this.oneDriveConfiguration = oneDriveConfiguration;
                return this;
            }

            public Builder s3Configuration(S3DataSourceConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder s3Configuration(IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            public Builder salesforceConfiguration(SalesforceConfigurationProperty salesforceConfiguration) {
                this.salesforceConfiguration = salesforceConfiguration;
                return this;
            }

            public Builder salesforceConfiguration(IResolvable salesforceConfiguration) {
                this.salesforceConfiguration = salesforceConfiguration;
                return this;
            }

            public Builder serviceNowConfiguration(ServiceNowConfigurationProperty serviceNowConfiguration) {
                this.serviceNowConfiguration = serviceNowConfiguration;
                return this;
            }

            public Builder serviceNowConfiguration(IResolvable serviceNowConfiguration) {
                this.serviceNowConfiguration = serviceNowConfiguration;
                return this;
            }

            public Builder sharePointConfiguration(SharePointConfigurationProperty sharePointConfiguration) {
                this.sharePointConfiguration = sharePointConfiguration;
                return this;
            }

            public Builder sharePointConfiguration(IResolvable sharePointConfiguration) {
                this.sharePointConfiguration = sharePointConfiguration;
                return this;
            }

            public DataSourceConfigurationProperty build() {
                return new Jsii.Proxy(this.confluenceConfiguration, this.databaseConfiguration, this.googleDriveConfiguration, this.oneDriveConfiguration, this.s3Configuration, this.salesforceConfiguration, this.serviceNowConfiguration, this.sharePointConfiguration);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConnectionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabaseHost();

        @NotNull
        public String getDatabaseName();

        @NotNull
        public Number getDatabasePort();

        @NotNull
        public String getSecretArn();

        @NotNull
        public String getTableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConnectionConfigurationProperty> {
            private String databaseHost;
            private String databaseName;
            private Number databasePort;
            private String secretArn;
            private String tableName;

            public Builder databaseHost(String databaseHost) {
                this.databaseHost = databaseHost;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder databasePort(Number databasePort) {
                this.databasePort = databasePort;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public ConnectionConfigurationProperty build() {
                return new Jsii.Proxy(this.databaseHost, this.databaseName, this.databasePort, this.secretArn, this.tableName);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ConfluenceSpaceToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceSpaceToIndexFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSourceFieldName();

        @NotNull
        public String getIndexFieldName();

        @Nullable
        default public String getDateFieldFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceSpaceToIndexFieldMappingProperty> {
            private String dataSourceFieldName;
            private String indexFieldName;
            private String dateFieldFormat;

            public Builder dataSourceFieldName(String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            public Builder indexFieldName(String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            public Builder dateFieldFormat(String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            public ConfluenceSpaceToIndexFieldMappingProperty build() {
                return new Jsii.Proxy(this.dataSourceFieldName, this.indexFieldName, this.dateFieldFormat);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ConfluenceSpaceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceSpaceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCrawlArchivedSpaces() {
            return null;
        }

        @Nullable
        default public Object getCrawlPersonalSpaces() {
            return null;
        }

        @Nullable
        default public List<String> getExcludeSpaces() {
            return null;
        }

        @Nullable
        default public List<String> getIncludeSpaces() {
            return null;
        }

        @Nullable
        default public Object getSpaceFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceSpaceConfigurationProperty> {
            private Object crawlArchivedSpaces;
            private Object crawlPersonalSpaces;
            private List<String> excludeSpaces;
            private List<String> includeSpaces;
            private Object spaceFieldMappings;

            public Builder crawlArchivedSpaces(Boolean crawlArchivedSpaces) {
                this.crawlArchivedSpaces = crawlArchivedSpaces;
                return this;
            }

            public Builder crawlArchivedSpaces(IResolvable crawlArchivedSpaces) {
                this.crawlArchivedSpaces = crawlArchivedSpaces;
                return this;
            }

            public Builder crawlPersonalSpaces(Boolean crawlPersonalSpaces) {
                this.crawlPersonalSpaces = crawlPersonalSpaces;
                return this;
            }

            public Builder crawlPersonalSpaces(IResolvable crawlPersonalSpaces) {
                this.crawlPersonalSpaces = crawlPersonalSpaces;
                return this;
            }

            public Builder excludeSpaces(List<String> excludeSpaces) {
                this.excludeSpaces = excludeSpaces;
                return this;
            }

            public Builder includeSpaces(List<String> includeSpaces) {
                this.includeSpaces = includeSpaces;
                return this;
            }

            public Builder spaceFieldMappings(IResolvable spaceFieldMappings) {
                this.spaceFieldMappings = spaceFieldMappings;
                return this;
            }

            public Builder spaceFieldMappings(List<? extends Object> spaceFieldMappings) {
                this.spaceFieldMappings = spaceFieldMappings;
                return this;
            }

            public ConfluenceSpaceConfigurationProperty build() {
                return new Jsii.Proxy(this.crawlArchivedSpaces, this.crawlPersonalSpaces, this.excludeSpaces, this.includeSpaces, this.spaceFieldMappings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ConfluencePageToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluencePageToIndexFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSourceFieldName();

        @NotNull
        public String getIndexFieldName();

        @Nullable
        default public String getDateFieldFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluencePageToIndexFieldMappingProperty> {
            private String dataSourceFieldName;
            private String indexFieldName;
            private String dateFieldFormat;

            public Builder dataSourceFieldName(String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            public Builder indexFieldName(String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            public Builder dateFieldFormat(String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            public ConfluencePageToIndexFieldMappingProperty build() {
                return new Jsii.Proxy(this.dataSourceFieldName, this.indexFieldName, this.dateFieldFormat);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ConfluencePageConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluencePageConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPageFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluencePageConfigurationProperty> {
            private Object pageFieldMappings;

            public Builder pageFieldMappings(IResolvable pageFieldMappings) {
                this.pageFieldMappings = pageFieldMappings;
                return this;
            }

            public Builder pageFieldMappings(List<? extends Object> pageFieldMappings) {
                this.pageFieldMappings = pageFieldMappings;
                return this;
            }

            public ConfluencePageConfigurationProperty build() {
                return new Jsii.Proxy(this.pageFieldMappings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ConfluenceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSecretArn();

        @NotNull
        public String getServerUrl();

        @NotNull
        public String getVersion();

        @Nullable
        default public Object getAttachmentConfiguration() {
            return null;
        }

        @Nullable
        default public Object getBlogConfiguration() {
            return null;
        }

        @Nullable
        default public List<String> getExclusionPatterns() {
            return null;
        }

        @Nullable
        default public List<String> getInclusionPatterns() {
            return null;
        }

        @Nullable
        default public Object getPageConfiguration() {
            return null;
        }

        @Nullable
        default public Object getSpaceConfiguration() {
            return null;
        }

        @Nullable
        default public Object getVpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceConfigurationProperty> {
            private String secretArn;
            private String serverUrl;
            private String version;
            private Object attachmentConfiguration;
            private Object blogConfiguration;
            private List<String> exclusionPatterns;
            private List<String> inclusionPatterns;
            private Object pageConfiguration;
            private Object spaceConfiguration;
            private Object vpcConfiguration;

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder serverUrl(String serverUrl) {
                this.serverUrl = serverUrl;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public Builder attachmentConfiguration(ConfluenceAttachmentConfigurationProperty attachmentConfiguration) {
                this.attachmentConfiguration = attachmentConfiguration;
                return this;
            }

            public Builder attachmentConfiguration(IResolvable attachmentConfiguration) {
                this.attachmentConfiguration = attachmentConfiguration;
                return this;
            }

            public Builder blogConfiguration(ConfluenceBlogConfigurationProperty blogConfiguration) {
                this.blogConfiguration = blogConfiguration;
                return this;
            }

            public Builder blogConfiguration(IResolvable blogConfiguration) {
                this.blogConfiguration = blogConfiguration;
                return this;
            }

            public Builder exclusionPatterns(List<String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            public Builder inclusionPatterns(List<String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            public Builder pageConfiguration(ConfluencePageConfigurationProperty pageConfiguration) {
                this.pageConfiguration = pageConfiguration;
                return this;
            }

            public Builder pageConfiguration(IResolvable pageConfiguration) {
                this.pageConfiguration = pageConfiguration;
                return this;
            }

            public Builder spaceConfiguration(ConfluenceSpaceConfigurationProperty spaceConfiguration) {
                this.spaceConfiguration = spaceConfiguration;
                return this;
            }

            public Builder spaceConfiguration(IResolvable spaceConfiguration) {
                this.spaceConfiguration = spaceConfiguration;
                return this;
            }

            public Builder vpcConfiguration(DataSourceVpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public Builder vpcConfiguration(IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            public ConfluenceConfigurationProperty build() {
                return new Jsii.Proxy(this.secretArn, this.serverUrl, this.version, this.attachmentConfiguration, this.blogConfiguration, this.exclusionPatterns, this.inclusionPatterns, this.pageConfiguration, this.spaceConfiguration, this.vpcConfiguration);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ConfluenceBlogToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceBlogToIndexFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSourceFieldName();

        @NotNull
        public String getIndexFieldName();

        @Nullable
        default public String getDateFieldFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceBlogToIndexFieldMappingProperty> {
            private String dataSourceFieldName;
            private String indexFieldName;
            private String dateFieldFormat;

            public Builder dataSourceFieldName(String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            public Builder indexFieldName(String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            public Builder dateFieldFormat(String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            public ConfluenceBlogToIndexFieldMappingProperty build() {
                return new Jsii.Proxy(this.dataSourceFieldName, this.indexFieldName, this.dateFieldFormat);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ConfluenceBlogConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceBlogConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBlogFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceBlogConfigurationProperty> {
            private Object blogFieldMappings;

            public Builder blogFieldMappings(IResolvable blogFieldMappings) {
                this.blogFieldMappings = blogFieldMappings;
                return this;
            }

            public Builder blogFieldMappings(List<? extends Object> blogFieldMappings) {
                this.blogFieldMappings = blogFieldMappings;
                return this;
            }

            public ConfluenceBlogConfigurationProperty build() {
                return new Jsii.Proxy(this.blogFieldMappings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ConfluenceAttachmentToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceAttachmentToIndexFieldMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataSourceFieldName();

        @NotNull
        public String getIndexFieldName();

        @Nullable
        default public String getDateFieldFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceAttachmentToIndexFieldMappingProperty> {
            private String dataSourceFieldName;
            private String indexFieldName;
            private String dateFieldFormat;

            public Builder dataSourceFieldName(String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            public Builder indexFieldName(String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            public Builder dateFieldFormat(String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            public ConfluenceAttachmentToIndexFieldMappingProperty build() {
                return new Jsii.Proxy(this.dataSourceFieldName, this.indexFieldName, this.dateFieldFormat);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ConfluenceAttachmentConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConfluenceAttachmentConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAttachmentFieldMappings() {
            return null;
        }

        @Nullable
        default public Object getCrawlAttachments() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConfluenceAttachmentConfigurationProperty> {
            private Object attachmentFieldMappings;
            private Object crawlAttachments;

            public Builder attachmentFieldMappings(IResolvable attachmentFieldMappings) {
                this.attachmentFieldMappings = attachmentFieldMappings;
                return this;
            }

            public Builder attachmentFieldMappings(List<? extends Object> attachmentFieldMappings) {
                this.attachmentFieldMappings = attachmentFieldMappings;
                return this;
            }

            public Builder crawlAttachments(Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public Builder crawlAttachments(IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            public ConfluenceAttachmentConfigurationProperty build() {
                return new Jsii.Proxy(this.attachmentFieldMappings, this.crawlAttachments);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.ColumnConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColumnConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getChangeDetectingColumns();

        @NotNull
        public String getDocumentDataColumnName();

        @NotNull
        public String getDocumentIdColumnName();

        @Nullable
        default public String getDocumentTitleColumnName() {
            return null;
        }

        @Nullable
        default public Object getFieldMappings() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColumnConfigurationProperty> {
            private List<String> changeDetectingColumns;
            private String documentDataColumnName;
            private String documentIdColumnName;
            private String documentTitleColumnName;
            private Object fieldMappings;

            public Builder changeDetectingColumns(List<String> changeDetectingColumns) {
                this.changeDetectingColumns = changeDetectingColumns;
                return this;
            }

            public Builder documentDataColumnName(String documentDataColumnName) {
                this.documentDataColumnName = documentDataColumnName;
                return this;
            }

            public Builder documentIdColumnName(String documentIdColumnName) {
                this.documentIdColumnName = documentIdColumnName;
                return this;
            }

            public Builder documentTitleColumnName(String documentTitleColumnName) {
                this.documentTitleColumnName = documentTitleColumnName;
                return this;
            }

            public Builder fieldMappings(IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public Builder fieldMappings(List<? extends Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            public ColumnConfigurationProperty build() {
                return new Jsii.Proxy(this.changeDetectingColumns, this.documentDataColumnName, this.documentIdColumnName, this.documentTitleColumnName, this.fieldMappings);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.AclConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AclConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAllowedGroupsColumnName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AclConfigurationProperty> {
            private String allowedGroupsColumnName;

            public Builder allowedGroupsColumnName(String allowedGroupsColumnName) {
                this.allowedGroupsColumnName = allowedGroupsColumnName;
                return this;
            }

            public AclConfigurationProperty build() {
                return new Jsii.Proxy(this.allowedGroupsColumnName);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="monocdk.aws_kendra.CfnDataSource.AccessControlListConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AccessControlListConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKeyPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AccessControlListConfigurationProperty> {
            private String keyPath;

            public Builder keyPath(String keyPath) {
                this.keyPath = keyPath;
                return this;
            }

            public AccessControlListConfigurationProperty build() {
                return new Jsii.Proxy(this.keyPath);
            }
        }
    }
}

