/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesis.analytics.flink;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode;
import software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationProps;
import software.amazon.awscdk.services.kinesis.analytics.flink.IApplication;
import software.amazon.awscdk.services.kinesis.analytics.flink.LogLevel;
import software.amazon.awscdk.services.kinesis.analytics.flink.MetricsLevel;
import software.amazon.awscdk.services.kinesis.analytics.flink.PropertyGroups;
import software.amazon.awscdk.services.kinesis.analytics.flink.Runtime;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_kinesisanalytics_flink.Application")
public class Application
extends Resource
implements IApplication {
    protected Application(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Application(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Application(@NotNull Construct scope, @NotNull String id, @NotNull ApplicationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IApplication fromApplicationArn(@NotNull Construct scope, @NotNull String id, @NotNull String applicationArn) {
        return (IApplication)JsiiObject.jsiiStaticCall(Application.class, (String)"fromApplicationArn", (NativeType)NativeType.forClass(IApplication.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(applicationArn, "applicationArn is required")});
    }

    @NotNull
    public static IApplication fromApplicationName(@NotNull Construct scope, @NotNull String id, @NotNull String applicationName) {
        return (IApplication)JsiiObject.jsiiStaticCall(Application.class, (String)"fromApplicationName", (NativeType)NativeType.forClass(IApplication.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(applicationName, "applicationName is required")});
    }

    @Override
    @NotNull
    public Boolean addToRolePolicy(@NotNull PolicyStatement policyStatement) {
        return (Boolean)Kernel.call((Object)this, (String)"addToRolePolicy", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(policyStatement, "policyStatement is required")});
    }

    @Override
    @NotNull
    public String getApplicationArn() {
        return (String)Kernel.get((Object)this, (String)"applicationArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getApplicationName() {
        return (String)Kernel.get((Object)this, (String)"applicationName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @Override
    @Nullable
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Application> {
        private final Construct scope;
        private final String id;
        private final ApplicationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ApplicationProps.Builder();
        }

        public Builder code(ApplicationCode code) {
            this.props.code(code);
            return this;
        }

        public Builder runtime(Runtime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        public Builder applicationName(String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        public Builder autoScalingEnabled(Boolean autoScalingEnabled) {
            this.props.autoScalingEnabled(autoScalingEnabled);
            return this;
        }

        public Builder checkpointingEnabled(Boolean checkpointingEnabled) {
            this.props.checkpointingEnabled(checkpointingEnabled);
            return this;
        }

        public Builder checkpointInterval(Duration checkpointInterval) {
            this.props.checkpointInterval(checkpointInterval);
            return this;
        }

        public Builder logGroup(ILogGroup logGroup) {
            this.props.logGroup(logGroup);
            return this;
        }

        public Builder logLevel(LogLevel logLevel) {
            this.props.logLevel(logLevel);
            return this;
        }

        public Builder metricsLevel(MetricsLevel metricsLevel) {
            this.props.metricsLevel(metricsLevel);
            return this;
        }

        public Builder minPauseBetweenCheckpoints(Duration minPauseBetweenCheckpoints) {
            this.props.minPauseBetweenCheckpoints(minPauseBetweenCheckpoints);
            return this;
        }

        public Builder parallelism(Number parallelism) {
            this.props.parallelism(parallelism);
            return this;
        }

        public Builder parallelismPerKpu(Number parallelismPerKpu) {
            this.props.parallelismPerKpu(parallelismPerKpu);
            return this;
        }

        public Builder propertyGroups(PropertyGroups propertyGroups) {
            this.props.propertyGroups(propertyGroups);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder snapshotsEnabled(Boolean snapshotsEnabled) {
            this.props.snapshotsEnabled(snapshotsEnabled);
            return this;
        }

        public Application build() {
            return new Application(this.scope, this.id, this.props.build());
        }
    }
}

