/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda.eventsources;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.lambda.IEventSourceDlq;
import software.amazon.awscdk.services.lambda.StartingPosition;
import software.amazon.awscdk.services.lambda.eventsources.KafkaEventSourceProps;
import software.amazon.awscdk.services.lambda.eventsources.StreamEventSourceProps;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk.aws_lambda_event_sources.KafkaEventSourceProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface KafkaEventSourceProps
extends JsiiSerializable,
StreamEventSourceProps {
    @NotNull
    public String getTopic();

    @Nullable
    default public ISecret getSecret() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<KafkaEventSourceProps> {
        private String topic;
        private ISecret secret;
        private StartingPosition startingPosition;
        private Number batchSize;
        private Boolean bisectBatchOnError;
        private Boolean enabled;
        private Duration maxBatchingWindow;
        private Duration maxRecordAge;
        private IEventSourceDlq onFailure;
        private Number parallelizationFactor;
        private Boolean reportBatchItemFailures;
        private Number retryAttempts;
        private Duration tumblingWindow;

        public Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder secret(ISecret secret) {
            this.secret = secret;
            return this;
        }

        public Builder startingPosition(StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        public Builder batchSize(Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder bisectBatchOnError(Boolean bisectBatchOnError) {
            this.bisectBatchOnError = bisectBatchOnError;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder maxBatchingWindow(Duration maxBatchingWindow) {
            this.maxBatchingWindow = maxBatchingWindow;
            return this;
        }

        public Builder maxRecordAge(Duration maxRecordAge) {
            this.maxRecordAge = maxRecordAge;
            return this;
        }

        public Builder onFailure(IEventSourceDlq onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        public Builder parallelizationFactor(Number parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        public Builder reportBatchItemFailures(Boolean reportBatchItemFailures) {
            this.reportBatchItemFailures = reportBatchItemFailures;
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        public Builder tumblingWindow(Duration tumblingWindow) {
            this.tumblingWindow = tumblingWindow;
            return this;
        }

        public KafkaEventSourceProps build() {
            return new Jsii.Proxy(this.topic, this.secret, this.startingPosition, this.batchSize, this.bisectBatchOnError, this.enabled, this.maxBatchingWindow, this.maxRecordAge, this.onFailure, this.parallelizationFactor, this.reportBatchItemFailures, this.retryAttempts, this.tumblingWindow);
        }
    }
}

