/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.logs;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.awscdk.services.logs.LogGroupProps;
import software.amazon.awscdk.services.logs.LogStream;
import software.amazon.awscdk.services.logs.MetricFilter;
import software.amazon.awscdk.services.logs.MetricFilterOptions;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.logs.StreamOptions;
import software.amazon.awscdk.services.logs.SubscriptionFilter;
import software.amazon.awscdk.services.logs.SubscriptionFilterOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_logs.LogGroup")
public class LogGroup
extends Resource
implements ILogGroup {
    protected LogGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LogGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LogGroup(@NotNull Construct scope, @NotNull String id, @Nullable LogGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public LogGroup(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static ILogGroup fromLogGroupArn(@NotNull Construct scope, @NotNull String id, @NotNull String logGroupArn) {
        return (ILogGroup)JsiiObject.jsiiStaticCall(LogGroup.class, (String)"fromLogGroupArn", (NativeType)NativeType.forClass(ILogGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(logGroupArn, "logGroupArn is required")});
    }

    @NotNull
    public static ILogGroup fromLogGroupName(@NotNull Construct scope, @NotNull String id, @NotNull String logGroupName) {
        return (ILogGroup)JsiiObject.jsiiStaticCall(LogGroup.class, (String)"fromLogGroupName", (NativeType)NativeType.forClass(ILogGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(logGroupName, "logGroupName is required")});
    }

    @Override
    @NotNull
    public MetricFilter addMetricFilter(@NotNull String id, @NotNull MetricFilterOptions props) {
        return (MetricFilter)Kernel.call((Object)this, (String)"addMetricFilter", (NativeType)NativeType.forClass(MetricFilter.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public LogStream addStream(@NotNull String id, @Nullable StreamOptions props) {
        return (LogStream)Kernel.call((Object)this, (String)"addStream", (NativeType)NativeType.forClass(LogStream.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), props});
    }

    @Override
    @NotNull
    public LogStream addStream(@NotNull String id) {
        return (LogStream)Kernel.call((Object)this, (String)"addStream", (NativeType)NativeType.forClass(LogStream.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public SubscriptionFilter addSubscriptionFilter(@NotNull String id, @NotNull SubscriptionFilterOptions props) {
        return (SubscriptionFilter)Kernel.call((Object)this, (String)"addSubscriptionFilter", (NativeType)NativeType.forClass(SubscriptionFilter.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public Metric extractMetric(@NotNull String jsonField, @NotNull String metricNamespace, @NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"extractMetric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(jsonField, "jsonField is required"), Objects.requireNonNull(metricNamespace, "metricNamespace is required"), Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public String logGroupPhysicalName() {
        return (String)Kernel.call((Object)this, (String)"logGroupPhysicalName", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getLogGroupArn() {
        return (String)Kernel.get((Object)this, (String)"logGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getLogGroupName() {
        return (String)Kernel.get((Object)this, (String)"logGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LogGroup> {
        private final Construct scope;
        private final String id;
        private LogGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        public Builder logGroupName(String logGroupName) {
            this.props().logGroupName(logGroupName);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        public Builder retention(RetentionDays retention) {
            this.props().retention(retention);
            return this;
        }

        public LogGroup build() {
            return new LogGroup(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private LogGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new LogGroupProps.Builder();
            }
            return this.props;
        }
    }
}

