/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.rds.DatabaseInstanceNewProps;
import software.amazon.awscdk.services.rds.IOptionGroup;
import software.amazon.awscdk.services.rds.ISubnetGroup;
import software.amazon.awscdk.services.rds.PerformanceInsightRetention;
import software.amazon.awscdk.services.rds.ProcessorFeatures;
import software.amazon.awscdk.services.rds.StorageType;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="monocdk.aws_rds.DatabaseInstanceNewProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface DatabaseInstanceNewProps
extends JsiiSerializable {
    @NotNull
    public IVpc getVpc();

    @Nullable
    default public Boolean getAutoMinorVersionUpgrade() {
        return null;
    }

    @Nullable
    default public String getAvailabilityZone() {
        return null;
    }

    @Nullable
    default public Duration getBackupRetention() {
        return null;
    }

    @Nullable
    default public List<String> getCloudwatchLogsExports() {
        return null;
    }

    @Nullable
    default public RetentionDays getCloudwatchLogsRetention() {
        return null;
    }

    @Nullable
    default public IRole getCloudwatchLogsRetentionRole() {
        return null;
    }

    @Nullable
    default public Boolean getCopyTagsToSnapshot() {
        return null;
    }

    @Nullable
    default public Boolean getDeleteAutomatedBackups() {
        return null;
    }

    @Nullable
    default public Boolean getDeletionProtection() {
        return null;
    }

    @Nullable
    default public String getDomain() {
        return null;
    }

    @Nullable
    default public IRole getDomainRole() {
        return null;
    }

    @Nullable
    default public Boolean getEnablePerformanceInsights() {
        return null;
    }

    @Nullable
    default public Boolean getIamAuthentication() {
        return null;
    }

    @Nullable
    default public String getInstanceIdentifier() {
        return null;
    }

    @Nullable
    default public Number getIops() {
        return null;
    }

    @Nullable
    default public Number getMaxAllocatedStorage() {
        return null;
    }

    @Nullable
    default public Duration getMonitoringInterval() {
        return null;
    }

    @Nullable
    default public IRole getMonitoringRole() {
        return null;
    }

    @Nullable
    default public Boolean getMultiAz() {
        return null;
    }

    @Nullable
    default public IOptionGroup getOptionGroup() {
        return null;
    }

    @Nullable
    default public IKey getPerformanceInsightEncryptionKey() {
        return null;
    }

    @Nullable
    default public PerformanceInsightRetention getPerformanceInsightRetention() {
        return null;
    }

    @Nullable
    default public Number getPort() {
        return null;
    }

    @Nullable
    default public String getPreferredBackupWindow() {
        return null;
    }

    @Nullable
    default public String getPreferredMaintenanceWindow() {
        return null;
    }

    @Nullable
    default public ProcessorFeatures getProcessorFeatures() {
        return null;
    }

    @Nullable
    default public Boolean getPubliclyAccessible() {
        return null;
    }

    @Nullable
    default public RemovalPolicy getRemovalPolicy() {
        return null;
    }

    @Nullable
    default public List<IBucket> getS3ExportBuckets() {
        return null;
    }

    @Nullable
    default public IRole getS3ExportRole() {
        return null;
    }

    @Nullable
    default public List<IBucket> getS3ImportBuckets() {
        return null;
    }

    @Nullable
    default public IRole getS3ImportRole() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public StorageType getStorageType() {
        return null;
    }

    @Nullable
    default public ISubnetGroup getSubnetGroup() {
        return null;
    }

    @Deprecated
    @Nullable
    default public SubnetSelection getVpcPlacement() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseInstanceNewProps> {
        private IVpc vpc;
        private Boolean autoMinorVersionUpgrade;
        private String availabilityZone;
        private Duration backupRetention;
        private List<String> cloudwatchLogsExports;
        private RetentionDays cloudwatchLogsRetention;
        private IRole cloudwatchLogsRetentionRole;
        private Boolean copyTagsToSnapshot;
        private Boolean deleteAutomatedBackups;
        private Boolean deletionProtection;
        private String domain;
        private IRole domainRole;
        private Boolean enablePerformanceInsights;
        private Boolean iamAuthentication;
        private String instanceIdentifier;
        private Number iops;
        private Number maxAllocatedStorage;
        private Duration monitoringInterval;
        private IRole monitoringRole;
        private Boolean multiAz;
        private IOptionGroup optionGroup;
        private IKey performanceInsightEncryptionKey;
        private PerformanceInsightRetention performanceInsightRetention;
        private Number port;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private ProcessorFeatures processorFeatures;
        private Boolean publiclyAccessible;
        private RemovalPolicy removalPolicy;
        private List<IBucket> s3ExportBuckets;
        private IRole s3ExportRole;
        private List<IBucket> s3ImportBuckets;
        private IRole s3ImportRole;
        private List<ISecurityGroup> securityGroups;
        private StorageType storageType;
        private ISubnetGroup subnetGroup;
        private SubnetSelection vpcPlacement;
        private SubnetSelection vpcSubnets;

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Builder backupRetention(Duration backupRetention) {
            this.backupRetention = backupRetention;
            return this;
        }

        public Builder cloudwatchLogsExports(List<String> cloudwatchLogsExports) {
            this.cloudwatchLogsExports = cloudwatchLogsExports;
            return this;
        }

        public Builder cloudwatchLogsRetention(RetentionDays cloudwatchLogsRetention) {
            this.cloudwatchLogsRetention = cloudwatchLogsRetention;
            return this;
        }

        public Builder cloudwatchLogsRetentionRole(IRole cloudwatchLogsRetentionRole) {
            this.cloudwatchLogsRetentionRole = cloudwatchLogsRetentionRole;
            return this;
        }

        public Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainRole(IRole domainRole) {
            this.domainRole = domainRole;
            return this;
        }

        public Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public Builder iamAuthentication(Boolean iamAuthentication) {
            this.iamAuthentication = iamAuthentication;
            return this;
        }

        public Builder instanceIdentifier(String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        public Builder iops(Number iops) {
            this.iops = iops;
            return this;
        }

        public Builder maxAllocatedStorage(Number maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public Builder monitoringInterval(Duration monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public Builder monitoringRole(IRole monitoringRole) {
            this.monitoringRole = monitoringRole;
            return this;
        }

        public Builder multiAz(Boolean multiAz) {
            this.multiAz = multiAz;
            return this;
        }

        public Builder optionGroup(IOptionGroup optionGroup) {
            this.optionGroup = optionGroup;
            return this;
        }

        public Builder performanceInsightEncryptionKey(IKey performanceInsightEncryptionKey) {
            this.performanceInsightEncryptionKey = performanceInsightEncryptionKey;
            return this;
        }

        public Builder performanceInsightRetention(PerformanceInsightRetention performanceInsightRetention) {
            this.performanceInsightRetention = performanceInsightRetention;
            return this;
        }

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public Builder processorFeatures(ProcessorFeatures processorFeatures) {
            this.processorFeatures = processorFeatures;
            return this;
        }

        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder s3ExportBuckets(List<? extends IBucket> s3ExportBuckets) {
            this.s3ExportBuckets = s3ExportBuckets;
            return this;
        }

        public Builder s3ExportRole(IRole s3ExportRole) {
            this.s3ExportRole = s3ExportRole;
            return this;
        }

        public Builder s3ImportBuckets(List<? extends IBucket> s3ImportBuckets) {
            this.s3ImportBuckets = s3ImportBuckets;
            return this;
        }

        public Builder s3ImportRole(IRole s3ImportRole) {
            this.s3ImportRole = s3ImportRole;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder subnetGroup(ISubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        @Deprecated
        public Builder vpcPlacement(SubnetSelection vpcPlacement) {
            this.vpcPlacement = vpcPlacement;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public DatabaseInstanceNewProps build() {
            return new Jsii.Proxy(this.vpc, this.autoMinorVersionUpgrade, this.availabilityZone, this.backupRetention, this.cloudwatchLogsExports, this.cloudwatchLogsRetention, this.cloudwatchLogsRetentionRole, this.copyTagsToSnapshot, this.deleteAutomatedBackups, this.deletionProtection, this.domain, this.domainRole, this.enablePerformanceInsights, this.iamAuthentication, this.instanceIdentifier, this.iops, this.maxAllocatedStorage, this.monitoringInterval, this.monitoringRole, this.multiAz, this.optionGroup, this.performanceInsightEncryptionKey, this.performanceInsightRetention, this.port, this.preferredBackupWindow, this.preferredMaintenanceWindow, this.processorFeatures, this.publiclyAccessible, this.removalPolicy, this.s3ExportBuckets, this.s3ExportRole, this.s3ImportBuckets, this.s3ImportRole, this.securityGroups, this.storageType, this.subnetGroup, this.vpcPlacement, this.vpcSubnets);
        }
    }
}

