/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.rds.Credentials;
import software.amazon.awscdk.services.rds.Endpoint;
import software.amazon.awscdk.services.rds.IClusterEngine;
import software.amazon.awscdk.services.rds.IParameterGroup;
import software.amazon.awscdk.services.rds.IServerlessCluster;
import software.amazon.awscdk.services.rds.ISubnetGroup;
import software.amazon.awscdk.services.rds.RotationMultiUserOptions;
import software.amazon.awscdk.services.rds.RotationSingleUserOptions;
import software.amazon.awscdk.services.rds.ServerlessClusterAttributes;
import software.amazon.awscdk.services.rds.ServerlessClusterProps;
import software.amazon.awscdk.services.rds.ServerlessScalingOptions;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps;
import software.amazon.awscdk.services.secretsmanager.SecretRotation;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_rds.ServerlessCluster")
public class ServerlessCluster
extends Resource
implements IServerlessCluster {
    protected ServerlessCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServerlessCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ServerlessCluster(@NotNull Construct scope, @NotNull String id, @NotNull ServerlessClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IServerlessCluster fromServerlessClusterAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ServerlessClusterAttributes attrs) {
        return (IServerlessCluster)JsiiObject.jsiiStaticCall(ServerlessCluster.class, (String)"fromServerlessClusterAttributes", (NativeType)NativeType.forClass(IServerlessCluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public SecretRotation addRotationMultiUser(@NotNull String id, @NotNull RotationMultiUserOptions options) {
        return (SecretRotation)Kernel.call((Object)this, (String)"addRotationMultiUser", (NativeType)NativeType.forClass(SecretRotation.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public SecretRotation addRotationSingleUser(@Nullable RotationSingleUserOptions options) {
        return (SecretRotation)Kernel.call((Object)this, (String)"addRotationSingleUser", (NativeType)NativeType.forClass(SecretRotation.class), (Object[])new Object[]{options});
    }

    @NotNull
    public SecretRotation addRotationSingleUser() {
        return (SecretRotation)Kernel.call((Object)this, (String)"addRotationSingleUser", (NativeType)NativeType.forClass(SecretRotation.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public SecretAttachmentTargetProps asSecretAttachmentTarget() {
        return (SecretAttachmentTargetProps)Kernel.call((Object)this, (String)"asSecretAttachmentTarget", (NativeType)NativeType.forClass(SecretAttachmentTargetProps.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Grant grantDataApiAccess(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantDataApiAccess", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public String getClusterArn() {
        return (String)Kernel.get((Object)this, (String)"clusterArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Endpoint getClusterEndpoint() {
        return (Endpoint)((Object)Kernel.get((Object)this, (String)"clusterEndpoint", (NativeType)NativeType.forClass(Endpoint.class)));
    }

    @Override
    @NotNull
    public String getClusterIdentifier() {
        return (String)Kernel.get((Object)this, (String)"clusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Endpoint getClusterReadEndpoint() {
        return (Endpoint)((Object)Kernel.get((Object)this, (String)"clusterReadEndpoint", (NativeType)NativeType.forClass(Endpoint.class)));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Nullable
    public ISecret getSecret() {
        return (ISecret)Kernel.get((Object)this, (String)"secret", (NativeType)NativeType.forClass(ISecret.class));
    }

    @Nullable
    protected Boolean getEnableDataApi() {
        return (Boolean)Kernel.get((Object)this, (String)"enableDataApi", (NativeType)NativeType.forClass(Boolean.class));
    }

    protected void setEnableDataApi(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableDataApi", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ServerlessCluster> {
        private final Construct scope;
        private final String id;
        private final ServerlessClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ServerlessClusterProps.Builder();
        }

        public Builder engine(IClusterEngine engine) {
            this.props.engine(engine);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder backupRetention(Duration backupRetention) {
            this.props.backupRetention(backupRetention);
            return this;
        }

        public Builder clusterIdentifier(String clusterIdentifier) {
            this.props.clusterIdentifier(clusterIdentifier);
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        public Builder defaultDatabaseName(String defaultDatabaseName) {
            this.props.defaultDatabaseName(defaultDatabaseName);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder enableDataApi(Boolean enableDataApi) {
            this.props.enableDataApi(enableDataApi);
            return this;
        }

        public Builder parameterGroup(IParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder scaling(ServerlessScalingOptions scaling) {
            this.props.scaling(scaling);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder storageEncryptionKey(IKey storageEncryptionKey) {
            this.props.storageEncryptionKey(storageEncryptionKey);
            return this;
        }

        public Builder subnetGroup(ISubnetGroup subnetGroup) {
            this.props.subnetGroup(subnetGroup);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public ServerlessCluster build() {
            return new ServerlessCluster(this.scope, this.id, this.props.build());
        }
    }
}

