/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.$Module;
import software.amazon.awscdk.services.stepfunctions.CatchProps;
import software.amazon.awscdk.services.stepfunctions.Chain;
import software.amazon.awscdk.services.stepfunctions.IChainable;
import software.amazon.awscdk.services.stepfunctions.INextable;
import software.amazon.awscdk.services.stepfunctions.ParallelProps;
import software.amazon.awscdk.services.stepfunctions.RetryProps;
import software.amazon.awscdk.services.stepfunctions.State;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="monocdk.aws_stepfunctions.Parallel")
public class Parallel
extends State
implements INextable {
    protected Parallel(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Parallel(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Parallel(@NotNull Construct scope, @NotNull String id, @Nullable ParallelProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Parallel(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public Parallel addCatch(@NotNull IChainable handler, @Nullable CatchProps props) {
        return (Parallel)Kernel.call((Object)this, (String)"addCatch", (NativeType)NativeType.forClass(Parallel.class), (Object[])new Object[]{Objects.requireNonNull(handler, "handler is required"), props});
    }

    @NotNull
    public Parallel addCatch(@NotNull IChainable handler) {
        return (Parallel)Kernel.call((Object)this, (String)"addCatch", (NativeType)NativeType.forClass(Parallel.class), (Object[])new Object[]{Objects.requireNonNull(handler, "handler is required")});
    }

    @NotNull
    public Parallel addRetry(@Nullable RetryProps props) {
        return (Parallel)Kernel.call((Object)this, (String)"addRetry", (NativeType)NativeType.forClass(Parallel.class), (Object[])new Object[]{props});
    }

    @NotNull
    public Parallel addRetry() {
        return (Parallel)Kernel.call((Object)this, (String)"addRetry", (NativeType)NativeType.forClass(Parallel.class), (Object[])new Object[0]);
    }

    @NotNull
    public Parallel branch(IChainable ... branches) {
        return (Parallel)Kernel.call((Object)this, (String)"branch", (NativeType)NativeType.forClass(Parallel.class), (Object[])Arrays.stream(branches).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public Chain next(@NotNull IChainable next) {
        return (Chain)Kernel.call((Object)this, (String)"next", (NativeType)NativeType.forClass(Chain.class), (Object[])new Object[]{Objects.requireNonNull(next, "next is required")});
    }

    @Override
    @NotNull
    public ObjectNode toStateJson() {
        return (ObjectNode)Kernel.call((Object)this, (String)"toStateJson", (NativeType)NativeType.forClass(ObjectNode.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected List<String> validate() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"validate", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public List<INextable> getEndStates() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"endStates", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(INextable.class))));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Parallel> {
        private final Construct scope;
        private final String id;
        private ParallelProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder comment(String comment) {
            this.props().comment(comment);
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.props().inputPath(inputPath);
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.props().outputPath(outputPath);
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.props().resultPath(resultPath);
            return this;
        }

        public Builder resultSelector(Map<String, ? extends Object> resultSelector) {
            this.props().resultSelector(resultSelector);
            return this;
        }

        public Parallel build() {
            return new Parallel(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ParallelProps.Builder props() {
            if (this.props == null) {
                this.props = new ParallelProps.Builder();
            }
            return this.props;
        }
    }
}

