/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.pipelines;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.CfnOutput;
import software.amazon.awscdk.pipelines.FileSet;
import software.amazon.awscdk.pipelines.FileSetLocation;
import software.amazon.awscdk.pipelines.IFileSetProducer;
import software.amazon.awscdk.pipelines.ShellStepProps;
import software.amazon.awscdk.pipelines.StackOutputReference;
import software.amazon.awscdk.pipelines.Step;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.pipelines.ShellStep")
public class ShellStep
extends Step {
    protected ShellStep(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ShellStep(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ShellStep(@NotNull String id, @NotNull ShellStepProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public FileSet addOutputDirectory(@NotNull String directory) {
        return (FileSet)Kernel.call((Object)this, (String)"addOutputDirectory", (NativeType)NativeType.forClass(FileSet.class), (Object[])new Object[]{Objects.requireNonNull(directory, "directory is required")});
    }

    @NotNull
    public FileSet primaryOutputDirectory(@NotNull String directory) {
        return (FileSet)Kernel.call((Object)this, (String)"primaryOutputDirectory", (NativeType)NativeType.forClass(FileSet.class), (Object[])new Object[]{Objects.requireNonNull(directory, "directory is required")});
    }

    @NotNull
    public List<String> getCommands() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"commands", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Map<String, String> getEnv() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"env", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Map<String, StackOutputReference> getEnvFromCfnOutputs() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"envFromCfnOutputs", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(StackOutputReference.class))));
    }

    @NotNull
    public List<FileSetLocation> getInputs() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"inputs", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(FileSetLocation.class))));
    }

    @NotNull
    public List<String> getInstallCommands() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"installCommands", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public List<FileSetLocation> getOutputs() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"outputs", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(FileSetLocation.class))));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ShellStep> {
        private final String id;
        private final ShellStepProps.Builder props;

        public static Builder create(String id) {
            return new Builder(id);
        }

        private Builder(String id) {
            this.id = id;
            this.props = new ShellStepProps.Builder();
        }

        public Builder commands(List<String> commands) {
            this.props.commands(commands);
            return this;
        }

        public Builder additionalInputs(Map<String, ? extends IFileSetProducer> additionalInputs) {
            this.props.additionalInputs(additionalInputs);
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.props.env(env);
            return this;
        }

        public Builder envFromCfnOutputs(Map<String, ? extends CfnOutput> envFromCfnOutputs) {
            this.props.envFromCfnOutputs(envFromCfnOutputs);
            return this;
        }

        public Builder input(IFileSetProducer input) {
            this.props.input(input);
            return this;
        }

        public Builder installCommands(List<String> installCommands) {
            this.props.installCommands(installCommands);
            return this;
        }

        public Builder primaryOutputDirectory(String primaryOutputDirectory) {
            this.props.primaryOutputDirectory(primaryOutputDirectory);
            return this;
        }

        public ShellStep build() {
            return new ShellStep(this.id, this.props.build());
        }
    }
}

