/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.apigateway.IResource;
import software.amazon.awscdk.services.apigateway.IRestApi;
import software.amazon.awscdk.services.apigateway.Integration;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.awscdk.services.apigateway.MethodProps;
import software.amazon.awscdk.services.apigateway.MethodResponse;
import software.amazon.awscdk.services.apigateway.RestApi;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="monocdk.aws_apigateway.Method")
public class Method
extends Resource {
    protected Method(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Method(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Method(@NotNull Construct scope, @NotNull String id, @NotNull MethodProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addMethodResponse(@NotNull MethodResponse methodResponse) {
        Kernel.call((Object)this, (String)"addMethodResponse", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(methodResponse, "methodResponse is required")});
    }

    @NotNull
    public IRestApi getApi() {
        return (IRestApi)Kernel.get((Object)this, (String)"api", (NativeType)NativeType.forClass(IRestApi.class));
    }

    @NotNull
    public String getHttpMethod() {
        return (String)Kernel.get((Object)this, (String)"httpMethod", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getMethodArn() {
        return (String)Kernel.get((Object)this, (String)"methodArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getMethodId() {
        return (String)Kernel.get((Object)this, (String)"methodId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResource getResource() {
        return (IResource)Kernel.get((Object)this, (String)"resource", (NativeType)NativeType.forClass(IResource.class));
    }

    @Deprecated
    @NotNull
    public RestApi getRestApi() {
        return (RestApi)Kernel.get((Object)this, (String)"restApi", (NativeType)NativeType.forClass(RestApi.class));
    }

    @NotNull
    public String getTestMethodArn() {
        return (String)Kernel.get((Object)this, (String)"testMethodArn", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Method> {
        private final Construct scope;
        private final String id;
        private final MethodProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new MethodProps.Builder();
        }

        public Builder httpMethod(String httpMethod) {
            this.props.httpMethod(httpMethod);
            return this;
        }

        public Builder resource(IResource resource) {
            this.props.resource(resource);
            return this;
        }

        public Builder integration(Integration integration) {
            this.props.integration(integration);
            return this;
        }

        public Builder options(MethodOptions options) {
            this.props.options(options);
            return this;
        }

        public Method build() {
            return new Method(this.scope, this.id, this.props.build());
        }
    }
}

