/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appsync;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.appsync.CfnDataSource;
import software.amazon.awscdk.services.appsync.CfnDataSourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_appsync.CfnDataSource")
public class CfnDataSource
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDataSource.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDataSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDataSource(@NotNull Construct scope, @NotNull String id, @NotNull CfnDataSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrDataSourceArn() {
        return (String)Kernel.get((Object)this, (String)"attrDataSourceArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrName() {
        return (String)Kernel.get((Object)this, (String)"attrName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getApiId() {
        return (String)Kernel.get((Object)this, (String)"apiId", (NativeType)NativeType.forClass(String.class));
    }

    public void setApiId(@NotNull String value) {
        Kernel.set((Object)this, (String)"apiId", (Object)Objects.requireNonNull(value, "apiId is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@NotNull String value) {
        Kernel.set((Object)this, (String)"type", (Object)Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getDynamoDbConfig() {
        return Kernel.get((Object)this, (String)"dynamoDbConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDynamoDbConfig(@Nullable DynamoDBConfigProperty value) {
        Kernel.set((Object)this, (String)"dynamoDbConfig", (Object)value);
    }

    public void setDynamoDbConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"dynamoDbConfig", (Object)value);
    }

    @Nullable
    public Object getElasticsearchConfig() {
        return Kernel.get((Object)this, (String)"elasticsearchConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setElasticsearchConfig(@Nullable ElasticsearchConfigProperty value) {
        Kernel.set((Object)this, (String)"elasticsearchConfig", (Object)value);
    }

    public void setElasticsearchConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"elasticsearchConfig", (Object)value);
    }

    @Nullable
    public Object getHttpConfig() {
        return Kernel.get((Object)this, (String)"httpConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHttpConfig(@Nullable HttpConfigProperty value) {
        Kernel.set((Object)this, (String)"httpConfig", (Object)value);
    }

    public void setHttpConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"httpConfig", (Object)value);
    }

    @Nullable
    public Object getLambdaConfig() {
        return Kernel.get((Object)this, (String)"lambdaConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLambdaConfig(@Nullable LambdaConfigProperty value) {
        Kernel.set((Object)this, (String)"lambdaConfig", (Object)value);
    }

    public void setLambdaConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"lambdaConfig", (Object)value);
    }

    @Nullable
    public Object getOpenSearchServiceConfig() {
        return Kernel.get((Object)this, (String)"openSearchServiceConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOpenSearchServiceConfig(@Nullable OpenSearchServiceConfigProperty value) {
        Kernel.set((Object)this, (String)"openSearchServiceConfig", (Object)value);
    }

    public void setOpenSearchServiceConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"openSearchServiceConfig", (Object)value);
    }

    @Nullable
    public Object getRelationalDatabaseConfig() {
        return Kernel.get((Object)this, (String)"relationalDatabaseConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRelationalDatabaseConfig(@Nullable RelationalDatabaseConfigProperty value) {
        Kernel.set((Object)this, (String)"relationalDatabaseConfig", (Object)value);
    }

    public void setRelationalDatabaseConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"relationalDatabaseConfig", (Object)value);
    }

    @Nullable
    public String getServiceRoleArn() {
        return (String)Kernel.get((Object)this, (String)"serviceRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setServiceRoleArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"serviceRoleArn", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDataSource> {
        private final Construct scope;
        private final String id;
        private final CfnDataSourceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDataSourceProps.Builder();
        }

        public Builder apiId(String apiId) {
            this.props.apiId(apiId);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder dynamoDbConfig(DynamoDBConfigProperty dynamoDbConfig) {
            this.props.dynamoDbConfig(dynamoDbConfig);
            return this;
        }

        public Builder dynamoDbConfig(IResolvable dynamoDbConfig) {
            this.props.dynamoDbConfig(dynamoDbConfig);
            return this;
        }

        public Builder elasticsearchConfig(ElasticsearchConfigProperty elasticsearchConfig) {
            this.props.elasticsearchConfig(elasticsearchConfig);
            return this;
        }

        public Builder elasticsearchConfig(IResolvable elasticsearchConfig) {
            this.props.elasticsearchConfig(elasticsearchConfig);
            return this;
        }

        public Builder httpConfig(HttpConfigProperty httpConfig) {
            this.props.httpConfig(httpConfig);
            return this;
        }

        public Builder httpConfig(IResolvable httpConfig) {
            this.props.httpConfig(httpConfig);
            return this;
        }

        public Builder lambdaConfig(LambdaConfigProperty lambdaConfig) {
            this.props.lambdaConfig(lambdaConfig);
            return this;
        }

        public Builder lambdaConfig(IResolvable lambdaConfig) {
            this.props.lambdaConfig(lambdaConfig);
            return this;
        }

        public Builder openSearchServiceConfig(OpenSearchServiceConfigProperty openSearchServiceConfig) {
            this.props.openSearchServiceConfig(openSearchServiceConfig);
            return this;
        }

        public Builder openSearchServiceConfig(IResolvable openSearchServiceConfig) {
            this.props.openSearchServiceConfig(openSearchServiceConfig);
            return this;
        }

        public Builder relationalDatabaseConfig(RelationalDatabaseConfigProperty relationalDatabaseConfig) {
            this.props.relationalDatabaseConfig(relationalDatabaseConfig);
            return this;
        }

        public Builder relationalDatabaseConfig(IResolvable relationalDatabaseConfig) {
            this.props.relationalDatabaseConfig(relationalDatabaseConfig);
            return this;
        }

        public Builder serviceRoleArn(String serviceRoleArn) {
            this.props.serviceRoleArn(serviceRoleArn);
            return this;
        }

        public CfnDataSource build() {
            return new CfnDataSource(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_appsync.CfnDataSource.RelationalDatabaseConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RelationalDatabaseConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getRelationalDatabaseSourceType();

        @Nullable
        default public Object getRdsHttpEndpointConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RelationalDatabaseConfigProperty> {
            String relationalDatabaseSourceType;
            Object rdsHttpEndpointConfig;

            public Builder relationalDatabaseSourceType(String relationalDatabaseSourceType) {
                this.relationalDatabaseSourceType = relationalDatabaseSourceType;
                return this;
            }

            public Builder rdsHttpEndpointConfig(RdsHttpEndpointConfigProperty rdsHttpEndpointConfig) {
                this.rdsHttpEndpointConfig = rdsHttpEndpointConfig;
                return this;
            }

            public Builder rdsHttpEndpointConfig(IResolvable rdsHttpEndpointConfig) {
                this.rdsHttpEndpointConfig = rdsHttpEndpointConfig;
                return this;
            }

            public RelationalDatabaseConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_appsync.CfnDataSource.RdsHttpEndpointConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RdsHttpEndpointConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAwsRegion();

        @NotNull
        public String getAwsSecretStoreArn();

        @NotNull
        public String getDbClusterIdentifier();

        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public String getSchema() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RdsHttpEndpointConfigProperty> {
            String awsRegion;
            String awsSecretStoreArn;
            String dbClusterIdentifier;
            String databaseName;
            String schema;

            public Builder awsRegion(String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            public Builder awsSecretStoreArn(String awsSecretStoreArn) {
                this.awsSecretStoreArn = awsSecretStoreArn;
                return this;
            }

            public Builder dbClusterIdentifier(String dbClusterIdentifier) {
                this.dbClusterIdentifier = dbClusterIdentifier;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder schema(String schema) {
                this.schema = schema;
                return this;
            }

            public RdsHttpEndpointConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_appsync.CfnDataSource.OpenSearchServiceConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OpenSearchServiceConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAwsRegion();

        @NotNull
        public String getEndpoint();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OpenSearchServiceConfigProperty> {
            String awsRegion;
            String endpoint;

            public Builder awsRegion(String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public OpenSearchServiceConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_appsync.CfnDataSource.LambdaConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getLambdaFunctionArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaConfigProperty> {
            String lambdaFunctionArn;

            public Builder lambdaFunctionArn(String lambdaFunctionArn) {
                this.lambdaFunctionArn = lambdaFunctionArn;
                return this;
            }

            public LambdaConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_appsync.CfnDataSource.HttpConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HttpConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getEndpoint();

        @Nullable
        default public Object getAuthorizationConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HttpConfigProperty> {
            String endpoint;
            Object authorizationConfig;

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public Builder authorizationConfig(AuthorizationConfigProperty authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            public Builder authorizationConfig(IResolvable authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            public HttpConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_appsync.CfnDataSource.ElasticsearchConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ElasticsearchConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAwsRegion();

        @NotNull
        public String getEndpoint();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ElasticsearchConfigProperty> {
            String awsRegion;
            String endpoint;

            public Builder awsRegion(String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public ElasticsearchConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_appsync.CfnDataSource.DynamoDBConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDBConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAwsRegion();

        @NotNull
        public String getTableName();

        @Nullable
        default public Object getDeltaSyncConfig() {
            return null;
        }

        @Nullable
        default public Object getUseCallerCredentials() {
            return null;
        }

        @Nullable
        default public Object getVersioned() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDBConfigProperty> {
            String awsRegion;
            String tableName;
            Object deltaSyncConfig;
            Object useCallerCredentials;
            Object versioned;

            public Builder awsRegion(String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder deltaSyncConfig(DeltaSyncConfigProperty deltaSyncConfig) {
                this.deltaSyncConfig = deltaSyncConfig;
                return this;
            }

            public Builder deltaSyncConfig(IResolvable deltaSyncConfig) {
                this.deltaSyncConfig = deltaSyncConfig;
                return this;
            }

            public Builder useCallerCredentials(Boolean useCallerCredentials) {
                this.useCallerCredentials = useCallerCredentials;
                return this;
            }

            public Builder useCallerCredentials(IResolvable useCallerCredentials) {
                this.useCallerCredentials = useCallerCredentials;
                return this;
            }

            public Builder versioned(Boolean versioned) {
                this.versioned = versioned;
                return this;
            }

            public Builder versioned(IResolvable versioned) {
                this.versioned = versioned;
                return this;
            }

            public DynamoDBConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_appsync.CfnDataSource.DeltaSyncConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeltaSyncConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getBaseTableTtl();

        @NotNull
        public String getDeltaSyncTableName();

        @NotNull
        public String getDeltaSyncTableTtl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeltaSyncConfigProperty> {
            String baseTableTtl;
            String deltaSyncTableName;
            String deltaSyncTableTtl;

            public Builder baseTableTtl(String baseTableTtl) {
                this.baseTableTtl = baseTableTtl;
                return this;
            }

            public Builder deltaSyncTableName(String deltaSyncTableName) {
                this.deltaSyncTableName = deltaSyncTableName;
                return this;
            }

            public Builder deltaSyncTableTtl(String deltaSyncTableTtl) {
                this.deltaSyncTableTtl = deltaSyncTableTtl;
                return this;
            }

            public DeltaSyncConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_appsync.CfnDataSource.AwsIamConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AwsIamConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSigningRegion() {
            return null;
        }

        @Nullable
        default public String getSigningServiceName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AwsIamConfigProperty> {
            String signingRegion;
            String signingServiceName;

            public Builder signingRegion(String signingRegion) {
                this.signingRegion = signingRegion;
                return this;
            }

            public Builder signingServiceName(String signingServiceName) {
                this.signingServiceName = signingServiceName;
                return this;
            }

            public AwsIamConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_appsync.CfnDataSource.AuthorizationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthorizationConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getAuthorizationType();

        @Nullable
        default public Object getAwsIamConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthorizationConfigProperty> {
            String authorizationType;
            Object awsIamConfig;

            public Builder authorizationType(String authorizationType) {
                this.authorizationType = authorizationType;
                return this;
            }

            public Builder awsIamConfig(AwsIamConfigProperty awsIamConfig) {
                this.awsIamConfig = awsIamConfig;
                return this;
            }

            public Builder awsIamConfig(IResolvable awsIamConfig) {
                this.awsIamConfig = awsIamConfig;
                return this;
            }

            public AuthorizationConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

