/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appsync;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.services.appsync.AddFieldOptions;
import software.amazon.awscdk.services.appsync.AuthorizationType;
import software.amazon.awscdk.services.appsync.BaseTypeOptions;
import software.amazon.awscdk.services.appsync.EnumTypeOptions;
import software.amazon.awscdk.services.appsync.GraphqlType;
import software.amazon.awscdk.services.appsync.IField;
import software.amazon.awscdk.services.appsync.IIntermediateType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_appsync.EnumType")
public class EnumType
extends JsiiObject
implements IIntermediateType {
    protected EnumType(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EnumType(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EnumType(@NotNull String name, @NotNull EnumTypeOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(name, "name is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    public void addField(@NotNull AddFieldOptions options) {
        Kernel.call((Object)this, (String)"addField", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public GraphqlType attribute(@Nullable BaseTypeOptions options) {
        return (GraphqlType)Kernel.call((Object)this, (String)"attribute", (NativeType)NativeType.forClass(GraphqlType.class), (Object[])new Object[]{options});
    }

    @Override
    @NotNull
    public GraphqlType attribute() {
        return (GraphqlType)Kernel.call((Object)this, (String)"attribute", (NativeType)NativeType.forClass(GraphqlType.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String toString() {
        return (String)Kernel.call((Object)this, (String)"toString", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Map<String, IField> getDefinition() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"definition", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(IField.class))));
    }

    @Override
    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    protected List<AuthorizationType> getModes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"modes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(AuthorizationType.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    protected void setModes(@Nullable List<AuthorizationType> value) {
        Kernel.set((Object)this, (String)"modes", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EnumType> {
        private final String name;
        private final EnumTypeOptions.Builder options;

        public static Builder create(String name) {
            return new Builder(name);
        }

        private Builder(String name) {
            this.name = name;
            this.options = new EnumTypeOptions.Builder();
        }

        public Builder definition(List<String> definition) {
            this.options.definition(definition);
            return this;
        }

        public EnumType build() {
            return new EnumType(this.name, this.options.build());
        }
    }
}

