/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront.origins;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy;
import software.amazon.awscdk.services.cloudfront.OriginSslPolicy;
import software.amazon.awscdk.services.cloudfront.origins.HttpOrigin;
import software.amazon.awscdk.services.cloudfront.origins.LoadBalancerV2OriginProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.ILoadBalancerV2;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="monocdk.aws_cloudfront_origins.LoadBalancerV2Origin")
public class LoadBalancerV2Origin
extends HttpOrigin {
    protected LoadBalancerV2Origin(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LoadBalancerV2Origin(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LoadBalancerV2Origin(@NotNull ILoadBalancerV2 loadBalancer, @Nullable LoadBalancerV2OriginProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(loadBalancer, "loadBalancer is required"), props});
    }

    public LoadBalancerV2Origin(@NotNull ILoadBalancerV2 loadBalancer) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(loadBalancer, "loadBalancer is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LoadBalancerV2Origin> {
        private final ILoadBalancerV2 loadBalancer;
        private LoadBalancerV2OriginProps.Builder props;

        public static Builder create(ILoadBalancerV2 loadBalancer) {
            return new Builder(loadBalancer);
        }

        private Builder(ILoadBalancerV2 loadBalancer) {
            this.loadBalancer = loadBalancer;
        }

        public Builder connectionAttempts(Number connectionAttempts) {
            this.props().connectionAttempts(connectionAttempts);
            return this;
        }

        public Builder connectionTimeout(Duration connectionTimeout) {
            this.props().connectionTimeout(connectionTimeout);
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.props().customHeaders(customHeaders);
            return this;
        }

        public Builder originShieldRegion(String originShieldRegion) {
            this.props().originShieldRegion(originShieldRegion);
            return this;
        }

        public Builder originPath(String originPath) {
            this.props().originPath(originPath);
            return this;
        }

        public Builder httpPort(Number httpPort) {
            this.props().httpPort(httpPort);
            return this;
        }

        public Builder httpsPort(Number httpsPort) {
            this.props().httpsPort(httpsPort);
            return this;
        }

        public Builder keepaliveTimeout(Duration keepaliveTimeout) {
            this.props().keepaliveTimeout(keepaliveTimeout);
            return this;
        }

        public Builder originSslProtocols(List<? extends OriginSslPolicy> originSslProtocols) {
            this.props().originSslProtocols(originSslProtocols);
            return this;
        }

        public Builder protocolPolicy(OriginProtocolPolicy protocolPolicy) {
            this.props().protocolPolicy(protocolPolicy);
            return this;
        }

        public Builder readTimeout(Duration readTimeout) {
            this.props().readTimeout(readTimeout);
            return this;
        }

        public LoadBalancerV2Origin build() {
            return new LoadBalancerV2Origin(this.loadBalancer, this.props != null ? this.props.build() : null);
        }

        private LoadBalancerV2OriginProps.Builder props() {
            if (this.props == null) {
                this.props = new LoadBalancerV2OriginProps.Builder();
            }
            return this.props;
        }
    }
}

