/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codecommit;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.codecommit.Code;
import software.amazon.awscdk.services.codecommit.IRepository;
import software.amazon.awscdk.services.codecommit.OnCommitOptions;
import software.amazon.awscdk.services.codecommit.RepositoryNotifyOnOptions;
import software.amazon.awscdk.services.codecommit.RepositoryProps;
import software.amazon.awscdk.services.codecommit.RepositoryTriggerOptions;
import software.amazon.awscdk.services.codestarnotifications.INotificationRule;
import software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget;
import software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions;
import software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig;
import software.amazon.awscdk.services.events.OnEventOptions;
import software.amazon.awscdk.services.events.Rule;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="monocdk.aws_codecommit.Repository")
public class Repository
extends Resource
implements IRepository {
    protected Repository(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Repository(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Repository(@NotNull Construct scope, @NotNull String id, @NotNull RepositoryProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IRepository fromRepositoryArn(@NotNull Construct scope, @NotNull String id, @NotNull String repositoryArn) {
        return (IRepository)JsiiObject.jsiiStaticCall(Repository.class, (String)"fromRepositoryArn", (NativeType)NativeType.forClass(IRepository.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(repositoryArn, "repositoryArn is required")});
    }

    @NotNull
    public static IRepository fromRepositoryName(@NotNull Construct scope, @NotNull String id, @NotNull String repositoryName) {
        return (IRepository)JsiiObject.jsiiStaticCall(Repository.class, (String)"fromRepositoryName", (NativeType)NativeType.forClass(IRepository.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(repositoryName, "repositoryName is required")});
    }

    @Override
    @NotNull
    public NotificationRuleSourceConfig bindAsNotificationRuleSource(@NotNull Construct _scope) {
        return (NotificationRuleSourceConfig)Kernel.call((Object)this, (String)"bindAsNotificationRuleSource", (NativeType)NativeType.forClass(NotificationRuleSourceConfig.class), (Object[])new Object[]{Objects.requireNonNull(_scope, "_scope is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public Grant grantPull(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantPull", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantPullPush(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantPullPush", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifiyOnPullRequestMerged(@NotNull String id, @NotNull INotificationRuleTarget target, @Nullable NotificationRuleOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifiyOnPullRequestMerged", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), options});
    }

    @Override
    @NotNull
    public INotificationRule notifiyOnPullRequestMerged(@NotNull String id, @NotNull INotificationRuleTarget target) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifiyOnPullRequestMerged", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required")});
    }

    @NotNull
    public Repository notify(@NotNull String arn, @Nullable RepositoryTriggerOptions options) {
        return (Repository)Kernel.call((Object)this, (String)"notify", (NativeType)NativeType.forClass(Repository.class), (Object[])new Object[]{Objects.requireNonNull(arn, "arn is required"), options});
    }

    @NotNull
    public Repository notify(@NotNull String arn) {
        return (Repository)Kernel.call((Object)this, (String)"notify", (NativeType)NativeType.forClass(Repository.class), (Object[])new Object[]{Objects.requireNonNull(arn, "arn is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifyOn(@NotNull String id, @NotNull INotificationRuleTarget target, @NotNull RepositoryNotifyOnOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOn", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnApprovalRuleOverridden(@NotNull String id, @NotNull INotificationRuleTarget target, @Nullable NotificationRuleOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnApprovalRuleOverridden", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), options});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnApprovalRuleOverridden(@NotNull String id, @NotNull INotificationRuleTarget target) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnApprovalRuleOverridden", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnApprovalStatusChanged(@NotNull String id, @NotNull INotificationRuleTarget target, @Nullable NotificationRuleOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnApprovalStatusChanged", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), options});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnApprovalStatusChanged(@NotNull String id, @NotNull INotificationRuleTarget target) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnApprovalStatusChanged", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnBranchOrTagCreated(@NotNull String id, @NotNull INotificationRuleTarget target, @Nullable NotificationRuleOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnBranchOrTagCreated", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), options});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnBranchOrTagCreated(@NotNull String id, @NotNull INotificationRuleTarget target) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnBranchOrTagCreated", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnBranchOrTagDeleted(@NotNull String id, @NotNull INotificationRuleTarget target, @Nullable NotificationRuleOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnBranchOrTagDeleted", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), options});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnBranchOrTagDeleted(@NotNull String id, @NotNull INotificationRuleTarget target) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnBranchOrTagDeleted", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnPullRequestComment(@NotNull String id, @NotNull INotificationRuleTarget target, @Nullable NotificationRuleOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnPullRequestComment", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), options});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnPullRequestComment(@NotNull String id, @NotNull INotificationRuleTarget target) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnPullRequestComment", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnPullRequestCreated(@NotNull String id, @NotNull INotificationRuleTarget target, @Nullable NotificationRuleOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnPullRequestCreated", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), options});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnPullRequestCreated(@NotNull String id, @NotNull INotificationRuleTarget target) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnPullRequestCreated", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required")});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnPullRequestMerged(@NotNull String id, @NotNull INotificationRuleTarget target, @Nullable NotificationRuleOptions options) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnPullRequestMerged", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required"), options});
    }

    @Override
    @NotNull
    public INotificationRule notifyOnPullRequestMerged(@NotNull String id, @NotNull INotificationRuleTarget target) {
        return (INotificationRule)Kernel.call((Object)this, (String)"notifyOnPullRequestMerged", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(target, "target is required")});
    }

    @Override
    @NotNull
    public Rule onCommentOnCommit(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onCommentOnCommit", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onCommentOnCommit(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onCommentOnCommit", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onCommentOnPullRequest(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onCommentOnPullRequest", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onCommentOnPullRequest(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onCommentOnPullRequest", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onCommit(@NotNull String id, @Nullable OnCommitOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onCommit", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onCommit(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onCommit", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onEvent", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onEvent(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onEvent", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onPullRequestStateChange(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onPullRequestStateChange", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onPullRequestStateChange(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onPullRequestStateChange", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onReferenceCreated(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onReferenceCreated", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onReferenceCreated(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onReferenceCreated", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onReferenceDeleted(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onReferenceDeleted", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onReferenceDeleted(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onReferenceDeleted", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onReferenceUpdated(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onReferenceUpdated", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onReferenceUpdated(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onReferenceUpdated", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public Rule onStateChange(@NotNull String id, @Nullable OnEventOptions options) {
        return (Rule)Kernel.call((Object)this, (String)"onStateChange", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public Rule onStateChange(@NotNull String id) {
        return (Rule)Kernel.call((Object)this, (String)"onStateChange", (NativeType)NativeType.forClass(Rule.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public String getRepositoryArn() {
        return (String)Kernel.get((Object)this, (String)"repositoryArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getRepositoryCloneUrlGrc() {
        return (String)Kernel.get((Object)this, (String)"repositoryCloneUrlGrc", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getRepositoryCloneUrlHttp() {
        return (String)Kernel.get((Object)this, (String)"repositoryCloneUrlHttp", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getRepositoryCloneUrlSsh() {
        return (String)Kernel.get((Object)this, (String)"repositoryCloneUrlSsh", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getRepositoryName() {
        return (String)Kernel.get((Object)this, (String)"repositoryName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Repository> {
        private final Construct scope;
        private final String id;
        private final RepositoryProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new RepositoryProps.Builder();
        }

        public Builder repositoryName(String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        public Builder code(Code code) {
            this.props.code(code);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Repository build() {
            return new Repository(this.scope, this.id, this.props.build());
        }
    }
}

