/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline.actions;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.CfnCapabilities;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities;
import software.amazon.awscdk.services.codepipeline.ActionBindOptions;
import software.amazon.awscdk.services.codepipeline.ActionConfig;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.codepipeline.ArtifactPath;
import software.amazon.awscdk.services.codepipeline.IStage;
import software.amazon.awscdk.services.codepipeline.actions.Action;
import software.amazon.awscdk.services.codepipeline.actions.CloudFormationCreateUpdateStackActionProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_codepipeline_actions.CloudFormationCreateUpdateStackAction")
public class CloudFormationCreateUpdateStackAction
extends Action {
    protected CloudFormationCreateUpdateStackAction(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationCreateUpdateStackAction(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CloudFormationCreateUpdateStackAction(@NotNull CloudFormationCreateUpdateStackActionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public Boolean addToDeploymentRolePolicy(@NotNull PolicyStatement statement) {
        return (Boolean)Kernel.call((Object)this, (String)"addToDeploymentRolePolicy", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    protected ActionConfig bound(@NotNull Construct scope, @NotNull IStage stage, @NotNull ActionBindOptions options) {
        return (ActionConfig)Kernel.call((Object)this, (String)"bound", (NativeType)NativeType.forClass(ActionConfig.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(stage, "stage is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public IRole getDeploymentRole() {
        return (IRole)Kernel.get((Object)this, (String)"deploymentRole", (NativeType)NativeType.forClass(IRole.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CloudFormationCreateUpdateStackAction> {
        private final CloudFormationCreateUpdateStackActionProps.Builder props = new CloudFormationCreateUpdateStackActionProps.Builder();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder actionName(String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        public Builder variablesNamespace(String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder adminPermissions(Boolean adminPermissions) {
            this.props.adminPermissions(adminPermissions);
            return this;
        }

        public Builder stackName(String stackName) {
            this.props.stackName(stackName);
            return this;
        }

        public Builder templatePath(ArtifactPath templatePath) {
            this.props.templatePath(templatePath);
            return this;
        }

        public Builder account(String account) {
            this.props.account(account);
            return this;
        }

        @Deprecated
        public Builder capabilities(List<? extends CloudFormationCapabilities> capabilities) {
            this.props.capabilities(capabilities);
            return this;
        }

        public Builder cfnCapabilities(List<? extends CfnCapabilities> cfnCapabilities) {
            this.props.cfnCapabilities(cfnCapabilities);
            return this;
        }

        public Builder deploymentRole(IRole deploymentRole) {
            this.props.deploymentRole(deploymentRole);
            return this;
        }

        public Builder extraInputs(List<? extends Artifact> extraInputs) {
            this.props.extraInputs(extraInputs);
            return this;
        }

        public Builder output(Artifact output) {
            this.props.output(output);
            return this;
        }

        public Builder outputFileName(String outputFileName) {
            this.props.outputFileName(outputFileName);
            return this;
        }

        public Builder parameterOverrides(Map<String, ? extends Object> parameterOverrides) {
            this.props.parameterOverrides(parameterOverrides);
            return this;
        }

        public Builder region(String region) {
            this.props.region(region);
            return this;
        }

        public Builder replaceOnFailure(Boolean replaceOnFailure) {
            this.props.replaceOnFailure(replaceOnFailure);
            return this;
        }

        public Builder templateConfiguration(ArtifactPath templateConfiguration) {
            this.props.templateConfiguration(templateConfiguration);
            return this;
        }

        public CloudFormationCreateUpdateStackAction build() {
            return new CloudFormationCreateUpdateStackAction(this.props.build());
        }
    }
}

