/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codestarnotifications;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.codestarnotifications.DetailType;
import software.amazon.awscdk.services.codestarnotifications.INotificationRule;
import software.amazon.awscdk.services.codestarnotifications.INotificationRuleSource;
import software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget;
import software.amazon.awscdk.services.codestarnotifications.NotificationRuleProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="monocdk.aws_codestarnotifications.NotificationRule")
public class NotificationRule
extends Resource
implements INotificationRule {
    protected NotificationRule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NotificationRule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public NotificationRule(@NotNull Construct scope, @NotNull String id, @NotNull NotificationRuleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static INotificationRule fromNotificationRuleArn(@NotNull Construct scope, @NotNull String id, @NotNull String notificationRuleArn) {
        return (INotificationRule)JsiiObject.jsiiStaticCall(NotificationRule.class, (String)"fromNotificationRuleArn", (NativeType)NativeType.forClass(INotificationRule.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(notificationRuleArn, "notificationRuleArn is required")});
    }

    @Override
    @NotNull
    public Boolean addTarget(@NotNull INotificationRuleTarget target) {
        return (Boolean)Kernel.call((Object)this, (String)"addTarget", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    @Override
    @NotNull
    public String getNotificationRuleArn() {
        return (String)Kernel.get((Object)this, (String)"notificationRuleArn", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NotificationRule> {
        private final Construct scope;
        private final String id;
        private final NotificationRuleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new NotificationRuleProps.Builder();
        }

        public Builder detailType(DetailType detailType) {
            this.props.detailType(detailType);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder notificationRuleName(String notificationRuleName) {
            this.props.notificationRuleName(notificationRuleName);
            return this;
        }

        public Builder events(List<String> events) {
            this.props.events(events);
            return this;
        }

        public Builder source(INotificationRuleSource source) {
            this.props.source(source);
            return this;
        }

        public Builder targets(List<? extends INotificationRuleTarget> targets) {
            this.props.targets(targets);
            return this;
        }

        public NotificationRule build() {
            return new NotificationRule(this.scope, this.id, this.props.build());
        }
    }
}

