/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.autoscaling.BlockDevice;
import software.amazon.awscdk.services.autoscaling.CommonAutoScalingGroupProps;
import software.amazon.awscdk.services.autoscaling.GroupMetrics;
import software.amazon.awscdk.services.autoscaling.HealthCheck;
import software.amazon.awscdk.services.autoscaling.Monitoring;
import software.amazon.awscdk.services.autoscaling.NotificationConfiguration;
import software.amazon.awscdk.services.autoscaling.RollingUpdateConfiguration;
import software.amazon.awscdk.services.autoscaling.Signals;
import software.amazon.awscdk.services.autoscaling.TerminationPolicy;
import software.amazon.awscdk.services.autoscaling.UpdatePolicy;
import software.amazon.awscdk.services.autoscaling.UpdateType;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.AddAutoScalingGroupCapacityOptions;
import software.amazon.awscdk.services.ecs.AddCapacityOptions;
import software.amazon.awscdk.services.ecs.MachineImageType;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="monocdk.aws_ecs.AddCapacityOptions")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface AddCapacityOptions
extends JsiiSerializable,
AddAutoScalingGroupCapacityOptions,
CommonAutoScalingGroupProps {
    @NotNull
    public InstanceType getInstanceType();

    @Nullable
    default public IMachineImage getMachineImage() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AddCapacityOptions> {
        InstanceType instanceType;
        IMachineImage machineImage;
        Boolean canContainersAccessInstanceRole;
        MachineImageType machineImageType;
        Boolean spotInstanceDraining;
        Duration taskDrainTime;
        IKey topicEncryptionKey;
        Boolean allowAllOutbound;
        Boolean associatePublicIpAddress;
        String autoScalingGroupName;
        List<BlockDevice> blockDevices;
        Duration cooldown;
        Number desiredCapacity;
        List<GroupMetrics> groupMetrics;
        HealthCheck healthCheck;
        Boolean ignoreUnmodifiedSizeProperties;
        Monitoring instanceMonitoring;
        String keyName;
        Number maxCapacity;
        Duration maxInstanceLifetime;
        Number minCapacity;
        Boolean newInstancesProtectedFromScaleIn;
        List<NotificationConfiguration> notifications;
        ITopic notificationsTopic;
        Number replacingUpdateMinSuccessfulInstancesPercent;
        Number resourceSignalCount;
        Duration resourceSignalTimeout;
        RollingUpdateConfiguration rollingUpdateConfiguration;
        Signals signals;
        String spotPrice;
        List<TerminationPolicy> terminationPolicies;
        UpdatePolicy updatePolicy;
        UpdateType updateType;
        SubnetSelection vpcSubnets;

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder machineImage(IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        public Builder canContainersAccessInstanceRole(Boolean canContainersAccessInstanceRole) {
            this.canContainersAccessInstanceRole = canContainersAccessInstanceRole;
            return this;
        }

        public Builder machineImageType(MachineImageType machineImageType) {
            this.machineImageType = machineImageType;
            return this;
        }

        public Builder spotInstanceDraining(Boolean spotInstanceDraining) {
            this.spotInstanceDraining = spotInstanceDraining;
            return this;
        }

        @Deprecated
        public Builder taskDrainTime(Duration taskDrainTime) {
            this.taskDrainTime = taskDrainTime;
            return this;
        }

        public Builder topicEncryptionKey(IKey topicEncryptionKey) {
            this.topicEncryptionKey = topicEncryptionKey;
            return this;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public Builder blockDevices(List<? extends BlockDevice> blockDevices) {
            this.blockDevices = blockDevices;
            return this;
        }

        public Builder cooldown(Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder desiredCapacity(Number desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public Builder groupMetrics(List<? extends GroupMetrics> groupMetrics) {
            this.groupMetrics = groupMetrics;
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder ignoreUnmodifiedSizeProperties(Boolean ignoreUnmodifiedSizeProperties) {
            this.ignoreUnmodifiedSizeProperties = ignoreUnmodifiedSizeProperties;
            return this;
        }

        public Builder instanceMonitoring(Monitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder maxCapacity(Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public Builder maxInstanceLifetime(Duration maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        public Builder minCapacity(Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public Builder notifications(List<? extends NotificationConfiguration> notifications) {
            this.notifications = notifications;
            return this;
        }

        @Deprecated
        public Builder notificationsTopic(ITopic notificationsTopic) {
            this.notificationsTopic = notificationsTopic;
            return this;
        }

        @Deprecated
        public Builder replacingUpdateMinSuccessfulInstancesPercent(Number replacingUpdateMinSuccessfulInstancesPercent) {
            this.replacingUpdateMinSuccessfulInstancesPercent = replacingUpdateMinSuccessfulInstancesPercent;
            return this;
        }

        @Deprecated
        public Builder resourceSignalCount(Number resourceSignalCount) {
            this.resourceSignalCount = resourceSignalCount;
            return this;
        }

        @Deprecated
        public Builder resourceSignalTimeout(Duration resourceSignalTimeout) {
            this.resourceSignalTimeout = resourceSignalTimeout;
            return this;
        }

        @Deprecated
        public Builder rollingUpdateConfiguration(RollingUpdateConfiguration rollingUpdateConfiguration) {
            this.rollingUpdateConfiguration = rollingUpdateConfiguration;
            return this;
        }

        public Builder signals(Signals signals) {
            this.signals = signals;
            return this;
        }

        public Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public Builder terminationPolicies(List<? extends TerminationPolicy> terminationPolicies) {
            this.terminationPolicies = terminationPolicies;
            return this;
        }

        public Builder updatePolicy(UpdatePolicy updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        @Deprecated
        public Builder updateType(UpdateType updateType) {
            this.updateType = updateType;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public AddCapacityOptions build() {
            return new Jsii.Proxy(this);
        }
    }
}

