/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.applicationautoscaling.EnableScalingProps;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.AssociateCloudMapServiceOptions;
import software.amazon.awscdk.services.ecs.BaseService;
import software.amazon.awscdk.services.ecs.CapacityProviderStrategy;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker;
import software.amazon.awscdk.services.ecs.DeploymentController;
import software.amazon.awscdk.services.ecs.EcsTarget;
import software.amazon.awscdk.services.ecs.ExternalServiceAttributes;
import software.amazon.awscdk.services.ecs.ExternalServiceProps;
import software.amazon.awscdk.services.ecs.IBaseService;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.IEcsLoadBalancerTarget;
import software.amazon.awscdk.services.ecs.IExternalService;
import software.amazon.awscdk.services.ecs.LoadBalancerTargetOptions;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.ScalableTaskCount;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps;
import software.amazon.awscdk.services.servicediscovery.Service;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="monocdk.aws_ecs.ExternalService")
public class ExternalService
extends BaseService
implements IExternalService {
    protected ExternalService(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ExternalService(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ExternalService(@NotNull Construct scope, @NotNull String id, @NotNull ExternalServiceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IExternalService fromExternalServiceArn(@NotNull Construct scope, @NotNull String id, @NotNull String externalServiceArn) {
        return (IExternalService)JsiiObject.jsiiStaticCall(ExternalService.class, (String)"fromExternalServiceArn", (NativeType)NativeType.forClass(IExternalService.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(externalServiceArn, "externalServiceArn is required")});
    }

    @NotNull
    public static IBaseService fromExternalServiceAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ExternalServiceAttributes attrs) {
        return (IBaseService)JsiiObject.jsiiStaticCall(ExternalService.class, (String)"fromExternalServiceAttributes", (NativeType)NativeType.forClass(IBaseService.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    public void associateCloudMapService(@NotNull AssociateCloudMapServiceOptions _options) {
        Kernel.call((Object)this, (String)"associateCloudMapService", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(_options, "_options is required")});
    }

    @Override
    @NotNull
    public LoadBalancerTargetProps attachToApplicationTargetGroup(@NotNull IApplicationTargetGroup _targetGroup) {
        return (LoadBalancerTargetProps)Kernel.call((Object)this, (String)"attachToApplicationTargetGroup", (NativeType)NativeType.forClass(LoadBalancerTargetProps.class), (Object[])new Object[]{Objects.requireNonNull(_targetGroup, "_targetGroup is required")});
    }

    @Override
    @NotNull
    public ScalableTaskCount autoScaleTaskCount(@NotNull EnableScalingProps _props) {
        return (ScalableTaskCount)Kernel.call((Object)this, (String)"autoScaleTaskCount", (NativeType)NativeType.forClass(ScalableTaskCount.class), (Object[])new Object[]{Objects.requireNonNull(_props, "_props is required")});
    }

    @Override
    protected void configureAwsVpcNetworkingWithSecurityGroups(@NotNull IVpc _vpc, @Nullable Boolean _assignPublicIp, @Nullable SubnetSelection _vpcSubnets, @Nullable List<ISecurityGroup> _securityGroups) {
        Kernel.call((Object)this, (String)"configureAwsVpcNetworkingWithSecurityGroups", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(_vpc, "_vpc is required"), _assignPublicIp, _vpcSubnets, _securityGroups});
    }

    @Override
    protected void configureAwsVpcNetworkingWithSecurityGroups(@NotNull IVpc _vpc, @Nullable Boolean _assignPublicIp, @Nullable SubnetSelection _vpcSubnets) {
        Kernel.call((Object)this, (String)"configureAwsVpcNetworkingWithSecurityGroups", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(_vpc, "_vpc is required"), _assignPublicIp, _vpcSubnets});
    }

    @Override
    protected void configureAwsVpcNetworkingWithSecurityGroups(@NotNull IVpc _vpc, @Nullable Boolean _assignPublicIp) {
        Kernel.call((Object)this, (String)"configureAwsVpcNetworkingWithSecurityGroups", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(_vpc, "_vpc is required"), _assignPublicIp});
    }

    @Override
    protected void configureAwsVpcNetworkingWithSecurityGroups(@NotNull IVpc _vpc) {
        Kernel.call((Object)this, (String)"configureAwsVpcNetworkingWithSecurityGroups", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(_vpc, "_vpc is required")});
    }

    @Override
    @NotNull
    public Service enableCloudMap(@NotNull CloudMapOptions _options) {
        return (Service)Kernel.call((Object)this, (String)"enableCloudMap", (NativeType)NativeType.forClass(Service.class), (Object[])new Object[]{Objects.requireNonNull(_options, "_options is required")});
    }

    @Override
    @NotNull
    public IEcsLoadBalancerTarget loadBalancerTarget(@NotNull LoadBalancerTargetOptions _options) {
        return (IEcsLoadBalancerTarget)Kernel.call((Object)this, (String)"loadBalancerTarget", (NativeType)NativeType.forClass(IEcsLoadBalancerTarget.class), (Object[])new Object[]{Objects.requireNonNull(_options, "_options is required")});
    }

    @Override
    public void registerLoadBalancerTargets(EcsTarget ... _targets) {
        Kernel.call((Object)this, (String)"registerLoadBalancerTargets", (NativeType)NativeType.VOID, (Object[])Arrays.stream(_targets).toArray(Object[]::new));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ExternalService> {
        private final Construct scope;
        private final String id;
        private final ExternalServiceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ExternalServiceProps.Builder();
        }

        public Builder cluster(ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        public Builder capacityProviderStrategies(List<? extends CapacityProviderStrategy> capacityProviderStrategies) {
            this.props.capacityProviderStrategies(capacityProviderStrategies);
            return this;
        }

        public Builder circuitBreaker(DeploymentCircuitBreaker circuitBreaker) {
            this.props.circuitBreaker(circuitBreaker);
            return this;
        }

        public Builder cloudMapOptions(CloudMapOptions cloudMapOptions) {
            this.props.cloudMapOptions(cloudMapOptions);
            return this;
        }

        public Builder deploymentController(DeploymentController deploymentController) {
            this.props.deploymentController(deploymentController);
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.props.desiredCount(desiredCount);
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.props.enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        public Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.props.enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        public Builder healthCheckGracePeriod(Duration healthCheckGracePeriod) {
            this.props.healthCheckGracePeriod(healthCheckGracePeriod);
            return this;
        }

        public Builder maxHealthyPercent(Number maxHealthyPercent) {
            this.props.maxHealthyPercent(maxHealthyPercent);
            return this;
        }

        public Builder minHealthyPercent(Number minHealthyPercent) {
            this.props.minHealthyPercent(minHealthyPercent);
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        @Deprecated
        public Builder propagateTaskTagsFrom(PropagatedTagSource propagateTaskTagsFrom) {
            this.props.propagateTaskTagsFrom(propagateTaskTagsFrom);
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public ExternalService build() {
            return new ExternalService(this.scope, this.id, this.props.build());
        }
    }
}

