/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.services.applicationautoscaling.BaseScalableAttribute;
import software.amazon.awscdk.services.applicationautoscaling.BasicStepScalingPolicyProps;
import software.amazon.awscdk.services.applicationautoscaling.ScalingSchedule;
import software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace;
import software.amazon.awscdk.services.ecs.CpuUtilizationScalingProps;
import software.amazon.awscdk.services.ecs.MemoryUtilizationScalingProps;
import software.amazon.awscdk.services.ecs.RequestCountScalingProps;
import software.amazon.awscdk.services.ecs.ScalableTaskCountProps;
import software.amazon.awscdk.services.ecs.TrackCustomMetricProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="monocdk.aws_ecs.ScalableTaskCount")
public class ScalableTaskCount
extends BaseScalableAttribute {
    protected ScalableTaskCount(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScalableTaskCount(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ScalableTaskCount(@NotNull Construct scope, @NotNull String id, @NotNull ScalableTaskCountProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void scaleOnCpuUtilization(@NotNull String id, @NotNull CpuUtilizationScalingProps props) {
        Kernel.call((Object)this, (String)"scaleOnCpuUtilization", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void scaleOnMemoryUtilization(@NotNull String id, @NotNull MemoryUtilizationScalingProps props) {
        Kernel.call((Object)this, (String)"scaleOnMemoryUtilization", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void scaleOnMetric(@NotNull String id, @NotNull BasicStepScalingPolicyProps props) {
        Kernel.call((Object)this, (String)"scaleOnMetric", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void scaleOnRequestCount(@NotNull String id, @NotNull RequestCountScalingProps props) {
        Kernel.call((Object)this, (String)"scaleOnRequestCount", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void scaleOnSchedule(@NotNull String id, @NotNull ScalingSchedule props) {
        Kernel.call((Object)this, (String)"scaleOnSchedule", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void scaleToTrackCustomMetric(@NotNull String id, @NotNull TrackCustomMetricProps props) {
        Kernel.call((Object)this, (String)"scaleToTrackCustomMetric", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ScalableTaskCount> {
        private final Construct scope;
        private final String id;
        private final ScalableTaskCountProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ScalableTaskCountProps.Builder();
        }

        public Builder maxCapacity(Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        public Builder minCapacity(Number minCapacity) {
            this.props.minCapacity(minCapacity);
            return this;
        }

        public Builder dimension(String dimension) {
            this.props.dimension(dimension);
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.props.serviceNamespace(serviceNamespace);
            return this;
        }

        public ScalableTaskCount build() {
            return new ScalableTaskCount(this.scope, this.id, this.props.build());
        }
    }
}

