/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks.legacy;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.autoscaling.AutoScalingGroup;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.eks.legacy.AutoScalingGroupOptions;
import software.amazon.awscdk.services.eks.legacy.AwsAuth;
import software.amazon.awscdk.services.eks.legacy.CapacityOptions;
import software.amazon.awscdk.services.eks.legacy.ClusterAttributes;
import software.amazon.awscdk.services.eks.legacy.ClusterProps;
import software.amazon.awscdk.services.eks.legacy.HelmChart;
import software.amazon.awscdk.services.eks.legacy.HelmChartOptions;
import software.amazon.awscdk.services.eks.legacy.ICluster;
import software.amazon.awscdk.services.eks.legacy.KubernetesResource;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_eks_legacy.Cluster")
public class Cluster
extends Resource
implements ICluster {
    protected Cluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Cluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Cluster(@NotNull Construct scope, @NotNull String id, @Nullable ClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Cluster(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static ICluster fromClusterAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ClusterAttributes attrs) {
        return (ICluster)JsiiObject.jsiiStaticCall(Cluster.class, (String)"fromClusterAttributes", (NativeType)NativeType.forClass(ICluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addAutoScalingGroup(@NotNull AutoScalingGroup autoScalingGroup, @NotNull AutoScalingGroupOptions options) {
        Kernel.call((Object)this, (String)"addAutoScalingGroup", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public AutoScalingGroup addCapacity(@NotNull String id, @NotNull CapacityOptions options) {
        return (AutoScalingGroup)Kernel.call((Object)this, (String)"addCapacity", (NativeType)NativeType.forClass(AutoScalingGroup.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public HelmChart addChart(@NotNull String id, @NotNull HelmChartOptions options) {
        return (HelmChart)Kernel.call((Object)this, (String)"addChart", (NativeType)NativeType.forClass(HelmChart.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public KubernetesResource addResource(@NotNull String id, Object ... manifest) {
        return (KubernetesResource)Kernel.call((Object)this, (String)"addResource", (NativeType)NativeType.forClass(KubernetesResource.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(id, "id is required")}), Arrays.stream(manifest)).toArray(Object[]::new));
    }

    @NotNull
    public AwsAuth getAwsAuth() {
        return (AwsAuth)Kernel.get((Object)this, (String)"awsAuth", (NativeType)NativeType.forClass(AwsAuth.class));
    }

    @Override
    @NotNull
    public String getClusterArn() {
        return (String)Kernel.get((Object)this, (String)"clusterArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getClusterCertificateAuthorityData() {
        return (String)Kernel.get((Object)this, (String)"clusterCertificateAuthorityData", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getClusterEndpoint() {
        return (String)Kernel.get((Object)this, (String)"clusterEndpoint", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getClusterName() {
        return (String)Kernel.get((Object)this, (String)"clusterName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @NotNull
    public Boolean getKubectlEnabled() {
        return (Boolean)Kernel.get((Object)this, (String)"kubectlEnabled", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @NotNull
    public IVpc getVpc() {
        return (IVpc)Kernel.get((Object)this, (String)"vpc", (NativeType)NativeType.forClass(IVpc.class));
    }

    @Nullable
    public AutoScalingGroup getDefaultCapacity() {
        return (AutoScalingGroup)Kernel.get((Object)this, (String)"defaultCapacity", (NativeType)NativeType.forClass(AutoScalingGroup.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Cluster> {
        private final Construct scope;
        private final String id;
        private ClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder clusterName(String clusterName) {
            this.props().clusterName(clusterName);
            return this;
        }

        public Builder defaultCapacity(Number defaultCapacity) {
            this.props().defaultCapacity(defaultCapacity);
            return this;
        }

        public Builder defaultCapacityInstance(InstanceType defaultCapacityInstance) {
            this.props().defaultCapacityInstance(defaultCapacityInstance);
            return this;
        }

        public Builder kubectlEnabled(Boolean kubectlEnabled) {
            this.props().kubectlEnabled(kubectlEnabled);
            return this;
        }

        public Builder mastersRole(IRole mastersRole) {
            this.props().mastersRole(mastersRole);
            return this;
        }

        public Builder outputClusterName(Boolean outputClusterName) {
            this.props().outputClusterName(outputClusterName);
            return this;
        }

        public Builder outputConfigCommand(Boolean outputConfigCommand) {
            this.props().outputConfigCommand(outputConfigCommand);
            return this;
        }

        public Builder outputMastersRoleArn(Boolean outputMastersRoleArn) {
            this.props().outputMastersRoleArn(outputMastersRoleArn);
            return this;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.props().securityGroup(securityGroup);
            return this;
        }

        public Builder version(String version) {
            this.props().version(version);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        public Builder vpcSubnets(List<? extends SubnetSelection> vpcSubnets) {
            this.props().vpcSubnets(vpcSubnets);
            return this;
        }

        public Cluster build() {
            return new Cluster(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new ClusterProps.Builder();
            }
            return this.props;
        }
    }
}

