/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events.targets;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.apigateway.RestApi;
import software.amazon.awscdk.services.events.IRule;
import software.amazon.awscdk.services.events.IRuleTarget;
import software.amazon.awscdk.services.events.RuleTargetConfig;
import software.amazon.awscdk.services.events.RuleTargetInput;
import software.amazon.awscdk.services.events.targets.ApiGatewayProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_events_targets.ApiGateway")
public class ApiGateway
extends JsiiObject
implements IRuleTarget {
    protected ApiGateway(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApiGateway(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ApiGateway(@NotNull RestApi restApi, @Nullable ApiGatewayProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(restApi, "restApi is required"), props});
    }

    public ApiGateway(@NotNull RestApi restApi) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(restApi, "restApi is required")});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule rule, @Nullable String _id) {
        return (RuleTargetConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required"), _id});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule rule) {
        return (RuleTargetConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    @NotNull
    public RestApi getRestApi() {
        return (RestApi)Kernel.get((Object)this, (String)"restApi", (NativeType)NativeType.forClass(RestApi.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ApiGateway> {
        private final RestApi restApi;
        private ApiGatewayProps.Builder props;

        public static Builder create(RestApi restApi) {
            return new Builder(restApi);
        }

        private Builder(RestApi restApi) {
            this.restApi = restApi;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder maxEventAge(Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        public Builder eventRole(IRole eventRole) {
            this.props().eventRole(eventRole);
            return this;
        }

        public Builder headerParameters(Map<String, String> headerParameters) {
            this.props().headerParameters(headerParameters);
            return this;
        }

        public Builder method(String method) {
            this.props().method(method);
            return this;
        }

        public Builder path(String path) {
            this.props().path(path);
            return this;
        }

        public Builder pathParameterValues(List<String> pathParameterValues) {
            this.props().pathParameterValues(pathParameterValues);
            return this;
        }

        public Builder postBody(RuleTargetInput postBody) {
            this.props().postBody(postBody);
            return this;
        }

        public Builder queryStringParameters(Map<String, String> queryStringParameters) {
            this.props().queryStringParameters(queryStringParameters);
            return this;
        }

        public Builder stage(String stage) {
            this.props().stage(stage);
            return this;
        }

        public ApiGateway build() {
            return new ApiGateway(this.restApi, this.props != null ? this.props.build() : null);
        }

        private ApiGatewayProps.Builder props() {
            if (this.props == null) {
                this.props = new ApiGatewayProps.Builder();
            }
            return this.props;
        }
    }
}

