/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iot;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.iot.IAction;
import software.amazon.awscdk.services.iot.ITopicRule;
import software.amazon.awscdk.services.iot.IotSql;
import software.amazon.awscdk.services.iot.TopicRuleProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="monocdk.aws_iot.TopicRule")
public class TopicRule
extends Resource
implements ITopicRule {
    protected TopicRule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TopicRule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public TopicRule(@NotNull Construct scope, @NotNull String id, @NotNull TopicRuleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ITopicRule fromTopicRuleArn(@NotNull Construct scope, @NotNull String id, @NotNull String topicRuleArn) {
        return (ITopicRule)JsiiObject.jsiiStaticCall(TopicRule.class, (String)"fromTopicRuleArn", (NativeType)NativeType.forClass(ITopicRule.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(topicRuleArn, "topicRuleArn is required")});
    }

    public void addAction(@NotNull IAction action) {
        Kernel.call((Object)this, (String)"addAction", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(action, "action is required")});
    }

    @Override
    @NotNull
    public String getTopicRuleArn() {
        return (String)Kernel.get((Object)this, (String)"topicRuleArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getTopicRuleName() {
        return (String)Kernel.get((Object)this, (String)"topicRuleName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<TopicRule> {
        private final Construct scope;
        private final String id;
        private final TopicRuleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new TopicRuleProps.Builder();
        }

        public Builder sql(IotSql sql) {
            this.props.sql(sql);
            return this;
        }

        public Builder actions(List<? extends IAction> actions) {
            this.props.actions(actions);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder errorAction(IAction errorAction) {
            this.props.errorAction(errorAction);
            return this;
        }

        public Builder topicRuleName(String topicRuleName) {
            this.props.topicRuleName(topicRuleName);
            return this;
        }

        public TopicRule build() {
            return new TopicRule(this.scope, this.id, this.props.build());
        }
    }
}

