/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iot.actions;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iot.ActionConfig;
import software.amazon.awscdk.services.iot.IAction;
import software.amazon.awscdk.services.iot.ITopicRule;
import software.amazon.awscdk.services.iot.actions.S3PutObjectActionProps;
import software.amazon.awscdk.services.s3.BucketAccessControl;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_iot_actions.S3PutObjectAction")
public class S3PutObjectAction
extends JsiiObject
implements IAction {
    protected S3PutObjectAction(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3PutObjectAction(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public S3PutObjectAction(@NotNull IBucket bucket, @Nullable S3PutObjectActionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(bucket, "bucket is required"), props});
    }

    public S3PutObjectAction(@NotNull IBucket bucket) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(bucket, "bucket is required")});
    }

    @Override
    @NotNull
    public ActionConfig bind(@NotNull ITopicRule rule) {
        return (ActionConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(ActionConfig.class), (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<S3PutObjectAction> {
        private final IBucket bucket;
        private S3PutObjectActionProps.Builder props;

        public static Builder create(IBucket bucket) {
            return new Builder(bucket);
        }

        private Builder(IBucket bucket) {
            this.bucket = bucket;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public Builder accessControl(BucketAccessControl accessControl) {
            this.props().accessControl(accessControl);
            return this;
        }

        public Builder key(String key) {
            this.props().key(key);
            return this;
        }

        public S3PutObjectAction build() {
            return new S3PutObjectAction(this.bucket, this.props != null ? this.props.build() : null);
        }

        private S3PutObjectActionProps.Builder props() {
            if (this.props == null) {
                this.props = new S3PutObjectActionProps.Builder();
            }
            return this.props;
        }
    }
}

