/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iotevents;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.iotevents.CfnDetectorModel;
import software.amazon.awscdk.services.iotevents.CfnDetectorModelProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel")
public class CfnDetectorModel
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDetectorModel.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDetectorModel(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDetectorModel(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDetectorModel(@NotNull Construct scope, @NotNull String id, @NotNull CfnDetectorModelProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getDetectorModelDefinition() {
        return Kernel.get((Object)this, (String)"detectorModelDefinition", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDetectorModelDefinition(@NotNull DetectorModelDefinitionProperty value) {
        Kernel.set((Object)this, (String)"detectorModelDefinition", (Object)Objects.requireNonNull(value, "detectorModelDefinition is required"));
    }

    public void setDetectorModelDefinition(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"detectorModelDefinition", (Object)Objects.requireNonNull(value, "detectorModelDefinition is required"));
    }

    @NotNull
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)Objects.requireNonNull(value, "roleArn is required"));
    }

    @Nullable
    public String getDetectorModelDescription() {
        return (String)Kernel.get((Object)this, (String)"detectorModelDescription", (NativeType)NativeType.forClass(String.class));
    }

    public void setDetectorModelDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"detectorModelDescription", (Object)value);
    }

    @Nullable
    public String getDetectorModelName() {
        return (String)Kernel.get((Object)this, (String)"detectorModelName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDetectorModelName(@Nullable String value) {
        Kernel.set((Object)this, (String)"detectorModelName", (Object)value);
    }

    @Nullable
    public String getEvaluationMethod() {
        return (String)Kernel.get((Object)this, (String)"evaluationMethod", (NativeType)NativeType.forClass(String.class));
    }

    public void setEvaluationMethod(@Nullable String value) {
        Kernel.set((Object)this, (String)"evaluationMethod", (Object)value);
    }

    @Nullable
    public String getKey() {
        return (String)Kernel.get((Object)this, (String)"key", (NativeType)NativeType.forClass(String.class));
    }

    public void setKey(@Nullable String value) {
        Kernel.set((Object)this, (String)"key", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDetectorModel> {
        private final Construct scope;
        private final String id;
        private final CfnDetectorModelProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDetectorModelProps.Builder();
        }

        public Builder detectorModelDefinition(DetectorModelDefinitionProperty detectorModelDefinition) {
            this.props.detectorModelDefinition(detectorModelDefinition);
            return this;
        }

        public Builder detectorModelDefinition(IResolvable detectorModelDefinition) {
            this.props.detectorModelDefinition(detectorModelDefinition);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder detectorModelDescription(String detectorModelDescription) {
            this.props.detectorModelDescription(detectorModelDescription);
            return this;
        }

        public Builder detectorModelName(String detectorModelName) {
            this.props.detectorModelName(detectorModelName);
            return this;
        }

        public Builder evaluationMethod(String evaluationMethod) {
            this.props.evaluationMethod(evaluationMethod);
            return this;
        }

        public Builder key(String key) {
            this.props.key(key);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnDetectorModel build() {
            return new CfnDetectorModel(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.TransitionEventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TransitionEventProperty
    extends JsiiSerializable {
        @NotNull
        public String getCondition();

        @NotNull
        public String getEventName();

        @NotNull
        public String getNextState();

        @Nullable
        default public Object getActions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TransitionEventProperty> {
            String condition;
            String eventName;
            String nextState;
            Object actions;

            public Builder condition(String condition) {
                this.condition = condition;
                return this;
            }

            public Builder eventName(String eventName) {
                this.eventName = eventName;
                return this;
            }

            public Builder nextState(String nextState) {
                this.nextState = nextState;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public TransitionEventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.StateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StateProperty
    extends JsiiSerializable {
        @NotNull
        public String getStateName();

        @Nullable
        default public Object getOnEnter() {
            return null;
        }

        @Nullable
        default public Object getOnExit() {
            return null;
        }

        @Nullable
        default public Object getOnInput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StateProperty> {
            String stateName;
            Object onEnter;
            Object onExit;
            Object onInput;

            public Builder stateName(String stateName) {
                this.stateName = stateName;
                return this;
            }

            public Builder onEnter(OnEnterProperty onEnter) {
                this.onEnter = onEnter;
                return this;
            }

            public Builder onEnter(IResolvable onEnter) {
                this.onEnter = onEnter;
                return this;
            }

            public Builder onExit(OnExitProperty onExit) {
                this.onExit = onExit;
                return this;
            }

            public Builder onExit(IResolvable onExit) {
                this.onExit = onExit;
                return this;
            }

            public Builder onInput(OnInputProperty onInput) {
                this.onInput = onInput;
                return this;
            }

            public Builder onInput(IResolvable onInput) {
                this.onInput = onInput;
                return this;
            }

            public StateProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.SqsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SqsProperty
    extends JsiiSerializable {
        @NotNull
        public String getQueueUrl();

        @Nullable
        default public Object getPayload() {
            return null;
        }

        @Nullable
        default public Object getUseBase64() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SqsProperty> {
            String queueUrl;
            Object payload;
            Object useBase64;

            public Builder queueUrl(String queueUrl) {
                this.queueUrl = queueUrl;
                return this;
            }

            public Builder payload(PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            public Builder payload(IResolvable payload) {
                this.payload = payload;
                return this;
            }

            public Builder useBase64(Boolean useBase64) {
                this.useBase64 = useBase64;
                return this;
            }

            public Builder useBase64(IResolvable useBase64) {
                this.useBase64 = useBase64;
                return this;
            }

            public SqsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.SnsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SnsProperty
    extends JsiiSerializable {
        @NotNull
        public String getTargetArn();

        @Nullable
        default public Object getPayload() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SnsProperty> {
            String targetArn;
            Object payload;

            public Builder targetArn(String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            public Builder payload(PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            public Builder payload(IResolvable payload) {
                this.payload = payload;
                return this;
            }

            public SnsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.SetVariableProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SetVariableProperty
    extends JsiiSerializable {
        @NotNull
        public String getValue();

        @NotNull
        public String getVariableName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SetVariableProperty> {
            String value;
            String variableName;

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Builder variableName(String variableName) {
                this.variableName = variableName;
                return this;
            }

            public SetVariableProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.SetTimerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SetTimerProperty
    extends JsiiSerializable {
        @NotNull
        public String getTimerName();

        @Nullable
        default public String getDurationExpression() {
            return null;
        }

        @Nullable
        default public Number getSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SetTimerProperty> {
            String timerName;
            String durationExpression;
            Number seconds;

            public Builder timerName(String timerName) {
                this.timerName = timerName;
                return this;
            }

            public Builder durationExpression(String durationExpression) {
                this.durationExpression = durationExpression;
                return this;
            }

            public Builder seconds(Number seconds) {
                this.seconds = seconds;
                return this;
            }

            public SetTimerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.ResetTimerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResetTimerProperty
    extends JsiiSerializable {
        @NotNull
        public String getTimerName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResetTimerProperty> {
            String timerName;

            public Builder timerName(String timerName) {
                this.timerName = timerName;
                return this;
            }

            public ResetTimerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.PayloadProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PayloadProperty
    extends JsiiSerializable {
        @NotNull
        public String getContentExpression();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PayloadProperty> {
            String contentExpression;
            String type;

            public Builder contentExpression(String contentExpression) {
                this.contentExpression = contentExpression;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public PayloadProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.OnInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnInputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEvents() {
            return null;
        }

        @Nullable
        default public Object getTransitionEvents() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnInputProperty> {
            Object events;
            Object transitionEvents;

            public Builder events(IResolvable events) {
                this.events = events;
                return this;
            }

            public Builder events(List<? extends Object> events) {
                this.events = events;
                return this;
            }

            public Builder transitionEvents(IResolvable transitionEvents) {
                this.transitionEvents = transitionEvents;
                return this;
            }

            public Builder transitionEvents(List<? extends Object> transitionEvents) {
                this.transitionEvents = transitionEvents;
                return this;
            }

            public OnInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.OnExitProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnExitProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEvents() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnExitProperty> {
            Object events;

            public Builder events(IResolvable events) {
                this.events = events;
                return this;
            }

            public Builder events(List<? extends Object> events) {
                this.events = events;
                return this;
            }

            public OnExitProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.OnEnterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OnEnterProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEvents() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OnEnterProperty> {
            Object events;

            public Builder events(IResolvable events) {
                this.events = events;
                return this;
            }

            public Builder events(List<? extends Object> events) {
                this.events = events;
                return this;
            }

            public OnEnterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.LambdaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaProperty
    extends JsiiSerializable {
        @NotNull
        public String getFunctionArn();

        @Nullable
        default public Object getPayload() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaProperty> {
            String functionArn;
            Object payload;

            public Builder functionArn(String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            public Builder payload(PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            public Builder payload(IResolvable payload) {
                this.payload = payload;
                return this;
            }

            public LambdaProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.IotTopicPublishProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IotTopicPublishProperty
    extends JsiiSerializable {
        @NotNull
        public String getMqttTopic();

        @Nullable
        default public Object getPayload() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IotTopicPublishProperty> {
            String mqttTopic;
            Object payload;

            public Builder mqttTopic(String mqttTopic) {
                this.mqttTopic = mqttTopic;
                return this;
            }

            public Builder payload(PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            public Builder payload(IResolvable payload) {
                this.payload = payload;
                return this;
            }

            public IotTopicPublishProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.IotSiteWiseProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IotSiteWiseProperty
    extends JsiiSerializable {
        @NotNull
        public Object getPropertyValue();

        @Nullable
        default public String getAssetId() {
            return null;
        }

        @Nullable
        default public String getEntryId() {
            return null;
        }

        @Nullable
        default public String getPropertyAlias() {
            return null;
        }

        @Nullable
        default public String getPropertyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IotSiteWiseProperty> {
            Object propertyValue;
            String assetId;
            String entryId;
            String propertyAlias;
            String propertyId;

            public Builder propertyValue(AssetPropertyValueProperty propertyValue) {
                this.propertyValue = propertyValue;
                return this;
            }

            public Builder propertyValue(IResolvable propertyValue) {
                this.propertyValue = propertyValue;
                return this;
            }

            public Builder assetId(String assetId) {
                this.assetId = assetId;
                return this;
            }

            public Builder entryId(String entryId) {
                this.entryId = entryId;
                return this;
            }

            public Builder propertyAlias(String propertyAlias) {
                this.propertyAlias = propertyAlias;
                return this;
            }

            public Builder propertyId(String propertyId) {
                this.propertyId = propertyId;
                return this;
            }

            public IotSiteWiseProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.IotEventsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IotEventsProperty
    extends JsiiSerializable {
        @NotNull
        public String getInputName();

        @Nullable
        default public Object getPayload() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IotEventsProperty> {
            String inputName;
            Object payload;

            public Builder inputName(String inputName) {
                this.inputName = inputName;
                return this;
            }

            public Builder payload(PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            public Builder payload(IResolvable payload) {
                this.payload = payload;
                return this;
            }

            public IotEventsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.FirehoseProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FirehoseProperty
    extends JsiiSerializable {
        @NotNull
        public String getDeliveryStreamName();

        @Nullable
        default public Object getPayload() {
            return null;
        }

        @Nullable
        default public String getSeparator() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FirehoseProperty> {
            String deliveryStreamName;
            Object payload;
            String separator;

            public Builder deliveryStreamName(String deliveryStreamName) {
                this.deliveryStreamName = deliveryStreamName;
                return this;
            }

            public Builder payload(PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            public Builder payload(IResolvable payload) {
                this.payload = payload;
                return this;
            }

            public Builder separator(String separator) {
                this.separator = separator;
                return this;
            }

            public FirehoseProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.EventProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EventProperty
    extends JsiiSerializable {
        @NotNull
        public String getEventName();

        @Nullable
        default public Object getActions() {
            return null;
        }

        @Nullable
        default public String getCondition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EventProperty> {
            String eventName;
            Object actions;
            String condition;

            public Builder eventName(String eventName) {
                this.eventName = eventName;
                return this;
            }

            public Builder actions(IResolvable actions) {
                this.actions = actions;
                return this;
            }

            public Builder actions(List<? extends Object> actions) {
                this.actions = actions;
                return this;
            }

            public Builder condition(String condition) {
                this.condition = condition;
                return this;
            }

            public EventProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.DynamoDBv2Property")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDBv2Property
    extends JsiiSerializable {
        @NotNull
        public String getTableName();

        @Nullable
        default public Object getPayload() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDBv2Property> {
            String tableName;
            Object payload;

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder payload(PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            public Builder payload(IResolvable payload) {
                this.payload = payload;
                return this;
            }

            public DynamoDBv2Property build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.DynamoDBProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDBProperty
    extends JsiiSerializable {
        @NotNull
        public String getHashKeyField();

        @NotNull
        public String getHashKeyValue();

        @NotNull
        public String getTableName();

        @Nullable
        default public String getHashKeyType() {
            return null;
        }

        @Nullable
        default public String getOperation() {
            return null;
        }

        @Nullable
        default public Object getPayload() {
            return null;
        }

        @Nullable
        default public String getPayloadField() {
            return null;
        }

        @Nullable
        default public String getRangeKeyField() {
            return null;
        }

        @Nullable
        default public String getRangeKeyType() {
            return null;
        }

        @Nullable
        default public String getRangeKeyValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDBProperty> {
            String hashKeyField;
            String hashKeyValue;
            String tableName;
            String hashKeyType;
            String operation;
            Object payload;
            String payloadField;
            String rangeKeyField;
            String rangeKeyType;
            String rangeKeyValue;

            public Builder hashKeyField(String hashKeyField) {
                this.hashKeyField = hashKeyField;
                return this;
            }

            public Builder hashKeyValue(String hashKeyValue) {
                this.hashKeyValue = hashKeyValue;
                return this;
            }

            public Builder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder hashKeyType(String hashKeyType) {
                this.hashKeyType = hashKeyType;
                return this;
            }

            public Builder operation(String operation) {
                this.operation = operation;
                return this;
            }

            public Builder payload(PayloadProperty payload) {
                this.payload = payload;
                return this;
            }

            public Builder payload(IResolvable payload) {
                this.payload = payload;
                return this;
            }

            public Builder payloadField(String payloadField) {
                this.payloadField = payloadField;
                return this;
            }

            public Builder rangeKeyField(String rangeKeyField) {
                this.rangeKeyField = rangeKeyField;
                return this;
            }

            public Builder rangeKeyType(String rangeKeyType) {
                this.rangeKeyType = rangeKeyType;
                return this;
            }

            public Builder rangeKeyValue(String rangeKeyValue) {
                this.rangeKeyValue = rangeKeyValue;
                return this;
            }

            public DynamoDBProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.DetectorModelDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DetectorModelDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public String getInitialStateName();

        @NotNull
        public Object getStates();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DetectorModelDefinitionProperty> {
            String initialStateName;
            Object states;

            public Builder initialStateName(String initialStateName) {
                this.initialStateName = initialStateName;
                return this;
            }

            public Builder states(IResolvable states) {
                this.states = states;
                return this;
            }

            public Builder states(List<? extends Object> states) {
                this.states = states;
                return this;
            }

            public DetectorModelDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.ClearTimerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClearTimerProperty
    extends JsiiSerializable {
        @NotNull
        public String getTimerName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClearTimerProperty> {
            String timerName;

            public Builder timerName(String timerName) {
                this.timerName = timerName;
                return this;
            }

            public ClearTimerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.AssetPropertyVariantProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AssetPropertyVariantProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBooleanValue() {
            return null;
        }

        @Nullable
        default public String getDoubleValue() {
            return null;
        }

        @Nullable
        default public String getIntegerValue() {
            return null;
        }

        @Nullable
        default public String getStringValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AssetPropertyVariantProperty> {
            String booleanValue;
            String doubleValue;
            String integerValue;
            String stringValue;

            public Builder booleanValue(String booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            public Builder doubleValue(String doubleValue) {
                this.doubleValue = doubleValue;
                return this;
            }

            public Builder integerValue(String integerValue) {
                this.integerValue = integerValue;
                return this;
            }

            public Builder stringValue(String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            public AssetPropertyVariantProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.AssetPropertyValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AssetPropertyValueProperty
    extends JsiiSerializable {
        @NotNull
        public Object getValue();

        @Nullable
        default public String getQuality() {
            return null;
        }

        @Nullable
        default public Object getTimestamp() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AssetPropertyValueProperty> {
            Object value;
            String quality;
            Object timestamp;

            public Builder value(AssetPropertyVariantProperty value) {
                this.value = value;
                return this;
            }

            public Builder value(IResolvable value) {
                this.value = value;
                return this;
            }

            public Builder quality(String quality) {
                this.quality = quality;
                return this;
            }

            public Builder timestamp(AssetPropertyTimestampProperty timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Builder timestamp(IResolvable timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public AssetPropertyValueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.AssetPropertyTimestampProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AssetPropertyTimestampProperty
    extends JsiiSerializable {
        @NotNull
        public String getTimeInSeconds();

        @Nullable
        default public String getOffsetInNanos() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AssetPropertyTimestampProperty> {
            String timeInSeconds;
            String offsetInNanos;

            public Builder timeInSeconds(String timeInSeconds) {
                this.timeInSeconds = timeInSeconds;
                return this;
            }

            public Builder offsetInNanos(String offsetInNanos) {
                this.offsetInNanos = offsetInNanos;
                return this;
            }

            public AssetPropertyTimestampProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iotevents.CfnDetectorModel.ActionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ActionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getClearTimer() {
            return null;
        }

        @Nullable
        default public Object getDynamoDb() {
            return null;
        }

        @Nullable
        default public Object getDynamoDBv2() {
            return null;
        }

        @Nullable
        default public Object getFirehose() {
            return null;
        }

        @Nullable
        default public Object getIotEvents() {
            return null;
        }

        @Nullable
        default public Object getIotSiteWise() {
            return null;
        }

        @Nullable
        default public Object getIotTopicPublish() {
            return null;
        }

        @Nullable
        default public Object getLambda() {
            return null;
        }

        @Nullable
        default public Object getResetTimer() {
            return null;
        }

        @Nullable
        default public Object getSetTimer() {
            return null;
        }

        @Nullable
        default public Object getSetVariable() {
            return null;
        }

        @Nullable
        default public Object getSns() {
            return null;
        }

        @Nullable
        default public Object getSqs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ActionProperty> {
            Object clearTimer;
            Object dynamoDb;
            Object dynamoDBv2;
            Object firehose;
            Object iotEvents;
            Object iotSiteWise;
            Object iotTopicPublish;
            Object lambda;
            Object resetTimer;
            Object setTimer;
            Object setVariable;
            Object sns;
            Object sqs;

            public Builder clearTimer(ClearTimerProperty clearTimer) {
                this.clearTimer = clearTimer;
                return this;
            }

            public Builder clearTimer(IResolvable clearTimer) {
                this.clearTimer = clearTimer;
                return this;
            }

            public Builder dynamoDb(DynamoDBProperty dynamoDb) {
                this.dynamoDb = dynamoDb;
                return this;
            }

            public Builder dynamoDb(IResolvable dynamoDb) {
                this.dynamoDb = dynamoDb;
                return this;
            }

            public Builder dynamoDBv2(DynamoDBv2Property dynamoDBv2) {
                this.dynamoDBv2 = dynamoDBv2;
                return this;
            }

            public Builder dynamoDBv2(IResolvable dynamoDBv2) {
                this.dynamoDBv2 = dynamoDBv2;
                return this;
            }

            public Builder firehose(FirehoseProperty firehose) {
                this.firehose = firehose;
                return this;
            }

            public Builder firehose(IResolvable firehose) {
                this.firehose = firehose;
                return this;
            }

            public Builder iotEvents(IotEventsProperty iotEvents) {
                this.iotEvents = iotEvents;
                return this;
            }

            public Builder iotEvents(IResolvable iotEvents) {
                this.iotEvents = iotEvents;
                return this;
            }

            public Builder iotSiteWise(IotSiteWiseProperty iotSiteWise) {
                this.iotSiteWise = iotSiteWise;
                return this;
            }

            public Builder iotSiteWise(IResolvable iotSiteWise) {
                this.iotSiteWise = iotSiteWise;
                return this;
            }

            public Builder iotTopicPublish(IotTopicPublishProperty iotTopicPublish) {
                this.iotTopicPublish = iotTopicPublish;
                return this;
            }

            public Builder iotTopicPublish(IResolvable iotTopicPublish) {
                this.iotTopicPublish = iotTopicPublish;
                return this;
            }

            public Builder lambda(LambdaProperty lambda) {
                this.lambda = lambda;
                return this;
            }

            public Builder lambda(IResolvable lambda) {
                this.lambda = lambda;
                return this;
            }

            public Builder resetTimer(ResetTimerProperty resetTimer) {
                this.resetTimer = resetTimer;
                return this;
            }

            public Builder resetTimer(IResolvable resetTimer) {
                this.resetTimer = resetTimer;
                return this;
            }

            public Builder setTimer(SetTimerProperty setTimer) {
                this.setTimer = setTimer;
                return this;
            }

            public Builder setTimer(IResolvable setTimer) {
                this.setTimer = setTimer;
                return this;
            }

            public Builder setVariable(SetVariableProperty setVariable) {
                this.setVariable = setVariable;
                return this;
            }

            public Builder setVariable(IResolvable setVariable) {
                this.setVariable = setVariable;
                return this;
            }

            public Builder sns(SnsProperty sns) {
                this.sns = sns;
                return this;
            }

            public Builder sns(IResolvable sns) {
                this.sns = sns;
                return this;
            }

            public Builder sqs(SqsProperty sqs) {
                this.sqs = sqs;
                return this;
            }

            public Builder sqs(IResolvable sqs) {
                this.sqs = sqs;
                return this;
            }

            public ActionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

