/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iottwinmaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.iottwinmaker.CfnComponentType;
import software.amazon.awscdk.services.iottwinmaker.CfnComponentTypeProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_iottwinmaker.CfnComponentType")
public class CfnComponentType
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnComponentType.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnComponentType(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnComponentType(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnComponentType(@NotNull Construct scope, @NotNull String id, @NotNull CfnComponentTypeProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCreationDateTime() {
        return (String)Kernel.get((Object)this, (String)"attrCreationDateTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrIsAbstract() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrIsAbstract", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public IResolvable getAttrIsSchemaInitialized() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrIsSchemaInitialized", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrUpdateDateTime() {
        return (String)Kernel.get((Object)this, (String)"attrUpdateDateTime", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getComponentTypeId() {
        return (String)Kernel.get((Object)this, (String)"componentTypeId", (NativeType)NativeType.forClass(String.class));
    }

    public void setComponentTypeId(@NotNull String value) {
        Kernel.set((Object)this, (String)"componentTypeId", (Object)Objects.requireNonNull(value, "componentTypeId is required"));
    }

    @NotNull
    public String getWorkspaceId() {
        return (String)Kernel.get((Object)this, (String)"workspaceId", (NativeType)NativeType.forClass(String.class));
    }

    public void setWorkspaceId(@NotNull String value) {
        Kernel.set((Object)this, (String)"workspaceId", (Object)Objects.requireNonNull(value, "workspaceId is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public List<String> getExtendsFrom() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"extendsFrom", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setExtendsFrom(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"extendsFrom", value);
    }

    @Nullable
    public Object getFunctions() {
        return Kernel.get((Object)this, (String)"functions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setFunctions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"functions", (Object)value);
    }

    public void setFunctions(@Nullable Map<String, Object> value) {
        Kernel.set((Object)this, (String)"functions", value);
    }

    @Nullable
    public Object getIsSingleton() {
        return Kernel.get((Object)this, (String)"isSingleton", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIsSingleton(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"isSingleton", (Object)value);
    }

    public void setIsSingleton(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"isSingleton", (Object)value);
    }

    @Nullable
    public Object getPropertyDefinitions() {
        return Kernel.get((Object)this, (String)"propertyDefinitions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPropertyDefinitions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"propertyDefinitions", (Object)value);
    }

    public void setPropertyDefinitions(@Nullable Map<String, Object> value) {
        Kernel.set((Object)this, (String)"propertyDefinitions", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnComponentType> {
        private final Construct scope;
        private final String id;
        private final CfnComponentTypeProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnComponentTypeProps.Builder();
        }

        public Builder componentTypeId(String componentTypeId) {
            this.props.componentTypeId(componentTypeId);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.props.workspaceId(workspaceId);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder extendsFrom(List<String> extendsFrom) {
            this.props.extendsFrom(extendsFrom);
            return this;
        }

        public Builder functions(IResolvable functions) {
            this.props.functions(functions);
            return this;
        }

        public Builder functions(Map<String, ? extends Object> functions) {
            this.props.functions(functions);
            return this;
        }

        public Builder isSingleton(Boolean isSingleton) {
            this.props.isSingleton(isSingleton);
            return this;
        }

        public Builder isSingleton(IResolvable isSingleton) {
            this.props.isSingleton(isSingleton);
            return this;
        }

        public Builder propertyDefinitions(IResolvable propertyDefinitions) {
            this.props.propertyDefinitions(propertyDefinitions);
            return this;
        }

        public Builder propertyDefinitions(Map<String, ? extends Object> propertyDefinitions) {
            this.props.propertyDefinitions(propertyDefinitions);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnComponentType build() {
            return new CfnComponentType(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iottwinmaker.CfnComponentType.RelationshipProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RelationshipProperty
    extends JsiiSerializable {
        @Nullable
        default public String getRelationshipType() {
            return null;
        }

        @Nullable
        default public String getTargetComponentTypeId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RelationshipProperty> {
            String relationshipType;
            String targetComponentTypeId;

            public Builder relationshipType(String relationshipType) {
                this.relationshipType = relationshipType;
                return this;
            }

            public Builder targetComponentTypeId(String targetComponentTypeId) {
                this.targetComponentTypeId = targetComponentTypeId;
                return this;
            }

            public RelationshipProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iottwinmaker.CfnComponentType.PropertyDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PropertyDefinitionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConfigurations() {
            return null;
        }

        @Nullable
        default public Object getDataType() {
            return null;
        }

        @Nullable
        default public Object getDefaultValue() {
            return null;
        }

        @Nullable
        default public Object getIsExternalId() {
            return null;
        }

        @Nullable
        default public Object getIsRequiredInEntity() {
            return null;
        }

        @Nullable
        default public Object getIsStoredExternally() {
            return null;
        }

        @Nullable
        default public Object getIsTimeSeries() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PropertyDefinitionProperty> {
            Object configurations;
            Object dataType;
            Object defaultValue;
            Object isExternalId;
            Object isRequiredInEntity;
            Object isStoredExternally;
            Object isTimeSeries;

            public Builder configurations(IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder configurations(Map<String, String> configurations) {
                this.configurations = configurations;
                return this;
            }

            public Builder dataType(DataTypeProperty dataType) {
                this.dataType = dataType;
                return this;
            }

            public Builder dataType(IResolvable dataType) {
                this.dataType = dataType;
                return this;
            }

            public Builder defaultValue(DataValueProperty defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public Builder defaultValue(IResolvable defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public Builder isExternalId(Boolean isExternalId) {
                this.isExternalId = isExternalId;
                return this;
            }

            public Builder isExternalId(IResolvable isExternalId) {
                this.isExternalId = isExternalId;
                return this;
            }

            public Builder isRequiredInEntity(Boolean isRequiredInEntity) {
                this.isRequiredInEntity = isRequiredInEntity;
                return this;
            }

            public Builder isRequiredInEntity(IResolvable isRequiredInEntity) {
                this.isRequiredInEntity = isRequiredInEntity;
                return this;
            }

            public Builder isStoredExternally(Boolean isStoredExternally) {
                this.isStoredExternally = isStoredExternally;
                return this;
            }

            public Builder isStoredExternally(IResolvable isStoredExternally) {
                this.isStoredExternally = isStoredExternally;
                return this;
            }

            public Builder isTimeSeries(Boolean isTimeSeries) {
                this.isTimeSeries = isTimeSeries;
                return this;
            }

            public Builder isTimeSeries(IResolvable isTimeSeries) {
                this.isTimeSeries = isTimeSeries;
                return this;
            }

            public PropertyDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iottwinmaker.CfnComponentType.LambdaFunctionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaFunctionProperty
    extends JsiiSerializable {
        @NotNull
        public String getArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaFunctionProperty> {
            String arn;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public LambdaFunctionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iottwinmaker.CfnComponentType.FunctionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FunctionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getImplementedBy() {
            return null;
        }

        @Nullable
        default public List<String> getRequiredProperties() {
            return null;
        }

        @Nullable
        default public String getScope() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FunctionProperty> {
            Object implementedBy;
            List<String> requiredProperties;
            String scope;

            public Builder implementedBy(DataConnectorProperty implementedBy) {
                this.implementedBy = implementedBy;
                return this;
            }

            public Builder implementedBy(IResolvable implementedBy) {
                this.implementedBy = implementedBy;
                return this;
            }

            public Builder requiredProperties(List<String> requiredProperties) {
                this.requiredProperties = requiredProperties;
                return this;
            }

            public Builder scope(String scope) {
                this.scope = scope;
                return this;
            }

            public FunctionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iottwinmaker.CfnComponentType.DataValueProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataValueProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBooleanValue() {
            return null;
        }

        @Nullable
        default public Number getDoubleValue() {
            return null;
        }

        @Nullable
        default public String getExpression() {
            return null;
        }

        @Nullable
        default public Number getIntegerValue() {
            return null;
        }

        @Nullable
        default public Object getListValue() {
            return null;
        }

        @Nullable
        default public Number getLongValue() {
            return null;
        }

        @Nullable
        default public Object getMapValue() {
            return null;
        }

        @Nullable
        default public Object getRelationshipValue() {
            return null;
        }

        @Nullable
        default public String getStringValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataValueProperty> {
            Object booleanValue;
            Number doubleValue;
            String expression;
            Number integerValue;
            Object listValue;
            Number longValue;
            Object mapValue;
            Object relationshipValue;
            String stringValue;

            public Builder booleanValue(Boolean booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            public Builder booleanValue(IResolvable booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            public Builder doubleValue(Number doubleValue) {
                this.doubleValue = doubleValue;
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder integerValue(Number integerValue) {
                this.integerValue = integerValue;
                return this;
            }

            public Builder listValue(IResolvable listValue) {
                this.listValue = listValue;
                return this;
            }

            public Builder listValue(List<? extends Object> listValue) {
                this.listValue = listValue;
                return this;
            }

            public Builder longValue(Number longValue) {
                this.longValue = longValue;
                return this;
            }

            public Builder mapValue(IResolvable mapValue) {
                this.mapValue = mapValue;
                return this;
            }

            public Builder mapValue(Map<String, ? extends Object> mapValue) {
                this.mapValue = mapValue;
                return this;
            }

            public Builder relationshipValue(Object relationshipValue) {
                this.relationshipValue = relationshipValue;
                return this;
            }

            public Builder stringValue(String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            public DataValueProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iottwinmaker.CfnComponentType.DataTypeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataTypeProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Object getAllowedValues() {
            return null;
        }

        @Nullable
        default public Object getNestedType() {
            return null;
        }

        @Nullable
        default public Object getRelationship() {
            return null;
        }

        @Nullable
        default public String getUnitOfMeasure() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataTypeProperty> {
            String type;
            Object allowedValues;
            Object nestedType;
            Object relationship;
            String unitOfMeasure;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder allowedValues(IResolvable allowedValues) {
                this.allowedValues = allowedValues;
                return this;
            }

            public Builder allowedValues(List<? extends Object> allowedValues) {
                this.allowedValues = allowedValues;
                return this;
            }

            public Builder nestedType(DataTypeProperty nestedType) {
                this.nestedType = nestedType;
                return this;
            }

            public Builder nestedType(IResolvable nestedType) {
                this.nestedType = nestedType;
                return this;
            }

            public Builder relationship(RelationshipProperty relationship) {
                this.relationship = relationship;
                return this;
            }

            public Builder relationship(IResolvable relationship) {
                this.relationship = relationship;
                return this;
            }

            public Builder unitOfMeasure(String unitOfMeasure) {
                this.unitOfMeasure = unitOfMeasure;
                return this;
            }

            public DataTypeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_iottwinmaker.CfnComponentType.DataConnectorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataConnectorProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getIsNative() {
            return null;
        }

        @Nullable
        default public Object getLambda() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataConnectorProperty> {
            Object isNative;
            Object lambda;

            public Builder isNative(Boolean isNative) {
                this.isNative = isNative;
                return this;
            }

            public Builder isNative(IResolvable isNative) {
                this.isNative = isNative;
                return this;
            }

            public Builder lambda(LambdaFunctionProperty lambda) {
                this.lambda = lambda;
                return this;
            }

            public Builder lambda(IResolvable lambda) {
                this.lambda = lambda;
                return this;
            }

            public DataConnectorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

