/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesis;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.kinesis.IStream;
import software.amazon.awscdk.services.kinesis.StreamAttributes;
import software.amazon.awscdk.services.kinesis.StreamEncryption;
import software.amazon.awscdk.services.kinesis.StreamMode;
import software.amazon.awscdk.services.kinesis.StreamProps;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="monocdk.aws_kinesis.Stream")
public class Stream
extends Resource
implements IStream {
    protected Stream(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Stream(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Stream(@NotNull Construct scope, @NotNull String id, @Nullable StreamProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Stream(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IStream fromStreamArn(@NotNull Construct scope, @NotNull String id, @NotNull String streamArn) {
        return (IStream)JsiiObject.jsiiStaticCall(Stream.class, (String)"fromStreamArn", (NativeType)NativeType.forClass(IStream.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(streamArn, "streamArn is required")});
    }

    @NotNull
    public static IStream fromStreamAttributes(@NotNull Construct scope, @NotNull String id, @NotNull StreamAttributes attrs) {
        return (IStream)JsiiObject.jsiiStaticCall(Stream.class, (String)"fromStreamAttributes", (NativeType)NativeType.forClass(IStream.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])java.util.stream.Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new));
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantReadWrite(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantReadWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Metric metricGetRecords(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricGetRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricGetRecords() {
        return (Metric)Kernel.call((Object)this, (String)"metricGetRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricGetRecordsBytes(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricGetRecordsBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricGetRecordsBytes() {
        return (Metric)Kernel.call((Object)this, (String)"metricGetRecordsBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricGetRecordsIteratorAgeMilliseconds(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricGetRecordsIteratorAgeMilliseconds", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricGetRecordsIteratorAgeMilliseconds() {
        return (Metric)Kernel.call((Object)this, (String)"metricGetRecordsIteratorAgeMilliseconds", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricGetRecordsLatency(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricGetRecordsLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricGetRecordsLatency() {
        return (Metric)Kernel.call((Object)this, (String)"metricGetRecordsLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricGetRecordsSuccess(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricGetRecordsSuccess", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricGetRecordsSuccess() {
        return (Metric)Kernel.call((Object)this, (String)"metricGetRecordsSuccess", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricIncomingBytes(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricIncomingBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricIncomingBytes() {
        return (Metric)Kernel.call((Object)this, (String)"metricIncomingBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricIncomingRecords(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricIncomingRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricIncomingRecords() {
        return (Metric)Kernel.call((Object)this, (String)"metricIncomingRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricPutRecordBytes(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricPutRecordBytes() {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricPutRecordLatency(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricPutRecordLatency() {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricPutRecordsBytes(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricPutRecordsBytes() {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricPutRecordsFailedRecords(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsFailedRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricPutRecordsFailedRecords() {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsFailedRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricPutRecordsLatency(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricPutRecordsLatency() {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricPutRecordsSuccess(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsSuccess", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricPutRecordsSuccess() {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsSuccess", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricPutRecordsSuccessfulRecords(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsSuccessfulRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricPutRecordsSuccessfulRecords() {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsSuccessfulRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricPutRecordsThrottledRecords(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsThrottledRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricPutRecordsThrottledRecords() {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsThrottledRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricPutRecordsTotalRecords(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsTotalRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricPutRecordsTotalRecords() {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordsTotalRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricPutRecordSuccess(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordSuccess", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricPutRecordSuccess() {
        return (Metric)Kernel.call((Object)this, (String)"metricPutRecordSuccess", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricReadProvisionedThroughputExceeded(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricReadProvisionedThroughputExceeded", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricReadProvisionedThroughputExceeded() {
        return (Metric)Kernel.call((Object)this, (String)"metricReadProvisionedThroughputExceeded", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricWriteProvisionedThroughputExceeded(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricWriteProvisionedThroughputExceeded", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricWriteProvisionedThroughputExceeded() {
        return (Metric)Kernel.call((Object)this, (String)"metricWriteProvisionedThroughputExceeded", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getStreamArn() {
        return (String)Kernel.get((Object)this, (String)"streamArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getStreamName() {
        return (String)Kernel.get((Object)this, (String)"streamName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)Kernel.get((Object)this, (String)"encryptionKey", (NativeType)NativeType.forClass(IKey.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Stream> {
        private final Construct scope;
        private final String id;
        private StreamProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder encryption(StreamEncryption encryption) {
            this.props().encryption(encryption);
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        public Builder retentionPeriod(Duration retentionPeriod) {
            this.props().retentionPeriod(retentionPeriod);
            return this;
        }

        public Builder shardCount(Number shardCount) {
            this.props().shardCount(shardCount);
            return this;
        }

        public Builder streamMode(StreamMode streamMode) {
            this.props().streamMode(streamMode);
            return this;
        }

        public Builder streamName(String streamName) {
            this.props().streamName(streamName);
            return this;
        }

        public Stream build() {
            return new Stream(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private StreamProps.Builder props() {
            if (this.props == null) {
                this.props = new StreamProps.Builder();
            }
            return this.props;
        }
    }
}

