/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesis.analytics.flink;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationCode;
import software.amazon.awscdk.services.kinesis.analytics.flink.ApplicationProps;
import software.amazon.awscdk.services.kinesis.analytics.flink.IApplication;
import software.amazon.awscdk.services.kinesis.analytics.flink.LogLevel;
import software.amazon.awscdk.services.kinesis.analytics.flink.MetricsLevel;
import software.amazon.awscdk.services.kinesis.analytics.flink.PropertyGroups;
import software.amazon.awscdk.services.kinesis.analytics.flink.Runtime;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="monocdk.aws_kinesisanalytics_flink.Application")
public class Application
extends Resource
implements IApplication {
    protected Application(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Application(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Application(@NotNull Construct scope, @NotNull String id, @NotNull ApplicationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IApplication fromApplicationArn(@NotNull Construct scope, @NotNull String id, @NotNull String applicationArn) {
        return (IApplication)JsiiObject.jsiiStaticCall(Application.class, (String)"fromApplicationArn", (NativeType)NativeType.forClass(IApplication.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(applicationArn, "applicationArn is required")});
    }

    @NotNull
    public static IApplication fromApplicationName(@NotNull Construct scope, @NotNull String id, @NotNull String applicationName) {
        return (IApplication)JsiiObject.jsiiStaticCall(Application.class, (String)"fromApplicationName", (NativeType)NativeType.forClass(IApplication.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(applicationName, "applicationName is required")});
    }

    @Override
    @NotNull
    public Boolean addToRolePolicy(@NotNull PolicyStatement policyStatement) {
        return (Boolean)Kernel.call((Object)this, (String)"addToRolePolicy", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(policyStatement, "policyStatement is required")});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Metric metricBackPressuredTimeMsPerSecond(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricBackPressuredTimeMsPerSecond", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricBackPressuredTimeMsPerSecond() {
        return (Metric)Kernel.call((Object)this, (String)"metricBackPressuredTimeMsPerSecond", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricBusyTimePerMsPerSecond(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricBusyTimePerMsPerSecond", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricBusyTimePerMsPerSecond() {
        return (Metric)Kernel.call((Object)this, (String)"metricBusyTimePerMsPerSecond", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricCpuUtilization(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricCpuUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricCpuUtilization() {
        return (Metric)Kernel.call((Object)this, (String)"metricCpuUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricCurrentInputWatermark(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricCurrentInputWatermark", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricCurrentInputWatermark() {
        return (Metric)Kernel.call((Object)this, (String)"metricCurrentInputWatermark", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricCurrentOutputWatermark(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricCurrentOutputWatermark", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricCurrentOutputWatermark() {
        return (Metric)Kernel.call((Object)this, (String)"metricCurrentOutputWatermark", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricDowntime(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricDowntime", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricDowntime() {
        return (Metric)Kernel.call((Object)this, (String)"metricDowntime", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricFullRestarts(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricFullRestarts", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricFullRestarts() {
        return (Metric)Kernel.call((Object)this, (String)"metricFullRestarts", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricHeapMemoryUtilization(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricHeapMemoryUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricHeapMemoryUtilization() {
        return (Metric)Kernel.call((Object)this, (String)"metricHeapMemoryUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricIdleTimeMsPerSecond(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricIdleTimeMsPerSecond", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricIdleTimeMsPerSecond() {
        return (Metric)Kernel.call((Object)this, (String)"metricIdleTimeMsPerSecond", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricKpus(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricKpus", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricKpus() {
        return (Metric)Kernel.call((Object)this, (String)"metricKpus", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricLastCheckpointDuration(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricLastCheckpointDuration", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricLastCheckpointDuration() {
        return (Metric)Kernel.call((Object)this, (String)"metricLastCheckpointDuration", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricLastCheckpointSize(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricLastCheckpointSize", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricLastCheckpointSize() {
        return (Metric)Kernel.call((Object)this, (String)"metricLastCheckpointSize", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricManagedMemoryTotal(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricManagedMemoryTotal", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricManagedMemoryTotal() {
        return (Metric)Kernel.call((Object)this, (String)"metricManagedMemoryTotal", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricManagedMemoryUsed(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricManagedMemoryUsed", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricManagedMemoryUsed() {
        return (Metric)Kernel.call((Object)this, (String)"metricManagedMemoryUsed", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricManagedMemoryUtilization(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricManagedMemoryUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricManagedMemoryUtilization() {
        return (Metric)Kernel.call((Object)this, (String)"metricManagedMemoryUtilization", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricNumberOfFailedCheckpoints(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricNumberOfFailedCheckpoints", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricNumberOfFailedCheckpoints() {
        return (Metric)Kernel.call((Object)this, (String)"metricNumberOfFailedCheckpoints", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricNumLateRecordsDropped(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricNumLateRecordsDropped", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricNumLateRecordsDropped() {
        return (Metric)Kernel.call((Object)this, (String)"metricNumLateRecordsDropped", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricNumRecordsIn(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricNumRecordsIn", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricNumRecordsIn() {
        return (Metric)Kernel.call((Object)this, (String)"metricNumRecordsIn", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricNumRecordsInPerSecond(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricNumRecordsInPerSecond", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricNumRecordsInPerSecond() {
        return (Metric)Kernel.call((Object)this, (String)"metricNumRecordsInPerSecond", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricNumRecordsOut(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricNumRecordsOut", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricNumRecordsOut() {
        return (Metric)Kernel.call((Object)this, (String)"metricNumRecordsOut", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricNumRecordsOutPerSecond(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricNumRecordsOutPerSecond", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricNumRecordsOutPerSecond() {
        return (Metric)Kernel.call((Object)this, (String)"metricNumRecordsOutPerSecond", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricOldGenerationGCCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricOldGenerationGCCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricOldGenerationGCCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricOldGenerationGCCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricOldGenerationGCTime(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricOldGenerationGCTime", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricOldGenerationGCTime() {
        return (Metric)Kernel.call((Object)this, (String)"metricOldGenerationGCTime", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricThreadsCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricThreadsCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricThreadsCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricThreadsCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricUptime(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricUptime", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricUptime() {
        return (Metric)Kernel.call((Object)this, (String)"metricUptime", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getApplicationArn() {
        return (String)Kernel.get((Object)this, (String)"applicationArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getApplicationName() {
        return (String)Kernel.get((Object)this, (String)"applicationName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @Override
    @Nullable
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Application> {
        private final Construct scope;
        private final String id;
        private final ApplicationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ApplicationProps.Builder();
        }

        public Builder code(ApplicationCode code) {
            this.props.code(code);
            return this;
        }

        public Builder runtime(Runtime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        public Builder applicationName(String applicationName) {
            this.props.applicationName(applicationName);
            return this;
        }

        public Builder autoScalingEnabled(Boolean autoScalingEnabled) {
            this.props.autoScalingEnabled(autoScalingEnabled);
            return this;
        }

        public Builder checkpointingEnabled(Boolean checkpointingEnabled) {
            this.props.checkpointingEnabled(checkpointingEnabled);
            return this;
        }

        public Builder checkpointInterval(Duration checkpointInterval) {
            this.props.checkpointInterval(checkpointInterval);
            return this;
        }

        public Builder logGroup(ILogGroup logGroup) {
            this.props.logGroup(logGroup);
            return this;
        }

        public Builder logLevel(LogLevel logLevel) {
            this.props.logLevel(logLevel);
            return this;
        }

        public Builder metricsLevel(MetricsLevel metricsLevel) {
            this.props.metricsLevel(metricsLevel);
            return this;
        }

        public Builder minPauseBetweenCheckpoints(Duration minPauseBetweenCheckpoints) {
            this.props.minPauseBetweenCheckpoints(minPauseBetweenCheckpoints);
            return this;
        }

        public Builder parallelism(Number parallelism) {
            this.props.parallelism(parallelism);
            return this;
        }

        public Builder parallelismPerKpu(Number parallelismPerKpu) {
            this.props.parallelismPerKpu(parallelismPerKpu);
            return this;
        }

        public Builder propertyGroups(PropertyGroups propertyGroups) {
            this.props.propertyGroups(propertyGroups);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder snapshotsEnabled(Boolean snapshotsEnabled) {
            this.props.snapshotsEnabled(snapshotsEnabled);
            return this;
        }

        public Application build() {
            return new Application(this.scope, this.id, this.props.build());
        }
    }
}

