/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lightsail;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.lightsail.CfnLoadBalancerProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_lightsail.CfnLoadBalancer")
public class CfnLoadBalancer
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnLoadBalancer.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnLoadBalancer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLoadBalancer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnLoadBalancer(@NotNull Construct scope, @NotNull String id, @NotNull CfnLoadBalancerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrLoadBalancerArn() {
        return (String)Kernel.get((Object)this, (String)"attrLoadBalancerArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Number getInstancePort() {
        return (Number)Kernel.get((Object)this, (String)"instancePort", (NativeType)NativeType.forClass(Number.class));
    }

    public void setInstancePort(@NotNull Number value) {
        Kernel.set((Object)this, (String)"instancePort", (Object)Objects.requireNonNull(value, "instancePort is required"));
    }

    @NotNull
    public String getLoadBalancerName() {
        return (String)Kernel.get((Object)this, (String)"loadBalancerName", (NativeType)NativeType.forClass(String.class));
    }

    public void setLoadBalancerName(@NotNull String value) {
        Kernel.set((Object)this, (String)"loadBalancerName", (Object)Objects.requireNonNull(value, "loadBalancerName is required"));
    }

    @Nullable
    public List<String> getAttachedInstances() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"attachedInstances", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAttachedInstances(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"attachedInstances", value);
    }

    @Nullable
    public String getHealthCheckPath() {
        return (String)Kernel.get((Object)this, (String)"healthCheckPath", (NativeType)NativeType.forClass(String.class));
    }

    public void setHealthCheckPath(@Nullable String value) {
        Kernel.set((Object)this, (String)"healthCheckPath", (Object)value);
    }

    @Nullable
    public String getIpAddressType() {
        return (String)Kernel.get((Object)this, (String)"ipAddressType", (NativeType)NativeType.forClass(String.class));
    }

    public void setIpAddressType(@Nullable String value) {
        Kernel.set((Object)this, (String)"ipAddressType", (Object)value);
    }

    @Nullable
    public Object getSessionStickinessEnabled() {
        return Kernel.get((Object)this, (String)"sessionStickinessEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSessionStickinessEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"sessionStickinessEnabled", (Object)value);
    }

    public void setSessionStickinessEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"sessionStickinessEnabled", (Object)value);
    }

    @Nullable
    public String getSessionStickinessLbCookieDurationSeconds() {
        return (String)Kernel.get((Object)this, (String)"sessionStickinessLbCookieDurationSeconds", (NativeType)NativeType.forClass(String.class));
    }

    public void setSessionStickinessLbCookieDurationSeconds(@Nullable String value) {
        Kernel.set((Object)this, (String)"sessionStickinessLbCookieDurationSeconds", (Object)value);
    }

    @Nullable
    public String getTlsPolicyName() {
        return (String)Kernel.get((Object)this, (String)"tlsPolicyName", (NativeType)NativeType.forClass(String.class));
    }

    public void setTlsPolicyName(@Nullable String value) {
        Kernel.set((Object)this, (String)"tlsPolicyName", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnLoadBalancer> {
        private final Construct scope;
        private final String id;
        private final CfnLoadBalancerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnLoadBalancerProps.Builder();
        }

        public Builder instancePort(Number instancePort) {
            this.props.instancePort(instancePort);
            return this;
        }

        public Builder loadBalancerName(String loadBalancerName) {
            this.props.loadBalancerName(loadBalancerName);
            return this;
        }

        public Builder attachedInstances(List<String> attachedInstances) {
            this.props.attachedInstances(attachedInstances);
            return this;
        }

        public Builder healthCheckPath(String healthCheckPath) {
            this.props.healthCheckPath(healthCheckPath);
            return this;
        }

        public Builder ipAddressType(String ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        public Builder sessionStickinessEnabled(Boolean sessionStickinessEnabled) {
            this.props.sessionStickinessEnabled(sessionStickinessEnabled);
            return this;
        }

        public Builder sessionStickinessEnabled(IResolvable sessionStickinessEnabled) {
            this.props.sessionStickinessEnabled(sessionStickinessEnabled);
            return this;
        }

        public Builder sessionStickinessLbCookieDurationSeconds(String sessionStickinessLbCookieDurationSeconds) {
            this.props.sessionStickinessLbCookieDurationSeconds(sessionStickinessLbCookieDurationSeconds);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder tlsPolicyName(String tlsPolicyName) {
            this.props.tlsPolicyName(tlsPolicyName);
            return this;
        }

        public CfnLoadBalancer build() {
            return new CfnLoadBalancer(this.scope, this.id, this.props.build());
        }
    }
}

