/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.logs.destinations;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kinesis.IStream;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.awscdk.services.logs.ILogSubscriptionDestination;
import software.amazon.awscdk.services.logs.LogSubscriptionDestinationConfig;
import software.amazon.awscdk.services.logs.destinations.KinesisDestinationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_logs_destinations.KinesisDestination")
public class KinesisDestination
extends JsiiObject
implements ILogSubscriptionDestination {
    protected KinesisDestination(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KinesisDestination(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public KinesisDestination(@NotNull IStream stream, @Nullable KinesisDestinationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(stream, "stream is required"), props});
    }

    public KinesisDestination(@NotNull IStream stream) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(stream, "stream is required")});
    }

    @Override
    @NotNull
    public LogSubscriptionDestinationConfig bind(@NotNull Construct scope, @NotNull ILogGroup _sourceLogGroup) {
        return (LogSubscriptionDestinationConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(LogSubscriptionDestinationConfig.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(_sourceLogGroup, "_sourceLogGroup is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<KinesisDestination> {
        private final IStream stream;
        private KinesisDestinationProps.Builder props;

        public static Builder create(IStream stream) {
            return new Builder(stream);
        }

        private Builder(IStream stream) {
            this.stream = stream;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public KinesisDestination build() {
            return new KinesisDestination(this.stream, this.props != null ? this.props.build() : null);
        }

        private KinesisDestinationProps.Builder props() {
            if (this.props == null) {
                this.props = new KinesisDestinationProps.Builder();
            }
            return this.props;
        }
    }
}

