/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.mediaconnect;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.mediaconnect.CfnFlowSource;
import software.amazon.awscdk.services.mediaconnect.CfnFlowSourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_mediaconnect.CfnFlowSource")
public class CfnFlowSource
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFlowSource.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFlowSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlowSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFlowSource(@NotNull Construct scope, @NotNull String id, @NotNull CfnFlowSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrIngestIp() {
        return (String)Kernel.get((Object)this, (String)"attrIngestIp", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrSourceArn() {
        return (String)Kernel.get((Object)this, (String)"attrSourceArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrSourceIngestPort() {
        return (String)Kernel.get((Object)this, (String)"attrSourceIngestPort", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@NotNull String value) {
        Kernel.set((Object)this, (String)"description", (Object)Objects.requireNonNull(value, "description is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public Object getDecryption() {
        return Kernel.get((Object)this, (String)"decryption", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDecryption(@Nullable EncryptionProperty value) {
        Kernel.set((Object)this, (String)"decryption", (Object)value);
    }

    public void setDecryption(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"decryption", (Object)value);
    }

    @Nullable
    public String getEntitlementArn() {
        return (String)Kernel.get((Object)this, (String)"entitlementArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setEntitlementArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"entitlementArn", (Object)value);
    }

    @Nullable
    public String getFlowArn() {
        return (String)Kernel.get((Object)this, (String)"flowArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setFlowArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"flowArn", (Object)value);
    }

    @Nullable
    public Number getIngestPort() {
        return (Number)Kernel.get((Object)this, (String)"ingestPort", (NativeType)NativeType.forClass(Number.class));
    }

    public void setIngestPort(@Nullable Number value) {
        Kernel.set((Object)this, (String)"ingestPort", (Object)value);
    }

    @Nullable
    public Number getMaxBitrate() {
        return (Number)Kernel.get((Object)this, (String)"maxBitrate", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxBitrate(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxBitrate", (Object)value);
    }

    @Nullable
    public Number getMaxLatency() {
        return (Number)Kernel.get((Object)this, (String)"maxLatency", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxLatency(@Nullable Number value) {
        Kernel.set((Object)this, (String)"maxLatency", (Object)value);
    }

    @Nullable
    public String getProtocol() {
        return (String)Kernel.get((Object)this, (String)"protocol", (NativeType)NativeType.forClass(String.class));
    }

    public void setProtocol(@Nullable String value) {
        Kernel.set((Object)this, (String)"protocol", (Object)value);
    }

    @Nullable
    public String getStreamId() {
        return (String)Kernel.get((Object)this, (String)"streamId", (NativeType)NativeType.forClass(String.class));
    }

    public void setStreamId(@Nullable String value) {
        Kernel.set((Object)this, (String)"streamId", (Object)value);
    }

    @Nullable
    public String getVpcInterfaceName() {
        return (String)Kernel.get((Object)this, (String)"vpcInterfaceName", (NativeType)NativeType.forClass(String.class));
    }

    public void setVpcInterfaceName(@Nullable String value) {
        Kernel.set((Object)this, (String)"vpcInterfaceName", (Object)value);
    }

    @Nullable
    public String getWhitelistCidr() {
        return (String)Kernel.get((Object)this, (String)"whitelistCidr", (NativeType)NativeType.forClass(String.class));
    }

    public void setWhitelistCidr(@Nullable String value) {
        Kernel.set((Object)this, (String)"whitelistCidr", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFlowSource> {
        private final Construct scope;
        private final String id;
        private final CfnFlowSourceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFlowSourceProps.Builder();
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder decryption(EncryptionProperty decryption) {
            this.props.decryption(decryption);
            return this;
        }

        public Builder decryption(IResolvable decryption) {
            this.props.decryption(decryption);
            return this;
        }

        public Builder entitlementArn(String entitlementArn) {
            this.props.entitlementArn(entitlementArn);
            return this;
        }

        public Builder flowArn(String flowArn) {
            this.props.flowArn(flowArn);
            return this;
        }

        public Builder ingestPort(Number ingestPort) {
            this.props.ingestPort(ingestPort);
            return this;
        }

        public Builder maxBitrate(Number maxBitrate) {
            this.props.maxBitrate(maxBitrate);
            return this;
        }

        public Builder maxLatency(Number maxLatency) {
            this.props.maxLatency(maxLatency);
            return this;
        }

        public Builder protocol(String protocol) {
            this.props.protocol(protocol);
            return this;
        }

        public Builder streamId(String streamId) {
            this.props.streamId(streamId);
            return this;
        }

        public Builder vpcInterfaceName(String vpcInterfaceName) {
            this.props.vpcInterfaceName(vpcInterfaceName);
            return this;
        }

        public Builder whitelistCidr(String whitelistCidr) {
            this.props.whitelistCidr(whitelistCidr);
            return this;
        }

        public CfnFlowSource build() {
            return new CfnFlowSource(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_mediaconnect.CfnFlowSource.EncryptionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionProperty
    extends JsiiSerializable {
        @NotNull
        public String getAlgorithm();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public String getConstantInitializationVector() {
            return null;
        }

        @Nullable
        default public String getDeviceId() {
            return null;
        }

        @Nullable
        default public String getKeyType() {
            return null;
        }

        @Nullable
        default public String getRegion() {
            return null;
        }

        @Nullable
        default public String getResourceId() {
            return null;
        }

        @Nullable
        default public String getSecretArn() {
            return null;
        }

        @Nullable
        default public String getUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionProperty> {
            String algorithm;
            String roleArn;
            String constantInitializationVector;
            String deviceId;
            String keyType;
            String region;
            String resourceId;
            String secretArn;
            String url;

            public Builder algorithm(String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder constantInitializationVector(String constantInitializationVector) {
                this.constantInitializationVector = constantInitializationVector;
                return this;
            }

            public Builder deviceId(String deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            public Builder keyType(String keyType) {
                this.keyType = keyType;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public Builder resourceId(String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public EncryptionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

