/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.msk;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.msk.BrokerLogging;
import software.amazon.awscdk.services.msk.ClientAuthentication;
import software.amazon.awscdk.services.msk.ClusterConfigurationInfo;
import software.amazon.awscdk.services.msk.ClusterProps;
import software.amazon.awscdk.services.msk.EbsStorageInfo;
import software.amazon.awscdk.services.msk.EncryptionInTransitConfig;
import software.amazon.awscdk.services.msk.ICluster;
import software.amazon.awscdk.services.msk.KafkaVersion;
import software.amazon.awscdk.services.msk.MonitoringConfiguration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="monocdk.aws_msk.Cluster")
public class Cluster
extends Resource
implements ICluster {
    protected Cluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Cluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Cluster(@NotNull Construct scope, @NotNull String id, @NotNull ClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ICluster fromClusterArn(@NotNull Construct scope, @NotNull String id, @NotNull String clusterArn) {
        return (ICluster)JsiiObject.jsiiStaticCall(Cluster.class, (String)"fromClusterArn", (NativeType)NativeType.forClass(ICluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(clusterArn, "clusterArn is required")});
    }

    public void addUser(String ... usernames) {
        Kernel.call((Object)this, (String)"addUser", (NativeType)NativeType.VOID, (Object[])Arrays.stream(usernames).toArray(Object[]::new));
    }

    @NotNull
    public String getBootstrapBrokers() {
        return (String)Kernel.get((Object)this, (String)"bootstrapBrokers", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getBootstrapBrokersSaslScram() {
        return (String)Kernel.get((Object)this, (String)"bootstrapBrokersSaslScram", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getBootstrapBrokersTls() {
        return (String)Kernel.get((Object)this, (String)"bootstrapBrokersTls", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getClusterArn() {
        return (String)Kernel.get((Object)this, (String)"clusterArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getClusterName() {
        return (String)Kernel.get((Object)this, (String)"clusterName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @NotNull
    public String getZookeeperConnectionString() {
        return (String)Kernel.get((Object)this, (String)"zookeeperConnectionString", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getZookeeperConnectionStringTls() {
        return (String)Kernel.get((Object)this, (String)"zookeeperConnectionStringTls", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public IKey getSaslScramAuthenticationKey() {
        return (IKey)Kernel.get((Object)this, (String)"saslScramAuthenticationKey", (NativeType)NativeType.forClass(IKey.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Cluster> {
        private final Construct scope;
        private final String id;
        private final ClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ClusterProps.Builder();
        }

        public Builder clusterName(String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        public Builder kafkaVersion(KafkaVersion kafkaVersion) {
            this.props.kafkaVersion(kafkaVersion);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.props.clientAuthentication(clientAuthentication);
            return this;
        }

        public Builder configurationInfo(ClusterConfigurationInfo configurationInfo) {
            this.props.configurationInfo(configurationInfo);
            return this;
        }

        public Builder ebsStorageInfo(EbsStorageInfo ebsStorageInfo) {
            this.props.ebsStorageInfo(ebsStorageInfo);
            return this;
        }

        public Builder encryptionInTransit(EncryptionInTransitConfig encryptionInTransit) {
            this.props.encryptionInTransit(encryptionInTransit);
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder logging(BrokerLogging logging) {
            this.props.logging(logging);
            return this;
        }

        public Builder monitoring(MonitoringConfiguration monitoring) {
            this.props.monitoring(monitoring);
            return this;
        }

        public Builder numberOfBrokerNodes(Number numberOfBrokerNodes) {
            this.props.numberOfBrokerNodes(numberOfBrokerNodes);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Cluster build() {
            return new Cluster(this.scope, this.id, this.props.build());
        }
    }
}

