/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.neptune;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.neptune.DatabaseClusterBase;
import software.amazon.awscdk.services.neptune.DatabaseClusterProps;
import software.amazon.awscdk.services.neptune.Endpoint;
import software.amazon.awscdk.services.neptune.EngineVersion;
import software.amazon.awscdk.services.neptune.IClusterParameterGroup;
import software.amazon.awscdk.services.neptune.IDatabaseCluster;
import software.amazon.awscdk.services.neptune.IParameterGroup;
import software.amazon.awscdk.services.neptune.ISubnetGroup;
import software.amazon.awscdk.services.neptune.InstanceType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="monocdk.aws_neptune.DatabaseCluster")
public class DatabaseCluster
extends DatabaseClusterBase
implements IDatabaseCluster {
    public static final Number DEFAULT_NUM_INSTANCES = (Number)JsiiObject.jsiiStaticGet(DatabaseCluster.class, (String)"DEFAULT_NUM_INSTANCES", (NativeType)NativeType.forClass(Number.class));

    protected DatabaseCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DatabaseCluster(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public Endpoint getClusterEndpoint() {
        return (Endpoint)((Object)Kernel.get((Object)this, (String)"clusterEndpoint", (NativeType)NativeType.forClass(Endpoint.class)));
    }

    @Override
    @NotNull
    public String getClusterIdentifier() {
        return (String)Kernel.get((Object)this, (String)"clusterIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Endpoint getClusterReadEndpoint() {
        return (Endpoint)((Object)Kernel.get((Object)this, (String)"clusterReadEndpoint", (NativeType)NativeType.forClass(Endpoint.class)));
    }

    @Override
    @NotNull
    public String getClusterResourceIdentifier() {
        return (String)Kernel.get((Object)this, (String)"clusterResourceIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @NotNull
    public List<Endpoint> getInstanceEndpoints() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"instanceEndpoints", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Endpoint.class))));
    }

    @NotNull
    public List<String> getInstanceIdentifiers() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"instanceIdentifiers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public ISubnetGroup getSubnetGroup() {
        return (ISubnetGroup)Kernel.get((Object)this, (String)"subnetGroup", (NativeType)NativeType.forClass(ISubnetGroup.class));
    }

    @NotNull
    public IVpc getVpc() {
        return (IVpc)Kernel.get((Object)this, (String)"vpc", (NativeType)NativeType.forClass(IVpc.class));
    }

    @NotNull
    public SubnetSelection getVpcSubnets() {
        return (SubnetSelection)Kernel.get((Object)this, (String)"vpcSubnets", (NativeType)NativeType.forClass(SubnetSelection.class));
    }

    @Override
    @Nullable
    protected Boolean getEnableIamAuthentication() {
        return (Boolean)Kernel.get((Object)this, (String)"enableIamAuthentication", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    protected void setEnableIamAuthentication(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableIamAuthentication", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseCluster> {
        private final Construct scope;
        private final String id;
        private final DatabaseClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DatabaseClusterProps.Builder();
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder associatedRoles(List<? extends IRole> associatedRoles) {
            this.props.associatedRoles(associatedRoles);
            return this;
        }

        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        public Builder backupRetention(Duration backupRetention) {
            this.props.backupRetention(backupRetention);
            return this;
        }

        public Builder clusterParameterGroup(IClusterParameterGroup clusterParameterGroup) {
            this.props.clusterParameterGroup(clusterParameterGroup);
            return this;
        }

        public Builder dbClusterName(String dbClusterName) {
            this.props.dbClusterName(dbClusterName);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder engineVersion(EngineVersion engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        public Builder iamAuthentication(Boolean iamAuthentication) {
            this.props.iamAuthentication(iamAuthentication);
            return this;
        }

        public Builder instanceIdentifierBase(String instanceIdentifierBase) {
            this.props.instanceIdentifierBase(instanceIdentifierBase);
            return this;
        }

        public Builder instances(Number instances) {
            this.props.instances(instances);
            return this;
        }

        public Builder kmsKey(IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        public Builder parameterGroup(IParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder preferredBackupWindow(String preferredBackupWindow) {
            this.props.preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        public Builder subnetGroup(ISubnetGroup subnetGroup) {
            this.props.subnetGroup(subnetGroup);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public DatabaseCluster build() {
            return new DatabaseCluster(this.scope, this.id, this.props.build());
        }
    }
}

