/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.neptune;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.neptune.DatabaseClusterProps;
import software.amazon.awscdk.services.neptune.EngineVersion;
import software.amazon.awscdk.services.neptune.IClusterParameterGroup;
import software.amazon.awscdk.services.neptune.IParameterGroup;
import software.amazon.awscdk.services.neptune.ISubnetGroup;
import software.amazon.awscdk.services.neptune.InstanceType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="monocdk.aws_neptune.DatabaseClusterProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface DatabaseClusterProps
extends JsiiSerializable {
    @NotNull
    public InstanceType getInstanceType();

    @NotNull
    public IVpc getVpc();

    @Nullable
    default public List<IRole> getAssociatedRoles() {
        return null;
    }

    @Nullable
    default public Boolean getAutoMinorVersionUpgrade() {
        return null;
    }

    @Nullable
    default public Duration getBackupRetention() {
        return null;
    }

    @Nullable
    default public IClusterParameterGroup getClusterParameterGroup() {
        return null;
    }

    @Nullable
    default public String getDbClusterName() {
        return null;
    }

    @Nullable
    default public Boolean getDeletionProtection() {
        return null;
    }

    @Nullable
    default public EngineVersion getEngineVersion() {
        return null;
    }

    @Nullable
    default public Boolean getIamAuthentication() {
        return null;
    }

    @Nullable
    default public String getInstanceIdentifierBase() {
        return null;
    }

    @Nullable
    default public Number getInstances() {
        return null;
    }

    @Nullable
    default public IKey getKmsKey() {
        return null;
    }

    @Nullable
    default public IParameterGroup getParameterGroup() {
        return null;
    }

    @Nullable
    default public Number getPort() {
        return null;
    }

    @Nullable
    default public String getPreferredBackupWindow() {
        return null;
    }

    @Nullable
    default public String getPreferredMaintenanceWindow() {
        return null;
    }

    @Nullable
    default public RemovalPolicy getRemovalPolicy() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public Boolean getStorageEncrypted() {
        return null;
    }

    @Nullable
    default public ISubnetGroup getSubnetGroup() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseClusterProps> {
        InstanceType instanceType;
        IVpc vpc;
        List<IRole> associatedRoles;
        Boolean autoMinorVersionUpgrade;
        Duration backupRetention;
        IClusterParameterGroup clusterParameterGroup;
        String dbClusterName;
        Boolean deletionProtection;
        EngineVersion engineVersion;
        Boolean iamAuthentication;
        String instanceIdentifierBase;
        Number instances;
        IKey kmsKey;
        IParameterGroup parameterGroup;
        Number port;
        String preferredBackupWindow;
        String preferredMaintenanceWindow;
        RemovalPolicy removalPolicy;
        List<ISecurityGroup> securityGroups;
        Boolean storageEncrypted;
        ISubnetGroup subnetGroup;
        SubnetSelection vpcSubnets;

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder associatedRoles(List<? extends IRole> associatedRoles) {
            this.associatedRoles = associatedRoles;
            return this;
        }

        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public Builder backupRetention(Duration backupRetention) {
            this.backupRetention = backupRetention;
            return this;
        }

        public Builder clusterParameterGroup(IClusterParameterGroup clusterParameterGroup) {
            this.clusterParameterGroup = clusterParameterGroup;
            return this;
        }

        public Builder dbClusterName(String dbClusterName) {
            this.dbClusterName = dbClusterName;
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public Builder engineVersion(EngineVersion engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public Builder iamAuthentication(Boolean iamAuthentication) {
            this.iamAuthentication = iamAuthentication;
            return this;
        }

        public Builder instanceIdentifierBase(String instanceIdentifierBase) {
            this.instanceIdentifierBase = instanceIdentifierBase;
            return this;
        }

        public Builder instances(Number instances) {
            this.instances = instances;
            return this;
        }

        public Builder kmsKey(IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public Builder parameterGroup(IParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public Builder subnetGroup(ISubnetGroup subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public DatabaseClusterProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

