/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.neptune;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.RemovalPolicy;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.neptune.ISubnetGroup;
import software.amazon.awscdk.services.neptune.SubnetGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="monocdk.aws_neptune.SubnetGroup")
public class SubnetGroup
extends Resource
implements ISubnetGroup {
    protected SubnetGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SubnetGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SubnetGroup(@NotNull Construct scope, @NotNull String id, @NotNull SubnetGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ISubnetGroup fromSubnetGroupName(@NotNull Construct scope, @NotNull String id, @NotNull String subnetGroupName) {
        return (ISubnetGroup)JsiiObject.jsiiStaticCall(SubnetGroup.class, (String)"fromSubnetGroupName", (NativeType)NativeType.forClass(ISubnetGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(subnetGroupName, "subnetGroupName is required")});
    }

    @Override
    @NotNull
    public String getSubnetGroupName() {
        return (String)Kernel.get((Object)this, (String)"subnetGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SubnetGroup> {
        private final Construct scope;
        private final String id;
        private final SubnetGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new SubnetGroupProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder subnetGroupName(String subnetGroupName) {
            this.props.subnetGroupName(subnetGroupName);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public SubnetGroup build() {
            return new SubnetGroup(this.scope, this.id, this.props.build());
        }
    }
}

