/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.opsworks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.opsworks.CfnInstance;
import software.amazon.awscdk.services.opsworks.CfnInstanceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_opsworks.CfnInstance")
public class CfnInstance
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnInstance.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnInstance(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstance(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnInstance(@NotNull Construct scope, @NotNull String id, @NotNull CfnInstanceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrAvailabilityZone() {
        return (String)Kernel.get((Object)this, (String)"attrAvailabilityZone", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrPrivateDnsName() {
        return (String)Kernel.get((Object)this, (String)"attrPrivateDnsName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrPrivateIp() {
        return (String)Kernel.get((Object)this, (String)"attrPrivateIp", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrPublicDnsName() {
        return (String)Kernel.get((Object)this, (String)"attrPublicDnsName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrPublicIp() {
        return (String)Kernel.get((Object)this, (String)"attrPublicIp", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getInstanceType() {
        return (String)Kernel.get((Object)this, (String)"instanceType", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceType(@NotNull String value) {
        Kernel.set((Object)this, (String)"instanceType", (Object)Objects.requireNonNull(value, "instanceType is required"));
    }

    @NotNull
    public List<String> getLayerIds() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"layerIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    public void setLayerIds(@NotNull List<String> value) {
        Kernel.set((Object)this, (String)"layerIds", Objects.requireNonNull(value, "layerIds is required"));
    }

    @NotNull
    public String getStackId() {
        return (String)Kernel.get((Object)this, (String)"stackId", (NativeType)NativeType.forClass(String.class));
    }

    public void setStackId(@NotNull String value) {
        Kernel.set((Object)this, (String)"stackId", (Object)Objects.requireNonNull(value, "stackId is required"));
    }

    @Nullable
    public String getAgentVersion() {
        return (String)Kernel.get((Object)this, (String)"agentVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setAgentVersion(@Nullable String value) {
        Kernel.set((Object)this, (String)"agentVersion", (Object)value);
    }

    @Nullable
    public String getAmiId() {
        return (String)Kernel.get((Object)this, (String)"amiId", (NativeType)NativeType.forClass(String.class));
    }

    public void setAmiId(@Nullable String value) {
        Kernel.set((Object)this, (String)"amiId", (Object)value);
    }

    @Nullable
    public String getArchitecture() {
        return (String)Kernel.get((Object)this, (String)"architecture", (NativeType)NativeType.forClass(String.class));
    }

    public void setArchitecture(@Nullable String value) {
        Kernel.set((Object)this, (String)"architecture", (Object)value);
    }

    @Nullable
    public String getAutoScalingType() {
        return (String)Kernel.get((Object)this, (String)"autoScalingType", (NativeType)NativeType.forClass(String.class));
    }

    public void setAutoScalingType(@Nullable String value) {
        Kernel.set((Object)this, (String)"autoScalingType", (Object)value);
    }

    @Nullable
    public String getAvailabilityZone() {
        return (String)Kernel.get((Object)this, (String)"availabilityZone", (NativeType)NativeType.forClass(String.class));
    }

    public void setAvailabilityZone(@Nullable String value) {
        Kernel.set((Object)this, (String)"availabilityZone", (Object)value);
    }

    @Nullable
    public Object getBlockDeviceMappings() {
        return Kernel.get((Object)this, (String)"blockDeviceMappings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBlockDeviceMappings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"blockDeviceMappings", (Object)value);
    }

    public void setBlockDeviceMappings(@Nullable List<Object> value) {
        Kernel.set((Object)this, (String)"blockDeviceMappings", value);
    }

    @Nullable
    public Object getEbsOptimized() {
        return Kernel.get((Object)this, (String)"ebsOptimized", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEbsOptimized(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"ebsOptimized", (Object)value);
    }

    public void setEbsOptimized(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"ebsOptimized", (Object)value);
    }

    @Nullable
    public List<String> getElasticIps() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"elasticIps", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setElasticIps(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"elasticIps", value);
    }

    @Nullable
    public String getHostname() {
        return (String)Kernel.get((Object)this, (String)"hostname", (NativeType)NativeType.forClass(String.class));
    }

    public void setHostname(@Nullable String value) {
        Kernel.set((Object)this, (String)"hostname", (Object)value);
    }

    @Nullable
    public Object getInstallUpdatesOnBoot() {
        return Kernel.get((Object)this, (String)"installUpdatesOnBoot", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInstallUpdatesOnBoot(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"installUpdatesOnBoot", (Object)value);
    }

    public void setInstallUpdatesOnBoot(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"installUpdatesOnBoot", (Object)value);
    }

    @Nullable
    public String getOs() {
        return (String)Kernel.get((Object)this, (String)"os", (NativeType)NativeType.forClass(String.class));
    }

    public void setOs(@Nullable String value) {
        Kernel.set((Object)this, (String)"os", (Object)value);
    }

    @Nullable
    public String getRootDeviceType() {
        return (String)Kernel.get((Object)this, (String)"rootDeviceType", (NativeType)NativeType.forClass(String.class));
    }

    public void setRootDeviceType(@Nullable String value) {
        Kernel.set((Object)this, (String)"rootDeviceType", (Object)value);
    }

    @Nullable
    public String getSshKeyName() {
        return (String)Kernel.get((Object)this, (String)"sshKeyName", (NativeType)NativeType.forClass(String.class));
    }

    public void setSshKeyName(@Nullable String value) {
        Kernel.set((Object)this, (String)"sshKeyName", (Object)value);
    }

    @Nullable
    public String getSubnetId() {
        return (String)Kernel.get((Object)this, (String)"subnetId", (NativeType)NativeType.forClass(String.class));
    }

    public void setSubnetId(@Nullable String value) {
        Kernel.set((Object)this, (String)"subnetId", (Object)value);
    }

    @Nullable
    public String getTenancy() {
        return (String)Kernel.get((Object)this, (String)"tenancy", (NativeType)NativeType.forClass(String.class));
    }

    public void setTenancy(@Nullable String value) {
        Kernel.set((Object)this, (String)"tenancy", (Object)value);
    }

    @Nullable
    public Object getTimeBasedAutoScaling() {
        return Kernel.get((Object)this, (String)"timeBasedAutoScaling", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTimeBasedAutoScaling(@Nullable TimeBasedAutoScalingProperty value) {
        Kernel.set((Object)this, (String)"timeBasedAutoScaling", (Object)value);
    }

    public void setTimeBasedAutoScaling(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"timeBasedAutoScaling", (Object)value);
    }

    @Nullable
    public String getVirtualizationType() {
        return (String)Kernel.get((Object)this, (String)"virtualizationType", (NativeType)NativeType.forClass(String.class));
    }

    public void setVirtualizationType(@Nullable String value) {
        Kernel.set((Object)this, (String)"virtualizationType", (Object)value);
    }

    @Nullable
    public List<String> getVolumes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"volumes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setVolumes(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"volumes", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnInstance> {
        private final Construct scope;
        private final String id;
        private final CfnInstanceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnInstanceProps.Builder();
        }

        public Builder instanceType(String instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder layerIds(List<String> layerIds) {
            this.props.layerIds(layerIds);
            return this;
        }

        public Builder stackId(String stackId) {
            this.props.stackId(stackId);
            return this;
        }

        public Builder agentVersion(String agentVersion) {
            this.props.agentVersion(agentVersion);
            return this;
        }

        public Builder amiId(String amiId) {
            this.props.amiId(amiId);
            return this;
        }

        public Builder architecture(String architecture) {
            this.props.architecture(architecture);
            return this;
        }

        public Builder autoScalingType(String autoScalingType) {
            this.props.autoScalingType(autoScalingType);
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        public Builder blockDeviceMappings(IResolvable blockDeviceMappings) {
            this.props.blockDeviceMappings(blockDeviceMappings);
            return this;
        }

        public Builder blockDeviceMappings(List<? extends Object> blockDeviceMappings) {
            this.props.blockDeviceMappings(blockDeviceMappings);
            return this;
        }

        public Builder ebsOptimized(Boolean ebsOptimized) {
            this.props.ebsOptimized(ebsOptimized);
            return this;
        }

        public Builder ebsOptimized(IResolvable ebsOptimized) {
            this.props.ebsOptimized(ebsOptimized);
            return this;
        }

        public Builder elasticIps(List<String> elasticIps) {
            this.props.elasticIps(elasticIps);
            return this;
        }

        public Builder hostname(String hostname) {
            this.props.hostname(hostname);
            return this;
        }

        public Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.props.installUpdatesOnBoot(installUpdatesOnBoot);
            return this;
        }

        public Builder installUpdatesOnBoot(IResolvable installUpdatesOnBoot) {
            this.props.installUpdatesOnBoot(installUpdatesOnBoot);
            return this;
        }

        public Builder os(String os) {
            this.props.os(os);
            return this;
        }

        public Builder rootDeviceType(String rootDeviceType) {
            this.props.rootDeviceType(rootDeviceType);
            return this;
        }

        public Builder sshKeyName(String sshKeyName) {
            this.props.sshKeyName(sshKeyName);
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.props.subnetId(subnetId);
            return this;
        }

        public Builder tenancy(String tenancy) {
            this.props.tenancy(tenancy);
            return this;
        }

        public Builder timeBasedAutoScaling(TimeBasedAutoScalingProperty timeBasedAutoScaling) {
            this.props.timeBasedAutoScaling(timeBasedAutoScaling);
            return this;
        }

        public Builder timeBasedAutoScaling(IResolvable timeBasedAutoScaling) {
            this.props.timeBasedAutoScaling(timeBasedAutoScaling);
            return this;
        }

        public Builder virtualizationType(String virtualizationType) {
            this.props.virtualizationType(virtualizationType);
            return this;
        }

        public Builder volumes(List<String> volumes) {
            this.props.volumes(volumes);
            return this;
        }

        public CfnInstance build() {
            return new CfnInstance(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_opsworks.CfnInstance.TimeBasedAutoScalingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimeBasedAutoScalingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFriday() {
            return null;
        }

        @Nullable
        default public Object getMonday() {
            return null;
        }

        @Nullable
        default public Object getSaturday() {
            return null;
        }

        @Nullable
        default public Object getSunday() {
            return null;
        }

        @Nullable
        default public Object getThursday() {
            return null;
        }

        @Nullable
        default public Object getTuesday() {
            return null;
        }

        @Nullable
        default public Object getWednesday() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimeBasedAutoScalingProperty> {
            Object friday;
            Object monday;
            Object saturday;
            Object sunday;
            Object thursday;
            Object tuesday;
            Object wednesday;

            public Builder friday(IResolvable friday) {
                this.friday = friday;
                return this;
            }

            public Builder friday(Map<String, String> friday) {
                this.friday = friday;
                return this;
            }

            public Builder monday(IResolvable monday) {
                this.monday = monday;
                return this;
            }

            public Builder monday(Map<String, String> monday) {
                this.monday = monday;
                return this;
            }

            public Builder saturday(IResolvable saturday) {
                this.saturday = saturday;
                return this;
            }

            public Builder saturday(Map<String, String> saturday) {
                this.saturday = saturday;
                return this;
            }

            public Builder sunday(IResolvable sunday) {
                this.sunday = sunday;
                return this;
            }

            public Builder sunday(Map<String, String> sunday) {
                this.sunday = sunday;
                return this;
            }

            public Builder thursday(IResolvable thursday) {
                this.thursday = thursday;
                return this;
            }

            public Builder thursday(Map<String, String> thursday) {
                this.thursday = thursday;
                return this;
            }

            public Builder tuesday(IResolvable tuesday) {
                this.tuesday = tuesday;
                return this;
            }

            public Builder tuesday(Map<String, String> tuesday) {
                this.tuesday = tuesday;
                return this;
            }

            public Builder wednesday(IResolvable wednesday) {
                this.wednesday = wednesday;
                return this;
            }

            public Builder wednesday(Map<String, String> wednesday) {
                this.wednesday = wednesday;
                return this;
            }

            public TimeBasedAutoScalingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_opsworks.CfnInstance.EbsBlockDeviceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EbsBlockDeviceProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDeleteOnTermination() {
            return null;
        }

        @Nullable
        default public Number getIops() {
            return null;
        }

        @Nullable
        default public String getSnapshotId() {
            return null;
        }

        @Nullable
        default public Number getVolumeSize() {
            return null;
        }

        @Nullable
        default public String getVolumeType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EbsBlockDeviceProperty> {
            Object deleteOnTermination;
            Number iops;
            String snapshotId;
            Number volumeSize;
            String volumeType;

            public Builder deleteOnTermination(Boolean deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder deleteOnTermination(IResolvable deleteOnTermination) {
                this.deleteOnTermination = deleteOnTermination;
                return this;
            }

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public Builder snapshotId(String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            public Builder volumeSize(Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            public Builder volumeType(String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            public EbsBlockDeviceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_opsworks.CfnInstance.BlockDeviceMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BlockDeviceMappingProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDeviceName() {
            return null;
        }

        @Nullable
        default public Object getEbs() {
            return null;
        }

        @Nullable
        default public String getNoDevice() {
            return null;
        }

        @Nullable
        default public String getVirtualName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BlockDeviceMappingProperty> {
            String deviceName;
            Object ebs;
            String noDevice;
            String virtualName;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder ebs(EbsBlockDeviceProperty ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder ebs(IResolvable ebs) {
                this.ebs = ebs;
                return this;
            }

            public Builder noDevice(String noDevice) {
                this.noDevice = noDevice;
                return this;
            }

            public Builder virtualName(String virtualName) {
                this.virtualName = virtualName;
                return this;
            }

            public BlockDeviceMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

