/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.pinpoint;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.pinpoint.CfnSegment;
import software.amazon.awscdk.services.pinpoint.CfnSegmentProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_pinpoint.CfnSegment")
public class CfnSegment
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnSegment.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnSegment(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSegment(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnSegment(@NotNull Construct scope, @NotNull String id, @NotNull CfnSegmentProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrSegmentId() {
        return (String)Kernel.get((Object)this, (String)"attrSegmentId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getApplicationId() {
        return (String)Kernel.get((Object)this, (String)"applicationId", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationId(@NotNull String value) {
        Kernel.set((Object)this, (String)"applicationId", (Object)Objects.requireNonNull(value, "applicationId is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public Object getDimensions() {
        return Kernel.get((Object)this, (String)"dimensions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDimensions(@Nullable SegmentDimensionsProperty value) {
        Kernel.set((Object)this, (String)"dimensions", (Object)value);
    }

    public void setDimensions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"dimensions", (Object)value);
    }

    @Nullable
    public Object getSegmentGroups() {
        return Kernel.get((Object)this, (String)"segmentGroups", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSegmentGroups(@Nullable SegmentGroupsProperty value) {
        Kernel.set((Object)this, (String)"segmentGroups", (Object)value);
    }

    public void setSegmentGroups(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"segmentGroups", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnSegment> {
        private final Construct scope;
        private final String id;
        private final CfnSegmentProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnSegmentProps.Builder();
        }

        public Builder applicationId(String applicationId) {
            this.props.applicationId(applicationId);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder dimensions(SegmentDimensionsProperty dimensions) {
            this.props.dimensions(dimensions);
            return this;
        }

        public Builder dimensions(IResolvable dimensions) {
            this.props.dimensions(dimensions);
            return this;
        }

        public Builder segmentGroups(SegmentGroupsProperty segmentGroups) {
            this.props.segmentGroups(segmentGroups);
            return this;
        }

        public Builder segmentGroups(IResolvable segmentGroups) {
            this.props.segmentGroups(segmentGroups);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnSegment build() {
            return new CfnSegment(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_pinpoint.CfnSegment.SourceSegmentsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceSegmentsProperty
    extends JsiiSerializable {
        @NotNull
        public String getId();

        @Nullable
        default public Number getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceSegmentsProperty> {
            String id;
            Number version;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder version(Number version) {
                this.version = version;
                return this;
            }

            public SourceSegmentsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_pinpoint.CfnSegment.SetDimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SetDimensionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDimensionType() {
            return null;
        }

        @Nullable
        default public List<String> getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SetDimensionProperty> {
            String dimensionType;
            List<String> values;

            public Builder dimensionType(String dimensionType) {
                this.dimensionType = dimensionType;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public SetDimensionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_pinpoint.CfnSegment.SegmentGroupsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SegmentGroupsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGroups() {
            return null;
        }

        @Nullable
        default public String getInclude() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SegmentGroupsProperty> {
            Object groups;
            String include;

            public Builder groups(IResolvable groups) {
                this.groups = groups;
                return this;
            }

            public Builder groups(List<? extends Object> groups) {
                this.groups = groups;
                return this;
            }

            public Builder include(String include) {
                this.include = include;
                return this;
            }

            public SegmentGroupsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_pinpoint.CfnSegment.SegmentDimensionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SegmentDimensionsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAttributes() {
            return null;
        }

        @Nullable
        default public Object getBehavior() {
            return null;
        }

        @Nullable
        default public Object getDemographic() {
            return null;
        }

        @Nullable
        default public Object getLocation() {
            return null;
        }

        @Nullable
        default public Object getMetrics() {
            return null;
        }

        @Nullable
        default public Object getUserAttributes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SegmentDimensionsProperty> {
            Object attributes;
            Object behavior;
            Object demographic;
            Object location;
            Object metrics;
            Object userAttributes;

            public Builder attributes(Object attributes) {
                this.attributes = attributes;
                return this;
            }

            public Builder behavior(BehaviorProperty behavior) {
                this.behavior = behavior;
                return this;
            }

            public Builder behavior(IResolvable behavior) {
                this.behavior = behavior;
                return this;
            }

            public Builder demographic(DemographicProperty demographic) {
                this.demographic = demographic;
                return this;
            }

            public Builder demographic(IResolvable demographic) {
                this.demographic = demographic;
                return this;
            }

            public Builder location(LocationProperty location) {
                this.location = location;
                return this;
            }

            public Builder location(IResolvable location) {
                this.location = location;
                return this;
            }

            public Builder metrics(Object metrics) {
                this.metrics = metrics;
                return this;
            }

            public Builder userAttributes(Object userAttributes) {
                this.userAttributes = userAttributes;
                return this;
            }

            public SegmentDimensionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_pinpoint.CfnSegment.RecencyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RecencyProperty
    extends JsiiSerializable {
        @NotNull
        public String getDuration();

        @NotNull
        public String getRecencyType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RecencyProperty> {
            String duration;
            String recencyType;

            public Builder duration(String duration) {
                this.duration = duration;
                return this;
            }

            public Builder recencyType(String recencyType) {
                this.recencyType = recencyType;
                return this;
            }

            public RecencyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_pinpoint.CfnSegment.LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LocationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCountry() {
            return null;
        }

        @Nullable
        default public Object getGpsPoint() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LocationProperty> {
            Object country;
            Object gpsPoint;

            public Builder country(SetDimensionProperty country) {
                this.country = country;
                return this;
            }

            public Builder country(IResolvable country) {
                this.country = country;
                return this;
            }

            public Builder gpsPoint(GPSPointProperty gpsPoint) {
                this.gpsPoint = gpsPoint;
                return this;
            }

            public Builder gpsPoint(IResolvable gpsPoint) {
                this.gpsPoint = gpsPoint;
                return this;
            }

            public LocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_pinpoint.CfnSegment.GroupsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GroupsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDimensions() {
            return null;
        }

        @Nullable
        default public Object getSourceSegments() {
            return null;
        }

        @Nullable
        default public String getSourceType() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GroupsProperty> {
            Object dimensions;
            Object sourceSegments;
            String sourceType;
            String type;

            public Builder dimensions(IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder dimensions(List<? extends Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            public Builder sourceSegments(IResolvable sourceSegments) {
                this.sourceSegments = sourceSegments;
                return this;
            }

            public Builder sourceSegments(List<? extends Object> sourceSegments) {
                this.sourceSegments = sourceSegments;
                return this;
            }

            public Builder sourceType(String sourceType) {
                this.sourceType = sourceType;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public GroupsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_pinpoint.CfnSegment.GPSPointProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GPSPointProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCoordinates();

        @NotNull
        public Number getRangeInKilometers();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GPSPointProperty> {
            Object coordinates;
            Number rangeInKilometers;

            public Builder coordinates(CoordinatesProperty coordinates) {
                this.coordinates = coordinates;
                return this;
            }

            public Builder coordinates(IResolvable coordinates) {
                this.coordinates = coordinates;
                return this;
            }

            public Builder rangeInKilometers(Number rangeInKilometers) {
                this.rangeInKilometers = rangeInKilometers;
                return this;
            }

            public GPSPointProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_pinpoint.CfnSegment.DemographicProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DemographicProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAppVersion() {
            return null;
        }

        @Nullable
        default public Object getChannel() {
            return null;
        }

        @Nullable
        default public Object getDeviceType() {
            return null;
        }

        @Nullable
        default public Object getMake() {
            return null;
        }

        @Nullable
        default public Object getModel() {
            return null;
        }

        @Nullable
        default public Object getPlatform() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DemographicProperty> {
            Object appVersion;
            Object channel;
            Object deviceType;
            Object make;
            Object model;
            Object platform;

            public Builder appVersion(SetDimensionProperty appVersion) {
                this.appVersion = appVersion;
                return this;
            }

            public Builder appVersion(IResolvable appVersion) {
                this.appVersion = appVersion;
                return this;
            }

            public Builder channel(SetDimensionProperty channel) {
                this.channel = channel;
                return this;
            }

            public Builder channel(IResolvable channel) {
                this.channel = channel;
                return this;
            }

            public Builder deviceType(SetDimensionProperty deviceType) {
                this.deviceType = deviceType;
                return this;
            }

            public Builder deviceType(IResolvable deviceType) {
                this.deviceType = deviceType;
                return this;
            }

            public Builder make(SetDimensionProperty make) {
                this.make = make;
                return this;
            }

            public Builder make(IResolvable make) {
                this.make = make;
                return this;
            }

            public Builder model(SetDimensionProperty model) {
                this.model = model;
                return this;
            }

            public Builder model(IResolvable model) {
                this.model = model;
                return this;
            }

            public Builder platform(SetDimensionProperty platform) {
                this.platform = platform;
                return this;
            }

            public Builder platform(IResolvable platform) {
                this.platform = platform;
                return this;
            }

            public DemographicProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_pinpoint.CfnSegment.CoordinatesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CoordinatesProperty
    extends JsiiSerializable {
        @NotNull
        public Number getLatitude();

        @NotNull
        public Number getLongitude();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CoordinatesProperty> {
            Number latitude;
            Number longitude;

            public Builder latitude(Number latitude) {
                this.latitude = latitude;
                return this;
            }

            public Builder longitude(Number longitude) {
                this.longitude = longitude;
                return this;
            }

            public CoordinatesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_pinpoint.CfnSegment.BehaviorProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BehaviorProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getRecency() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BehaviorProperty> {
            Object recency;

            public Builder recency(RecencyProperty recency) {
                this.recency = recency;
                return this;
            }

            public Builder recency(IResolvable recency) {
                this.recency = recency;
                return this;
            }

            public BehaviorProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_pinpoint.CfnSegment.AttributeDimensionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AttributeDimensionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAttributeType() {
            return null;
        }

        @Nullable
        default public List<String> getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AttributeDimensionProperty> {
            String attributeType;
            List<String> values;

            public Builder attributeType(String attributeType) {
                this.attributeType = attributeType;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public AttributeDimensionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

