/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.resiliencehub;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.resiliencehub.CfnApp;
import software.amazon.awscdk.services.resiliencehub.CfnAppProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="monocdk.aws_resiliencehub.CfnApp")
public class CfnApp
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApp.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnApp(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApp(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApp(@NotNull Construct scope, @NotNull String id, @NotNull CfnAppProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrAppArn() {
        return (String)Kernel.get((Object)this, (String)"attrAppArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getAppTemplateBody() {
        return (String)Kernel.get((Object)this, (String)"appTemplateBody", (NativeType)NativeType.forClass(String.class));
    }

    public void setAppTemplateBody(@NotNull String value) {
        Kernel.set((Object)this, (String)"appTemplateBody", (Object)Objects.requireNonNull(value, "appTemplateBody is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public Object getResourceMappings() {
        return Kernel.get((Object)this, (String)"resourceMappings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setResourceMappings(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"resourceMappings", (Object)Objects.requireNonNull(value, "resourceMappings is required"));
    }

    public void setResourceMappings(@NotNull List<Object> value) {
        Kernel.set((Object)this, (String)"resourceMappings", Objects.requireNonNull(value, "resourceMappings is required"));
    }

    @Nullable
    public String getAppAssessmentSchedule() {
        return (String)Kernel.get((Object)this, (String)"appAssessmentSchedule", (NativeType)NativeType.forClass(String.class));
    }

    public void setAppAssessmentSchedule(@Nullable String value) {
        Kernel.set((Object)this, (String)"appAssessmentSchedule", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getResiliencyPolicyArn() {
        return (String)Kernel.get((Object)this, (String)"resiliencyPolicyArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setResiliencyPolicyArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"resiliencyPolicyArn", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApp> {
        private final Construct scope;
        private final String id;
        private final CfnAppProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAppProps.Builder();
        }

        public Builder appTemplateBody(String appTemplateBody) {
            this.props.appTemplateBody(appTemplateBody);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder resourceMappings(IResolvable resourceMappings) {
            this.props.resourceMappings(resourceMappings);
            return this;
        }

        public Builder resourceMappings(List<? extends Object> resourceMappings) {
            this.props.resourceMappings(resourceMappings);
            return this;
        }

        public Builder appAssessmentSchedule(String appAssessmentSchedule) {
            this.props.appAssessmentSchedule(appAssessmentSchedule);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder resiliencyPolicyArn(String resiliencyPolicyArn) {
            this.props.resiliencyPolicyArn(resiliencyPolicyArn);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnApp build() {
            return new CfnApp(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_resiliencehub.CfnApp.ResourceMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getMappingType();

        @NotNull
        public Object getPhysicalResourceId();

        @Nullable
        default public String getLogicalStackName() {
            return null;
        }

        @Nullable
        default public String getResourceName() {
            return null;
        }

        @Nullable
        default public String getTerraformSourceName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceMappingProperty> {
            String mappingType;
            Object physicalResourceId;
            String logicalStackName;
            String resourceName;
            String terraformSourceName;

            public Builder mappingType(String mappingType) {
                this.mappingType = mappingType;
                return this;
            }

            public Builder physicalResourceId(PhysicalResourceIdProperty physicalResourceId) {
                this.physicalResourceId = physicalResourceId;
                return this;
            }

            public Builder physicalResourceId(IResolvable physicalResourceId) {
                this.physicalResourceId = physicalResourceId;
                return this;
            }

            public Builder logicalStackName(String logicalStackName) {
                this.logicalStackName = logicalStackName;
                return this;
            }

            public Builder resourceName(String resourceName) {
                this.resourceName = resourceName;
                return this;
            }

            public Builder terraformSourceName(String terraformSourceName) {
                this.terraformSourceName = terraformSourceName;
                return this;
            }

            public ResourceMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="monocdk.aws_resiliencehub.CfnApp.PhysicalResourceIdProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PhysicalResourceIdProperty
    extends JsiiSerializable {
        @NotNull
        public String getIdentifier();

        @NotNull
        public String getType();

        @Nullable
        default public String getAwsAccountId() {
            return null;
        }

        @Nullable
        default public String getAwsRegion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PhysicalResourceIdProperty> {
            String identifier;
            String type;
            String awsAccountId;
            String awsRegion;

            public Builder identifier(String identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder awsAccountId(String awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            public Builder awsRegion(String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            public PhysicalResourceIdProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

