/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.route53resolver;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.route53resolver.FirewallRule;
import software.amazon.awscdk.services.route53resolver.FirewallRuleGroupAssociation;
import software.amazon.awscdk.services.route53resolver.FirewallRuleGroupAssociationOptions;
import software.amazon.awscdk.services.route53resolver.FirewallRuleGroupProps;
import software.amazon.awscdk.services.route53resolver.IFirewallRuleGroup;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="monocdk.aws_route53resolver.FirewallRuleGroup")
public class FirewallRuleGroup
extends Resource
implements IFirewallRuleGroup {
    protected FirewallRuleGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FirewallRuleGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public FirewallRuleGroup(@NotNull Construct scope, @NotNull String id, @Nullable FirewallRuleGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public FirewallRuleGroup(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IFirewallRuleGroup fromFirewallRuleGroupId(@NotNull Construct scope, @NotNull String id, @NotNull String firewallRuleGroupId) {
        return (IFirewallRuleGroup)JsiiObject.jsiiStaticCall(FirewallRuleGroup.class, (String)"fromFirewallRuleGroupId", (NativeType)NativeType.forClass(IFirewallRuleGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(firewallRuleGroupId, "firewallRuleGroupId is required")});
    }

    @NotNull
    public FirewallRuleGroup addRule(@NotNull FirewallRule rule) {
        return (FirewallRuleGroup)Kernel.call((Object)this, (String)"addRule", (NativeType)NativeType.forClass(FirewallRuleGroup.class), (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    @NotNull
    public FirewallRuleGroupAssociation associate(@NotNull String id, @NotNull FirewallRuleGroupAssociationOptions props) {
        return (FirewallRuleGroupAssociation)Kernel.call((Object)this, (String)"associate", (NativeType)NativeType.forClass(FirewallRuleGroupAssociation.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public String getFirewallRuleGroupArn() {
        return (String)Kernel.get((Object)this, (String)"firewallRuleGroupArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getFirewallRuleGroupCreationTime() {
        return (String)Kernel.get((Object)this, (String)"firewallRuleGroupCreationTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getFirewallRuleGroupCreatorRequestId() {
        return (String)Kernel.get((Object)this, (String)"firewallRuleGroupCreatorRequestId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getFirewallRuleGroupId() {
        return (String)Kernel.get((Object)this, (String)"firewallRuleGroupId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getFirewallRuleGroupModificationTime() {
        return (String)Kernel.get((Object)this, (String)"firewallRuleGroupModificationTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getFirewallRuleGroupOwnerId() {
        return (String)Kernel.get((Object)this, (String)"firewallRuleGroupOwnerId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Number getFirewallRuleGroupRuleCount() {
        return (Number)Kernel.get((Object)this, (String)"firewallRuleGroupRuleCount", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public String getFirewallRuleGroupShareStatus() {
        return (String)Kernel.get((Object)this, (String)"firewallRuleGroupShareStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getFirewallRuleGroupStatus() {
        return (String)Kernel.get((Object)this, (String)"firewallRuleGroupStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getFirewallRuleGroupStatusMessage() {
        return (String)Kernel.get((Object)this, (String)"firewallRuleGroupStatusMessage", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FirewallRuleGroup> {
        private final Construct scope;
        private final String id;
        private FirewallRuleGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder name(String name) {
            this.props().name(name);
            return this;
        }

        public Builder rules(List<? extends FirewallRule> rules) {
            this.props().rules(rules);
            return this;
        }

        public FirewallRuleGroup build() {
            return new FirewallRuleGroup(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private FirewallRuleGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new FirewallRuleGroupProps.Builder();
            }
            return this.props;
        }
    }
}

