/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.IConnectable;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.stepfunctions.IntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig;
import software.amazon.awscdk.services.stepfunctions.TaskStateBase;
import software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification;
import software.amazon.awscdk.services.stepfunctions.tasks.Channel;
import software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig;
import software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig;
import software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateTrainingJobProps;
import software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition;
import software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="monocdk.aws_stepfunctions_tasks.SageMakerCreateTrainingJob")
public class SageMakerCreateTrainingJob
extends TaskStateBase
implements IGrantable,
IConnectable {
    protected SageMakerCreateTrainingJob(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SageMakerCreateTrainingJob(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SageMakerCreateTrainingJob(@NotNull Construct scope, @NotNull String id, @NotNull SageMakerCreateTrainingJobProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addSecurityGroup(@NotNull ISecurityGroup securityGroup) {
        Kernel.call((Object)this, (String)"addSecurityGroup", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(securityGroup, "securityGroup is required")});
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    @NotNull
    public IRole getRole() {
        return (IRole)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @Nullable
    protected TaskMetricsConfig getTaskMetrics() {
        return (TaskMetricsConfig)Kernel.get((Object)this, (String)"taskMetrics", (NativeType)NativeType.forClass(TaskMetricsConfig.class));
    }

    @Override
    @Nullable
    protected List<PolicyStatement> getTaskPolicies() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"taskPolicies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(PolicyStatement.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SageMakerCreateTrainingJob> {
        private final Construct scope;
        private final String id;
        private final SageMakerCreateTrainingJobProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new SageMakerCreateTrainingJobProps.Builder();
        }

        public Builder comment(String comment) {
            this.props.comment(comment);
            return this;
        }

        public Builder heartbeat(Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        public Builder integrationPattern(IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        public Builder resultSelector(Map<String, ? extends Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification) {
            this.props.algorithmSpecification(algorithmSpecification);
            return this;
        }

        public Builder inputDataConfig(List<? extends Channel> inputDataConfig) {
            this.props.inputDataConfig(inputDataConfig);
            return this;
        }

        public Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.props.outputDataConfig(outputDataConfig);
            return this;
        }

        public Builder trainingJobName(String trainingJobName) {
            this.props.trainingJobName(trainingJobName);
            return this;
        }

        public Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.props.enableNetworkIsolation(enableNetworkIsolation);
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder hyperparameters(Map<String, ? extends Object> hyperparameters) {
            this.props.hyperparameters(hyperparameters);
            return this;
        }

        public Builder resourceConfig(ResourceConfig resourceConfig) {
            this.props.resourceConfig(resourceConfig);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.props.stoppingCondition(stoppingCondition);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpcConfig(VpcConfig vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public SageMakerCreateTrainingJob build() {
            return new SageMakerCreateTrainingJob(this.scope, this.id, this.props.build());
        }
    }
}

