/**
 * <h1>Continuous Integration / Continuous Delivery for CDK Applications</h1>
 * <p>
 * This library includes a <em>CodePipeline</em> composite Action for deploying AWS CDK Applications.
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h2>Replacement recommended</h2>
 * <p>
 * This library has been deprecated. We recommend you use the
 * <a href="https://docs.aws.amazon.com/cdk/api/latest/docs/pipelines-readme.html">&#64;aws-cdk/pipelines</a> module instead.
 * <p>
 * <h2>Limitations</h2>
 * <p>
 * The construct library in it's current form has the following limitations:
 * <p>
 * <ol>
 * <li>It can only deploy stacks that are hosted in the same AWS account and region as the <em>CodePipeline</em> is.</li>
 * <li>Stacks that make use of <code>Asset</code>s cannot be deployed successfully.</li>
 * </ol>
 * <p>
 * <h2>Getting Started</h2>
 * <p>
 * In order to add the <code>PipelineDeployStackAction</code> to your <em>CodePipeline</em>, you need to have a <em>CodePipeline</em> artifact that
 * contains the result of invoking <code>cdk synth -o &lt;dir&gt;</code> on your <em>CDK App</em>. You can for example achieve this using a
 * <em>CodeBuild</em> project.
 * <p>
 * The example below defines a <em>CDK App</em> that contains 3 stacks:
 * <p>
 * <ul>
 * <li><code>CodePipelineStack</code> manages the <em>CodePipeline</em> resources, and self-updates before deploying any other stack</li>
 * <li><code>ServiceStackA</code> and <code>ServiceStackB</code> are service infrastructure stacks, and need to be deployed in this order</li>
 * </ul>
 * <p>
 * <blockquote><pre>
 *   ┏━━━━━━━━━━━━━━━━┓  ┏━━━━━━━━━━━━━━━━┓  ┏━━━━━━━━━━━━━━━━━┓  ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
 *   ┃     Source     ┃  ┃     Build      ┃  ┃  Self-Update    ┃  ┃             Deploy              ┃
 *   ┃                ┃  ┃                ┃  ┃                 ┃  ┃                                 ┃
 *   ┃ ┌────────────┐ ┃  ┃ ┌────────────┐ ┃  ┃ ┌─────────────┐ ┃  ┃ ┌─────────────┐ ┌─────────────┐ ┃
 *   ┃ │   GitHub   ┣━╋━━╋━▶ CodeBuild  ┣━╋━━╋━▶Deploy Stack ┣━╋━━╋━▶Deploy Stack ┣━▶Deploy Stack │ ┃
 *   ┃ │            │ ┃  ┃ │            │ ┃  ┃ │PipelineStack│ ┃  ┃ │ServiceStackA│ │ServiceStackB│ ┃
 *   ┃ └────────────┘ ┃  ┃ └────────────┘ ┃  ┃ └─────────────┘ ┃  ┃ └─────────────┘ └─────────────┘ ┃
 *   ┗━━━━━━━━━━━━━━━━┛  ┗━━━━━━━━━━━━━━━━┛  ┗━━━━━━━━━━━━━━━━━┛  ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛
 * </pre></blockquote>
 * <p>
 * <h3><code>index.ts</code></h3>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * 
 * 
 * public class MyServiceStackA extends Stack {
 * }
 * public class MyServiceStackB extends Stack {
 * }
 * 
 * App app = new App();
 * 
 * // We define a stack that contains the CodePipeline
 * Stack pipelineStack = new Stack(app, "PipelineStack");
 * Pipeline pipeline = Pipeline.Builder.create(pipelineStack, "CodePipeline")
 *         // Mutating a CodePipeline can cause the currently propagating state to be
 *         // "lost". Ensure we re-run the latest change through the pipeline after it's
 *         // been mutated so we're sure the latest state is fully deployed through.
 *         .restartExecutionOnUpdate(true)
 *         .build();
 * 
 * // Configure the CodePipeline source - where your CDK App's source code is hosted
 * Artifact sourceOutput = new Artifact();
 * GitHubSourceAction source = GitHubSourceAction.Builder.create()
 *         .actionName("GitHub")
 *         .output(sourceOutput)
 *         .owner("myName")
 *         .repo("myRepo")
 *         .oauthToken(SecretValue.unsafePlainText("secret"))
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("source")
 *         .actions(List.of(source))
 *         .build());
 * 
 * PipelineProject project = PipelineProject.Builder.create(pipelineStack, "CodeBuild").build();
 * Artifact synthesizedApp = new Artifact();
 * CodeBuildAction buildAction = CodeBuildAction.Builder.create()
 *         .actionName("CodeBuild")
 *         .project(project)
 *         .input(sourceOutput)
 *         .outputs(List.of(synthesizedApp))
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("build")
 *         .actions(List.of(buildAction))
 *         .build());
 * 
 * // Optionally, self-update the pipeline stack
 * IStage selfUpdateStage = pipeline.addStage(StageOptions.builder().stageName("SelfUpdate").build());
 * selfUpdateStage.addAction(PipelineDeployStackAction.Builder.create()
 *         .stack(pipelineStack)
 *         .input(synthesizedApp)
 *         .adminPermissions(true)
 *         .build());
 * 
 * // Now add our service stacks
 * IStage deployStage = pipeline.addStage(StageOptions.builder().stageName("Deploy").build());
 * MyServiceStackA serviceStackA = MyServiceStackA.Builder.create(app, "ServiceStackA").build();
 * // Add actions to deploy the stacks in the deploy stage:
 * PipelineDeployStackAction deployServiceAAction = PipelineDeployStackAction.Builder.create()
 *         .stack(serviceStackA)
 *         .input(synthesizedApp)
 *         // See the note below for details about this option.
 *         .adminPermissions(false)
 *         .build();
 * deployStage.addAction(deployServiceAAction);
 * // Add the necessary permissions for you service deploy action. This role is
 * // is passed to CloudFormation and needs the permissions necessary to deploy
 * // stack. Alternatively you can enable [Administrator](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_job-functions.html#jf_administrator) permissions above,
 * // users should understand the privileged nature of this role.
 * String myResourceArn = "arn:partition:service:region:account-id:resource-id";
 * deployServiceAAction.addToDeploymentRolePolicy(PolicyStatement.Builder.create()
 *         .actions(List.of("service:SomeAction"))
 *         .resources(List.of(myResourceArn))
 *         .build());
 * 
 * MyServiceStackB serviceStackB = MyServiceStackB.Builder.create(app, "ServiceStackB").build();
 * deployStage.addAction(PipelineDeployStackAction.Builder.create()
 *         .stack(serviceStackB)
 *         .input(synthesizedApp)
 *         .createChangeSetRunOrder(998)
 *         .adminPermissions(true)
 *         .build());
 * </pre></blockquote>
 * <p>
 * <h3><code>buildspec.yml</code></h3>
 * <p>
 * The repository can contain a file at the root level named <code>buildspec.yml</code>, or
 * you can in-line the buildspec. Note that <code>buildspec.yaml</code> is not compatible.
 * <p>
 * For example, a <em>TypeScript</em> or <em>Javascript</em> CDK App can add the following <code>buildspec.yml</code>
 * at the root of the repository:
 * <p>
 * <blockquote><pre>
 * version: 0.2
 * phases:
 *   install:
 *     commands:
 *       # Installs the npm dependencies as defined by the `package.json` file
 *       # present in the root directory of the package
 *       # (`cdk init app --language=typescript` would have created one for you)
 *       - npm install
 *   build:
 *     commands:
 *       # Builds the CDK App so it can be synthesized
 *       - npm run build
 *       # Synthesizes the CDK App and puts the resulting artifacts into `dist`
 *       - npm run cdk synth -- -o dist
 * artifacts:
 *   # The output artifact is all the files in the `dist` directory
 *   base-directory: dist
 *   files: '**&#47;*'
 * </pre></blockquote>
 * <p>
 * The <code>PipelineDeployStackAction</code> expects it's <code>input</code> to contain the result of
 * synthesizing a CDK App using the <code>cdk synth -o &lt;directory&gt;</code>.
 */
package software.amazon.awscdk.appdelivery;
