package software.amazon.awscdk.cloudformation.include;

/**
 * (experimental) Construct to import an existing CloudFormation template file into a CDK application.
 * <p>
 * All resources defined in the template file can be retrieved by calling the {&#64;link getResource} method.
 * Any modifications made on the returned resource objects will be reflected in the resulting CDK template.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnInclude cfnTemplate = CfnInclude.Builder.create(this, "Template")
 *         .templateFile("my-template.json")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:12.772Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.cloudformation_include.CfnInclude")
public class CfnInclude extends software.amazon.awscdk.core.CfnElement {

    protected CfnInclude(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInclude(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CfnInclude(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudformation.include.CfnIncludeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Returns the CfnCondition object from the 'Conditions' section of the CloudFormation template with the given name.
     * <p>
     * Any modifications performed on that object will be reflected in the resulting CDK template.
     * <p>
     * If a Condition with the given name is not present in the template,
     * throws an exception.
     * <p>
     * @param conditionName the name of the Condition in the CloudFormation template file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnCondition getCondition(final @org.jetbrains.annotations.NotNull java.lang.String conditionName) {
        return software.amazon.jsii.Kernel.call(this, "getCondition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnCondition.class), new Object[] { java.util.Objects.requireNonNull(conditionName, "conditionName is required") });
    }

    /**
     * (experimental) Returns the CfnHook object from the 'Hooks' section of the included CloudFormation template with the given logical ID.
     * <p>
     * Any modifications performed on the returned object will be reflected in the resulting CDK template.
     * <p>
     * If a Hook with the given logical ID is not present in the template,
     * an exception will be thrown.
     * <p>
     * @param hookLogicalId the logical ID of the Hook in the included CloudFormation template's 'Hooks' section. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnHook getHook(final @org.jetbrains.annotations.NotNull java.lang.String hookLogicalId) {
        return software.amazon.jsii.Kernel.call(this, "getHook", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnHook.class), new Object[] { java.util.Objects.requireNonNull(hookLogicalId, "hookLogicalId is required") });
    }

    /**
     * (experimental) Returns the CfnMapping object from the 'Mappings' section of the included template.
     * <p>
     * Any modifications performed on that object will be reflected in the resulting CDK template.
     * <p>
     * If a Mapping with the given name is not present in the template,
     * an exception will be thrown.
     * <p>
     * @param mappingName the name of the Mapping in the template to retrieve. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnMapping getMapping(final @org.jetbrains.annotations.NotNull java.lang.String mappingName) {
        return software.amazon.jsii.Kernel.call(this, "getMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnMapping.class), new Object[] { java.util.Objects.requireNonNull(mappingName, "mappingName is required") });
    }

    /**
     * (experimental) Returns a loaded NestedStack with name logicalId.
     * <p>
     * For a nested stack to be returned by this method,
     * it must be specified either in the {&#64;link CfnIncludeProps.loadNestedStacks} property,
     * or through the {&#64;link loadNestedStack} method.
     * <p>
     * @param logicalId the ID of the stack to retrieve, as it appears in the template. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudformation.include.IncludedNestedStack getNestedStack(final @org.jetbrains.annotations.NotNull java.lang.String logicalId) {
        return software.amazon.jsii.Kernel.call(this, "getNestedStack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudformation.include.IncludedNestedStack.class), new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required") });
    }

    /**
     * (experimental) Returns the CfnOutput object from the 'Outputs' section of the included template.
     * <p>
     * Any modifications performed on that object will be reflected in the resulting CDK template.
     * <p>
     * If an Output with the given name is not present in the template,
     * throws an exception.
     * <p>
     * @param logicalId the name of the output to retrieve. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnOutput getOutput(final @org.jetbrains.annotations.NotNull java.lang.String logicalId) {
        return software.amazon.jsii.Kernel.call(this, "getOutput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnOutput.class), new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required") });
    }

    /**
     * (experimental) Returns the CfnParameter object from the 'Parameters' section of the included template.
     * <p>
     * Any modifications performed on that object will be reflected in the resulting CDK template.
     * <p>
     * If a Parameter with the given name is not present in the template,
     * throws an exception.
     * <p>
     * @param parameterName the name of the parameter to retrieve. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnParameter getParameter(final @org.jetbrains.annotations.NotNull java.lang.String parameterName) {
        return software.amazon.jsii.Kernel.call(this, "getParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnParameter.class), new Object[] { java.util.Objects.requireNonNull(parameterName, "parameterName is required") });
    }

    /**
     * (experimental) Returns the low-level CfnResource from the template with the given logical ID.
     * <p>
     * Any modifications performed on that resource will be reflected in the resulting CDK template.
     * <p>
     * The returned object will be of the proper underlying class;
     * you can always cast it to the correct type in your code:
     * <p>
     * <blockquote><pre>
     *  // assume the template contains an AWS::S3::Bucket with logical ID 'Bucket'
     *  const cfnBucket = cfnTemplate.getResource('Bucket') as s3.CfnBucket;
     *  // cfnBucket is of type s3.CfnBucket
     * </pre></blockquote>
     * <p>
     * If the template does not contain a resource with the given logical ID,
     * an exception will be thrown.
     * <p>
     * @param logicalId the logical ID of the resource in the CloudFormation template file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnResource getResource(final @org.jetbrains.annotations.NotNull java.lang.String logicalId) {
        return software.amazon.jsii.Kernel.call(this, "getResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnResource.class), new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required") });
    }

    /**
     * (experimental) Returns the CfnRule object from the 'Rules' section of the CloudFormation template with the given name.
     * <p>
     * Any modifications performed on that object will be reflected in the resulting CDK template.
     * <p>
     * If a Rule with the given name is not present in the template,
     * an exception will be thrown.
     * <p>
     * @param ruleName the name of the Rule in the CloudFormation template. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnRule getRule(final @org.jetbrains.annotations.NotNull java.lang.String ruleName) {
        return software.amazon.jsii.Kernel.call(this, "getRule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnRule.class), new Object[] { java.util.Objects.requireNonNull(ruleName, "ruleName is required") });
    }

    /**
     * (experimental) Includes a template for a child stack inside of this parent template.
     * <p>
     * A child with this logical ID must exist in the template,
     * and be of type AWS::CloudFormation::Stack.
     * This is equivalent to specifying the value in the {&#64;link CfnIncludeProps.loadNestedStacks}
     * property on object construction.
     * <p>
     * @return the same {@link IncludedNestedStack} object that {@link getNestedStack} returns for this logical ID
     * @param logicalId the ID of the stack to retrieve, as it appears in the template. This parameter is required.
     * @param nestedStackProps the properties of the included child Stack. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudformation.include.IncludedNestedStack loadNestedStack(final @org.jetbrains.annotations.NotNull java.lang.String logicalId, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudformation.include.CfnIncludeProps nestedStackProps) {
        return software.amazon.jsii.Kernel.call(this, "loadNestedStack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudformation.include.IncludedNestedStack.class), new Object[] { java.util.Objects.requireNonNull(logicalId, "logicalId is required"), java.util.Objects.requireNonNull(nestedStackProps, "nestedStackProps is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.cloudformation.include.CfnInclude}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.cloudformation.include.CfnInclude> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.cloudformation.include.CfnIncludeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.cloudformation.include.CfnIncludeProps.Builder();
        }

        /**
         * (experimental) Path to the template file.
         * <p>
         * Both JSON and YAML template formats are supported.
         * <p>
         * @return {@code this}
         * @param templateFile Path to the template file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder templateFile(final java.lang.String templateFile) {
            this.props.templateFile(templateFile);
            return this;
        }

        /**
         * (experimental) Specifies the template files that define nested stacks that should be included.
         * <p>
         * If your template specifies a stack that isn't included here, it won't be created as a NestedStack
         * resource, and it won't be accessible from the {&#64;link CfnInclude.getNestedStack} method
         * (but will still be accessible from the {&#64;link CfnInclude.getResource} method).
         * <p>
         * If you include a stack here with an ID that isn't in the template,
         * or is in the template but is not a nested stack,
         * template creation will fail and an error will be thrown.
         * <p>
         * Default: - no nested stacks will be included
         * <p>
         * @return {@code this}
         * @param loadNestedStacks Specifies the template files that define nested stacks that should be included. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder loadNestedStacks(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.cloudformation.include.CfnIncludeProps> loadNestedStacks) {
            this.props.loadNestedStacks(loadNestedStacks);
            return this;
        }

        /**
         * (experimental) Specifies parameters to be replaced by the values in this mapping.
         * <p>
         * Any parameters in the template that aren't specified here will be left unmodified.
         * If you include a parameter here with an ID that isn't in the template,
         * template creation will fail and an error will be thrown.
         * <p>
         * Default: - no parameters will be replaced
         * <p>
         * @return {@code this}
         * @param parameters Specifies parameters to be replaced by the values in this mapping. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * (experimental) Whether the resources should have the same logical IDs in the resulting CDK template as they did in the original CloudFormation template file.
         * <p>
         * If you're vending a Construct using an existing CloudFormation template,
         * make sure to pass this as <code>false</code>.
         * <p>
         * <strong>Note</strong>: regardless of whether this option is true or false,
         * the {&#64;link CfnInclude.getResource} and related methods always uses the original logical ID of the resource/element,
         * as specified in the template file.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param preserveLogicalIds Whether the resources should have the same logical IDs in the resulting CDK template as they did in the original CloudFormation template file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preserveLogicalIds(final java.lang.Boolean preserveLogicalIds) {
            this.props.preserveLogicalIds(preserveLogicalIds);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.cloudformation.include.CfnInclude}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.cloudformation.include.CfnInclude build() {
            return new software.amazon.awscdk.cloudformation.include.CfnInclude(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
