package software.amazon.awscdk.core;

/**
 * (experimental) Initialization props for apps.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * Object context;
 * AppProps appProps = AppProps.builder()
 *         .analyticsReporting(false)
 *         .autoSynth(false)
 *         .context(Map.of(
 *                 "contextKey", context))
 *         .outdir("outdir")
 *         .runtimeInfo(false)
 *         .stackTraces(false)
 *         .treeMetadata(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.215Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.AppProps")
@software.amazon.jsii.Jsii.Proxy(AppProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AppProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Include runtime versioning information in the Stacks of this app.
     * <p>
     * Default: Value of 'aws:cdk:version-reporting' context key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAnalyticsReporting() {
        return null;
    }

    /**
     * (experimental) Automatically call `synth()` before the program exits.
     * <p>
     * If you set this, you don't have to call <code>synth()</code> explicitly. Note that
     * this feature is only available for certain programming languages, and
     * calling <code>synth()</code> is still recommended.
     * <p>
     * Default: true if running via CDK CLI (`CDK_OUTDIR` is set), `false`
     * otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAutoSynth() {
        return null;
    }

    /**
     * (experimental) Additional context values for the application.
     * <p>
     * Context set by the CLI or the <code>context</code> key in <code>cdk.json</code> has precedence.
     * <p>
     * Context can be read from any construct using <code>node.getContext(key)</code>.
     * <p>
     * Default: - no additional context
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getContext() {
        return null;
    }

    /**
     * (experimental) The output directory into which to emit synthesized artifacts.
     * <p>
     * You should never need to set this value. By default, the value you pass to
     * the CLI's <code>--output</code> flag will be used, and if you change it to a different
     * directory the CLI will fail to pick up the generated Cloud Assembly.
     * <p>
     * This property is intended for internal and testing use.
     * <p>
     * Default: - If this value is _not_ set, considers the environment variable `CDK_OUTDIR`.
     *   If `CDK_OUTDIR` is not defined, uses a temp directory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutdir() {
        return null;
    }

    /**
     * (deprecated) Include runtime versioning information in the Stacks of this app.
     * <p>
     * Default: Value of 'aws:cdk:version-reporting' context key
     * <p>
     * @deprecated use `versionReporting` instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRuntimeInfo() {
        return null;
    }

    /**
     * (experimental) Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.
     * <p>
     * Default: true stack traces are included unless `aws:cdk:disable-stack-trace` is set in the context.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStackTraces() {
        return null;
    }

    /**
     * (experimental) Include construct tree metadata as part of the Cloud Assembly.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTreeMetadata() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AppProps> {
        java.lang.Boolean analyticsReporting;
        java.lang.Boolean autoSynth;
        java.util.Map<java.lang.String, java.lang.Object> context;
        java.lang.String outdir;
        java.lang.Boolean runtimeInfo;
        java.lang.Boolean stackTraces;
        java.lang.Boolean treeMetadata;

        /**
         * Sets the value of {@link AppProps#getAnalyticsReporting}
         * @param analyticsReporting Include runtime versioning information in the Stacks of this app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder analyticsReporting(java.lang.Boolean analyticsReporting) {
            this.analyticsReporting = analyticsReporting;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getAutoSynth}
         * @param autoSynth Automatically call `synth()` before the program exits.
         *                  If you set this, you don't have to call <code>synth()</code> explicitly. Note that
         *                  this feature is only available for certain programming languages, and
         *                  calling <code>synth()</code> is still recommended.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoSynth(java.lang.Boolean autoSynth) {
            this.autoSynth = autoSynth;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getContext}
         * @param context Additional context values for the application.
         *                Context set by the CLI or the <code>context</code> key in <code>cdk.json</code> has precedence.
         *                <p>
         *                Context can be read from any construct using <code>node.getContext(key)</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder context(java.util.Map<java.lang.String, ? extends java.lang.Object> context) {
            this.context = (java.util.Map<java.lang.String, java.lang.Object>)context;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getOutdir}
         * @param outdir The output directory into which to emit synthesized artifacts.
         *               You should never need to set this value. By default, the value you pass to
         *               the CLI's <code>--output</code> flag will be used, and if you change it to a different
         *               directory the CLI will fail to pick up the generated Cloud Assembly.
         *               <p>
         *               This property is intended for internal and testing use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outdir(java.lang.String outdir) {
            this.outdir = outdir;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getRuntimeInfo}
         * @param runtimeInfo Include runtime versioning information in the Stacks of this app.
         * @return {@code this}
         * @deprecated use `versionReporting` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder runtimeInfo(java.lang.Boolean runtimeInfo) {
            this.runtimeInfo = runtimeInfo;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getStackTraces}
         * @param stackTraces Include construct creation stack trace in the `aws:cdk:trace` metadata key of all constructs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stackTraces(java.lang.Boolean stackTraces) {
            this.stackTraces = stackTraces;
            return this;
        }

        /**
         * Sets the value of {@link AppProps#getTreeMetadata}
         * @param treeMetadata Include construct tree metadata as part of the Cloud Assembly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder treeMetadata(java.lang.Boolean treeMetadata) {
            this.treeMetadata = treeMetadata;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AppProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AppProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppProps {
        private final java.lang.Boolean analyticsReporting;
        private final java.lang.Boolean autoSynth;
        private final java.util.Map<java.lang.String, java.lang.Object> context;
        private final java.lang.String outdir;
        private final java.lang.Boolean runtimeInfo;
        private final java.lang.Boolean stackTraces;
        private final java.lang.Boolean treeMetadata;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.analyticsReporting = software.amazon.jsii.Kernel.get(this, "analyticsReporting", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.autoSynth = software.amazon.jsii.Kernel.get(this, "autoSynth", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.context = software.amazon.jsii.Kernel.get(this, "context", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.outdir = software.amazon.jsii.Kernel.get(this, "outdir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runtimeInfo = software.amazon.jsii.Kernel.get(this, "runtimeInfo", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.stackTraces = software.amazon.jsii.Kernel.get(this, "stackTraces", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.treeMetadata = software.amazon.jsii.Kernel.get(this, "treeMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.analyticsReporting = builder.analyticsReporting;
            this.autoSynth = builder.autoSynth;
            this.context = (java.util.Map<java.lang.String, java.lang.Object>)builder.context;
            this.outdir = builder.outdir;
            this.runtimeInfo = builder.runtimeInfo;
            this.stackTraces = builder.stackTraces;
            this.treeMetadata = builder.treeMetadata;
        }

        @Override
        public final java.lang.Boolean getAnalyticsReporting() {
            return this.analyticsReporting;
        }

        @Override
        public final java.lang.Boolean getAutoSynth() {
            return this.autoSynth;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getContext() {
            return this.context;
        }

        @Override
        public final java.lang.String getOutdir() {
            return this.outdir;
        }

        @Override
        public final java.lang.Boolean getRuntimeInfo() {
            return this.runtimeInfo;
        }

        @Override
        public final java.lang.Boolean getStackTraces() {
            return this.stackTraces;
        }

        @Override
        public final java.lang.Boolean getTreeMetadata() {
            return this.treeMetadata;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAnalyticsReporting() != null) {
                data.set("analyticsReporting", om.valueToTree(this.getAnalyticsReporting()));
            }
            if (this.getAutoSynth() != null) {
                data.set("autoSynth", om.valueToTree(this.getAutoSynth()));
            }
            if (this.getContext() != null) {
                data.set("context", om.valueToTree(this.getContext()));
            }
            if (this.getOutdir() != null) {
                data.set("outdir", om.valueToTree(this.getOutdir()));
            }
            if (this.getRuntimeInfo() != null) {
                data.set("runtimeInfo", om.valueToTree(this.getRuntimeInfo()));
            }
            if (this.getStackTraces() != null) {
                data.set("stackTraces", om.valueToTree(this.getStackTraces()));
            }
            if (this.getTreeMetadata() != null) {
                data.set("treeMetadata", om.valueToTree(this.getTreeMetadata()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.AppProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppProps.Jsii$Proxy that = (AppProps.Jsii$Proxy) o;

            if (this.analyticsReporting != null ? !this.analyticsReporting.equals(that.analyticsReporting) : that.analyticsReporting != null) return false;
            if (this.autoSynth != null ? !this.autoSynth.equals(that.autoSynth) : that.autoSynth != null) return false;
            if (this.context != null ? !this.context.equals(that.context) : that.context != null) return false;
            if (this.outdir != null ? !this.outdir.equals(that.outdir) : that.outdir != null) return false;
            if (this.runtimeInfo != null ? !this.runtimeInfo.equals(that.runtimeInfo) : that.runtimeInfo != null) return false;
            if (this.stackTraces != null ? !this.stackTraces.equals(that.stackTraces) : that.stackTraces != null) return false;
            return this.treeMetadata != null ? this.treeMetadata.equals(that.treeMetadata) : that.treeMetadata == null;
        }

        @Override
        public final int hashCode() {
            int result = this.analyticsReporting != null ? this.analyticsReporting.hashCode() : 0;
            result = 31 * result + (this.autoSynth != null ? this.autoSynth.hashCode() : 0);
            result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
            result = 31 * result + (this.outdir != null ? this.outdir.hashCode() : 0);
            result = 31 * result + (this.runtimeInfo != null ? this.runtimeInfo.hashCode() : 0);
            result = 31 * result + (this.stackTraces != null ? this.stackTraces.hashCode() : 0);
            result = 31 * result + (this.treeMetadata != null ? this.treeMetadata.hashCode() : 0);
            return result;
        }
    }
}
