package software.amazon.awscdk.core;

/**
 * (experimental) An enum representing the various ARN formats that different services use.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.218Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.ArnFormat")
public enum ArnFormat {
    /**
     * (experimental) This represents a format where there is no 'resourceName' part.
     * <p>
     * This format is used for S3 resources,
     * like 'arn:aws:s3:::bucket'.
     * Everything after the last colon is considered the 'resource',
     * even if it contains slashes,
     * like in 'arn:aws:s3:::bucket/object.zip'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NO_RESOURCE_NAME,
    /**
     * (experimental) This represents a format where the 'resource' and 'resourceName' parts are separated with a colon.
     * <p>
     * Like in: 'arn:aws:service:region:account:resource:resourceName'.
     * Everything after the last colon is considered the 'resourceName',
     * even if it contains slashes,
     * like in 'arn:aws:apigateway:region:account:resource:/test/mydemoresource/*'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COLON_RESOURCE_NAME,
    /**
     * (experimental) This represents a format where the 'resource' and 'resourceName' parts are separated with a slash.
     * <p>
     * Like in: 'arn:aws:service:region:account:resource/resourceName'.
     * Everything after the separating slash is considered the 'resourceName',
     * even if it contains colons,
     * like in 'arn:aws:cognito-sync:region:account:identitypool/us-east-1:1a1a1a1a-ffff-1111-9999-12345678:bla'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SLASH_RESOURCE_NAME,
    /**
     * (experimental) This represents a format where the 'resource' and 'resourceName' parts are seperated with a slash, but there is also an additional slash after the colon separating 'account' from 'resource'.
     * <p>
     * Like in: 'arn:aws:service:region:account:/resource/resourceName'.
     * Note that the leading slash is <em>not</em> included in the parsed 'resource' part.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SLASH_RESOURCE_SLASH_RESOURCE_NAME,
}
