package software.amazon.awscdk.core;

/**
 * (experimental) The type of output that a bundling operation is producing.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Asset asset = Asset.Builder.create(this, "BundledAsset")
 *         .path("/path/to/asset")
 *         .bundling(BundlingOptions.builder()
 *                 .image(DockerImage.fromRegistry("alpine"))
 *                 .command(List.of("command-that-produces-an-archive.sh"))
 *                 .outputType(BundlingOutput.NOT_ARCHIVED)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.234Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.BundlingOutput")
public enum BundlingOutput {
    /**
     * (experimental) The bundling output directory includes a single .zip or .jar file which will be used as the final bundle. If the output directory does not include exactly a single archive, bundling will fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ARCHIVED,
    /**
     * (experimental) The bundling output directory contains one or more files which will be archived and uploaded as a .zip file to S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NOT_ARCHIVED,
    /**
     * (experimental) If the bundling output directory contains a single archive file (zip or jar) it will be used as the bundle output as-is.
     * <p>
     * Otherwise all the files in the bundling output directory will be zipped.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    AUTO_DISCOVER,
}
