package software.amazon.awscdk.core;

/**
 * (experimental) References a dynamically retrieved value.
 * <p>
 * This is a Construct so that subclasses will (eventually) be able to attach
 * metadata to themselves without having to change call signatures.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * CfnDynamicReference cfnDynamicReference = new CfnDynamicReference(CfnDynamicReferenceService.SSM, "key");
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.271Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.CfnDynamicReference")
public class CfnDynamicReference extends software.amazon.awscdk.core.Intrinsic {

    protected CfnDynamicReference(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDynamicReference(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param service This parameter is required.
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CfnDynamicReference(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnDynamicReferenceService service, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(service, "service is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }
}
