package software.amazon.awscdk.core;

/**
 * (experimental) A CloudFormation parameter.
 * <p>
 * Use the optional Parameters section to customize your templates.
 * Parameters enable you to input custom values to your template each time you create or
 * update a stack.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic myTopic = new Topic(this, "MyTopic");
 * CfnParameter url = new CfnParameter(this, "url-param");
 * myTopic.addSubscription(new UrlSubscription(url.getValueAsString()));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.309Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.CfnParameter")
public class CfnParameter extends software.amazon.awscdk.core.CfnElement {

    protected CfnParameter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnParameter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Creates a parameter construct.
     * <p>
     * Note that the name (logical ID) of the parameter will derive from it's <code>coname</code> and location
     * within the stack. Therefore, it is recommended that parameters are defined at the stack level.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id This parameter is required.
     * @param props The parameter properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CfnParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnParameterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * (experimental) Creates a parameter construct.
     * <p>
     * Note that the name (logical ID) of the parameter will derive from it's <code>coname</code> and location
     * within the stack. Therefore, it is recommended that parameters are defined at the stack level.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CfnParameter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param _context This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Object resolve(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolveContext _context) {
        return software.amazon.jsii.Kernel.call(this, "resolve", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { java.util.Objects.requireNonNull(_context, "_context is required") });
    }

    /**
     * (experimental) The parameter value as a Token.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IResolvable.class));
    }

    /**
     * (experimental) The parameter value, if it represents a string list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValueAsList() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "valueAsList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * (experimental) The parameter value, if it represents a number.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number getValueAsNumber() {
        return software.amazon.jsii.Kernel.get(this, "valueAsNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) The parameter value, if it represents a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getValueAsString() {
        return software.amazon.jsii.Kernel.get(this, "valueAsString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A value of the appropriate type for the template to use if no value is specified when a stack is created.
     * <p>
     * If you define constraints for the parameter, you must specify
     * a value that adheres to those constraints.
     * <p>
     * Default: - No default value for parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefaultValue() {
        return software.amazon.jsii.Kernel.get(this, "default", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * (experimental) A value of the appropriate type for the template to use if no value is specified when a stack is created.
     * <p>
     * If you define constraints for the parameter, you must specify
     * a value that adheres to those constraints.
     * <p>
     * Default: - No default value for parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setDefaultValue(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "default", java.util.Objects.requireNonNull(value, "default is required"));
    }

    /**
     * (experimental) Indicates if this parameter is configured with "NoEcho" enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getNoEcho() {
        return software.amazon.jsii.Kernel.get(this, "noEcho", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) Indicates if this parameter is configured with "NoEcho" enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setNoEcho(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "noEcho", java.util.Objects.requireNonNull(value, "noEcho is required"));
    }

    /**
     * (experimental) The data type for the parameter (DataType).
     * <p>
     * Default: String
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The data type for the parameter (DataType).
     * <p>
     * Default: String
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * (experimental) A regular expression that represents the patterns to allow for String types.
     * <p>
     * Default: - No constraints on patterns allowed for parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getAllowedPattern() {
        return software.amazon.jsii.Kernel.get(this, "allowedPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A regular expression that represents the patterns to allow for String types.
     * <p>
     * Default: - No constraints on patterns allowed for parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setAllowedPattern(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "allowedPattern", value);
    }

    /**
     * (experimental) An array containing the list of values allowed for the parameter.
     * <p>
     * Default: - No constraints on values allowed for parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedValues() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "allowedValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (experimental) An array containing the list of values allowed for the parameter.
     * <p>
     * Default: - No constraints on values allowed for parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setAllowedValues(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "allowedValues", value);
    }

    /**
     * (experimental) A string that explains a constraint when the constraint is violated.
     * <p>
     * For example, without a constraint description, a parameter that has an allowed
     * pattern of [A-Za-z0-9]+ displays the following error message when the user specifies
     * an invalid value:
     * <p>
     * Default: - No description with customized error message when user specifies invalid values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getConstraintDescription() {
        return software.amazon.jsii.Kernel.get(this, "constraintDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A string that explains a constraint when the constraint is violated.
     * <p>
     * For example, without a constraint description, a parameter that has an allowed
     * pattern of [A-Za-z0-9]+ displays the following error message when the user specifies
     * an invalid value:
     * <p>
     * Default: - No description with customized error message when user specifies invalid values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setConstraintDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "constraintDescription", value);
    }

    /**
     * (experimental) A string of up to 4000 characters that describes the parameter.
     * <p>
     * Default: - No description for the parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A string of up to 4000 characters that describes the parameter.
     * <p>
     * Default: - No description for the parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * (experimental) An integer value that determines the largest number of characters you want to allow for String types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxLength() {
        return software.amazon.jsii.Kernel.get(this, "maxLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) An integer value that determines the largest number of characters you want to allow for String types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setMaxLength(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxLength", value);
    }

    /**
     * (experimental) A numeric value that determines the largest numeric value you want to allow for Number types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxValue() {
        return software.amazon.jsii.Kernel.get(this, "maxValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) A numeric value that determines the largest numeric value you want to allow for Number types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setMaxValue(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxValue", value);
    }

    /**
     * (experimental) An integer value that determines the smallest number of characters you want to allow for String types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinLength() {
        return software.amazon.jsii.Kernel.get(this, "minLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) An integer value that determines the smallest number of characters you want to allow for String types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setMinLength(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minLength", value);
    }

    /**
     * (experimental) A numeric value that determines the smallest numeric value you want to allow for Number types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinValue() {
        return software.amazon.jsii.Kernel.get(this, "minValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) A numeric value that determines the smallest numeric value you want to allow for Number types.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setMinValue(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minValue", value);
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.core.CfnParameter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.CfnParameter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope The parent construct. This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.core.CfnParameterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) A regular expression that represents the patterns to allow for String types.
         * <p>
         * Default: - No constraints on patterns allowed for parameter.
         * <p>
         * @return {@code this}
         * @param allowedPattern A regular expression that represents the patterns to allow for String types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowedPattern(final java.lang.String allowedPattern) {
            this.props().allowedPattern(allowedPattern);
            return this;
        }

        /**
         * (experimental) An array containing the list of values allowed for the parameter.
         * <p>
         * Default: - No constraints on values allowed for parameter.
         * <p>
         * @return {@code this}
         * @param allowedValues An array containing the list of values allowed for the parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowedValues(final java.util.List<java.lang.String> allowedValues) {
            this.props().allowedValues(allowedValues);
            return this;
        }

        /**
         * (experimental) A string that explains a constraint when the constraint is violated.
         * <p>
         * For example, without a constraint description, a parameter that has an allowed
         * pattern of [A-Za-z0-9]+ displays the following error message when the user specifies
         * an invalid value:
         * <p>
         * Default: - No description with customized error message when user specifies invalid values.
         * <p>
         * @return {@code this}
         * @param constraintDescription A string that explains a constraint when the constraint is violated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder constraintDescription(final java.lang.String constraintDescription) {
            this.props().constraintDescription(constraintDescription);
            return this;
        }

        /**
         * (experimental) A value of the appropriate type for the template to use if no value is specified when a stack is created.
         * <p>
         * If you define constraints for the parameter, you must specify
         * a value that adheres to those constraints.
         * <p>
         * Default: - No default value for parameter.
         * <p>
         * @return {@code this}
         * @param defaultValue A value of the appropriate type for the template to use if no value is specified when a stack is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultValue(final java.lang.Object defaultValue) {
            this.props().defaultValue(defaultValue);
            return this;
        }

        /**
         * (experimental) A string of up to 4000 characters that describes the parameter.
         * <p>
         * Default: - No description for the parameter.
         * <p>
         * @return {@code this}
         * @param description A string of up to 4000 characters that describes the parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * (experimental) An integer value that determines the largest number of characters you want to allow for String types.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param maxLength An integer value that determines the largest number of characters you want to allow for String types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxLength(final java.lang.Number maxLength) {
            this.props().maxLength(maxLength);
            return this;
        }

        /**
         * (experimental) A numeric value that determines the largest numeric value you want to allow for Number types.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param maxValue A numeric value that determines the largest numeric value you want to allow for Number types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxValue(final java.lang.Number maxValue) {
            this.props().maxValue(maxValue);
            return this;
        }

        /**
         * (experimental) An integer value that determines the smallest number of characters you want to allow for String types.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param minLength An integer value that determines the smallest number of characters you want to allow for String types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minLength(final java.lang.Number minLength) {
            this.props().minLength(minLength);
            return this;
        }

        /**
         * (experimental) A numeric value that determines the smallest numeric value you want to allow for Number types.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param minValue A numeric value that determines the smallest numeric value you want to allow for Number types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minValue(final java.lang.Number minValue) {
            this.props().minValue(minValue);
            return this;
        }

        /**
         * (experimental) Whether to mask the parameter value when anyone makes a call that describes the stack.
         * <p>
         * If you set the value to <code>true</code>, the parameter value is masked with asterisks (<code>*****</code>).
         * <p>
         * Default: - Parameter values are not masked.
         * <p>
         * @return {@code this}
         * @param noEcho Whether to mask the parameter value when anyone makes a call that describes the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder noEcho(final java.lang.Boolean noEcho) {
            this.props().noEcho(noEcho);
            return this;
        }

        /**
         * (experimental) The data type for the parameter (DataType).
         * <p>
         * Default: String
         * <p>
         * @return {@code this}
         * @param type The data type for the parameter (DataType). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(final java.lang.String type) {
            this.props().type(type);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.CfnParameter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.core.CfnParameter build() {
            return new software.amazon.awscdk.core.CfnParameter(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.CfnParameterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.CfnParameterProps.Builder();
            }
            return this.props;
        }
    }
}
