package software.amazon.awscdk.core;

/**
 * A CloudFormation `AWS::CloudFormation::PublicTypeVersion`.
 * <p>
 * Tests and publishes a registered extension as a public, third-party extension.
 * <p>
 * CloudFormation first tests the extension to make sure it meets all necessary requirements for being published in the CloudFormation registry. If it does, CloudFormation then publishes it to the registry as a public third-party extension in this Region. Public extensions are available for use by all CloudFormation users.
 * <p>
 * <ul>
 * <li>For resource types, testing includes passing all contracts tests defined for the type.</li>
 * <li>For modules, testing includes determining if the module's model meets all necessary requirements.</li>
 * </ul>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing">Testing your public extension prior to publishing</a> in the <em>CloudFormation CLI User Guide</em> .
 * <p>
 * If you don't specify a version, CloudFormation uses the default version of the extension in your account and Region for testing.
 * <p>
 * To perform testing, CloudFormation assumes the execution role specified when the type was registered.
 * <p>
 * An extension must have a test status of <code>PASSED</code> before it can be published. For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing extensions to make them available for public use</a> in the <em>CloudFormation CLI User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * CfnPublicTypeVersion cfnPublicTypeVersion = CfnPublicTypeVersion.Builder.create(this, "MyCfnPublicTypeVersion")
 *         .arn("arn")
 *         .logDeliveryBucket("logDeliveryBucket")
 *         .publicVersionNumber("publicVersionNumber")
 *         .type("type")
 *         .typeName("typeName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.312Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.CfnPublicTypeVersion")
public class CfnPublicTypeVersion extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnPublicTypeVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPublicTypeVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.CfnPublicTypeVersion.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudFormation::PublicTypeVersion`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPublicTypeVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.CfnPublicTypeVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::CloudFormation::PublicTypeVersion`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPublicTypeVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Number (ARN) assigned to the public extension upon publication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPublicTypeArn() {
        return software.amazon.jsii.Kernel.get(this, "attrPublicTypeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The publisher ID of the extension publisher.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPublisherId() {
        return software.amazon.jsii.Kernel.get(this, "attrPublisherId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Number (ARN) assigned to this version of the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTypeVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTypeVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Number (ARN) of the extension.
     * <p>
     * Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getArn() {
        return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Number (ARN) of the extension.
     * <p>
     * Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "arn", value);
    }

    /**
     * The S3 bucket to which CloudFormation delivers the contract test execution logs.
     * <p>
     * CloudFormation delivers the logs by the time contract testing has completed and the extension has been assigned a test type status of <code>PASSED</code> or <code>FAILED</code> .
     * <p>
     * The user initiating the stack operation must be able to access items in the specified S3 bucket. Specifically, the user needs the following permissions:
     * <p>
     * <ul>
     * <li>GetObject</li>
     * <li>PutObject</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources, and Condition Keys for Amazon S3</a> in the <em>AWS Identity and Access Management User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogDeliveryBucket() {
        return software.amazon.jsii.Kernel.get(this, "logDeliveryBucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The S3 bucket to which CloudFormation delivers the contract test execution logs.
     * <p>
     * CloudFormation delivers the logs by the time contract testing has completed and the extension has been assigned a test type status of <code>PASSED</code> or <code>FAILED</code> .
     * <p>
     * The user initiating the stack operation must be able to access items in the specified S3 bucket. Specifically, the user needs the following permissions:
     * <p>
     * <ul>
     * <li>GetObject</li>
     * <li>PutObject</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources, and Condition Keys for Amazon S3</a> in the <em>AWS Identity and Access Management User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogDeliveryBucket(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logDeliveryBucket", value);
    }

    /**
     * The version number to assign to this version of the extension.
     * <p>
     * Use the following format, and adhere to semantic versioning when assigning a version number to your extension:
     * <p>
     * <code>MAJOR.MINOR.PATCH</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/https://semver.org/">Semantic Versioning 2.0.0</a> .
     * <p>
     * If you don't specify a version number, CloudFormation increments the version number by one minor version release.
     * <p>
     * You cannot specify a version number the first time you publish a type. AWS CloudFormation automatically sets the first version number to be <code>1.0.0</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPublicVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "publicVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version number to assign to this version of the extension.
     * <p>
     * Use the following format, and adhere to semantic versioning when assigning a version number to your extension:
     * <p>
     * <code>MAJOR.MINOR.PATCH</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/https://semver.org/">Semantic Versioning 2.0.0</a> .
     * <p>
     * If you don't specify a version number, CloudFormation increments the version number by one minor version release.
     * <p>
     * You cannot specify a version number the first time you publish a type. AWS CloudFormation automatically sets the first version number to be <code>1.0.0</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPublicVersionNumber(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "publicVersionNumber", value);
    }

    /**
     * The type of the extension to test.
     * <p>
     * Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the extension to test.
     * <p>
     * Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", value);
    }

    /**
     * The name of the extension to test.
     * <p>
     * Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTypeName() {
        return software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the extension to test.
     * <p>
     * Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTypeName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "typeName", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.CfnPublicTypeVersion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.CfnPublicTypeVersion> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.core.CfnPublicTypeVersionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The Amazon Resource Number (ARN) of the extension.
         * <p>
         * Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
         * <p>
         * @return {@code this}
         * @param arn The Amazon Resource Number (ARN) of the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arn(final java.lang.String arn) {
            this.props().arn(arn);
            return this;
        }

        /**
         * The S3 bucket to which CloudFormation delivers the contract test execution logs.
         * <p>
         * CloudFormation delivers the logs by the time contract testing has completed and the extension has been assigned a test type status of <code>PASSED</code> or <code>FAILED</code> .
         * <p>
         * The user initiating the stack operation must be able to access items in the specified S3 bucket. Specifically, the user needs the following permissions:
         * <p>
         * <ul>
         * <li>GetObject</li>
         * <li>PutObject</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html">Actions, Resources, and Condition Keys for Amazon S3</a> in the <em>AWS Identity and Access Management User Guide</em> .
         * <p>
         * @return {@code this}
         * @param logDeliveryBucket The S3 bucket to which CloudFormation delivers the contract test execution logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDeliveryBucket(final java.lang.String logDeliveryBucket) {
            this.props().logDeliveryBucket(logDeliveryBucket);
            return this;
        }

        /**
         * The version number to assign to this version of the extension.
         * <p>
         * Use the following format, and adhere to semantic versioning when assigning a version number to your extension:
         * <p>
         * <code>MAJOR.MINOR.PATCH</code>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://semver.org/">Semantic Versioning 2.0.0</a> .
         * <p>
         * If you don't specify a version number, CloudFormation increments the version number by one minor version release.
         * <p>
         * You cannot specify a version number the first time you publish a type. AWS CloudFormation automatically sets the first version number to be <code>1.0.0</code> .
         * <p>
         * @return {@code this}
         * @param publicVersionNumber The version number to assign to this version of the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicVersionNumber(final java.lang.String publicVersionNumber) {
            this.props().publicVersionNumber(publicVersionNumber);
            return this;
        }

        /**
         * The type of the extension to test.
         * <p>
         * Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
         * <p>
         * @return {@code this}
         * @param type The type of the extension to test. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props().type(type);
            return this;
        }

        /**
         * The name of the extension to test.
         * <p>
         * Conditional: You must specify <code>Arn</code> , or <code>TypeName</code> and <code>Type</code> .
         * <p>
         * @return {@code this}
         * @param typeName The name of the extension to test. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeName(final java.lang.String typeName) {
            this.props().typeName(typeName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.CfnPublicTypeVersion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.CfnPublicTypeVersion build() {
            return new software.amazon.awscdk.core.CfnPublicTypeVersion(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.core.CfnPublicTypeVersionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.core.CfnPublicTypeVersionProps.Builder();
            }
            return this.props;
        }
    }
}
