package software.amazon.awscdk.core;

/**
 * (experimental) For an Auto Scaling group replacement update, specifies how many instances must signal success for the update to succeed.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * CfnResourceAutoScalingCreationPolicy cfnResourceAutoScalingCreationPolicy = CfnResourceAutoScalingCreationPolicy.builder()
 *         .minSuccessfulInstancesPercent(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.341Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.CfnResourceAutoScalingCreationPolicy")
@software.amazon.jsii.Jsii.Proxy(CfnResourceAutoScalingCreationPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CfnResourceAutoScalingCreationPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Specifies the percentage of instances in an Auto Scaling replacement update that must signal success for the update to succeed.
     * <p>
     * You can specify a value from 0 to 100. AWS CloudFormation rounds to the nearest tenth of a percent.
     * For example, if you update five instances with a minimum successful percentage of 50, three instances must signal success.
     * If an instance doesn't send a signal within the time specified by the Timeout property, AWS CloudFormation assumes that the
     * instance wasn't created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinSuccessfulInstancesPercent() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResourceAutoScalingCreationPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourceAutoScalingCreationPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourceAutoScalingCreationPolicy> {
        java.lang.Number minSuccessfulInstancesPercent;

        /**
         * Sets the value of {@link CfnResourceAutoScalingCreationPolicy#getMinSuccessfulInstancesPercent}
         * @param minSuccessfulInstancesPercent Specifies the percentage of instances in an Auto Scaling replacement update that must signal success for the update to succeed.
         *                                      You can specify a value from 0 to 100. AWS CloudFormation rounds to the nearest tenth of a percent.
         *                                      For example, if you update five instances with a minimum successful percentage of 50, three instances must signal success.
         *                                      If an instance doesn't send a signal within the time specified by the Timeout property, AWS CloudFormation assumes that the
         *                                      instance wasn't created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minSuccessfulInstancesPercent(java.lang.Number minSuccessfulInstancesPercent) {
            this.minSuccessfulInstancesPercent = minSuccessfulInstancesPercent;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceAutoScalingCreationPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CfnResourceAutoScalingCreationPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResourceAutoScalingCreationPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourceAutoScalingCreationPolicy {
        private final java.lang.Number minSuccessfulInstancesPercent;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.minSuccessfulInstancesPercent = software.amazon.jsii.Kernel.get(this, "minSuccessfulInstancesPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.minSuccessfulInstancesPercent = builder.minSuccessfulInstancesPercent;
        }

        @Override
        public final java.lang.Number getMinSuccessfulInstancesPercent() {
            return this.minSuccessfulInstancesPercent;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMinSuccessfulInstancesPercent() != null) {
                data.set("minSuccessfulInstancesPercent", om.valueToTree(this.getMinSuccessfulInstancesPercent()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.CfnResourceAutoScalingCreationPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourceAutoScalingCreationPolicy.Jsii$Proxy that = (CfnResourceAutoScalingCreationPolicy.Jsii$Proxy) o;

            return this.minSuccessfulInstancesPercent != null ? this.minSuccessfulInstancesPercent.equals(that.minSuccessfulInstancesPercent) : that.minSuccessfulInstancesPercent == null;
        }

        @Override
        public final int hashCode() {
            int result = this.minSuccessfulInstancesPercent != null ? this.minSuccessfulInstancesPercent.hashCode() : 0;
            return result;
        }
    }
}
