package software.amazon.awscdk.core;

/**
 * (experimental) A Docker image.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String entry = "/path/to/function";
 * DockerImage image = DockerImage.fromBuild(entry);
 * PythonFunction.Builder.create(this, "function")
 *         .entry(entry)
 *         .runtime(Runtime.PYTHON_3_8)
 *         .bundling(BundlingOptions.builder()
 *                 .buildArgs(Map.of("PIP_INDEX_URL", "https://your.index.url/simple/", "PIP_EXTRA_INDEX_URL", "https://your.extra-index.url/simple/"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.448Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.DockerImage")
public class DockerImage extends software.amazon.awscdk.core.BundlingDockerImage {

    protected DockerImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DockerImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param image This parameter is required.
     * @param _imageHash
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DockerImage(final @org.jetbrains.annotations.NotNull java.lang.String image, final @org.jetbrains.annotations.Nullable java.lang.String _imageHash) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(image, "image is required"), _imageHash });
    }

    /**
     * @param image This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DockerImage(final @org.jetbrains.annotations.NotNull java.lang.String image) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(image, "image is required") });
    }

    /**
     * (experimental) Builds a Docker image.
     * <p>
     * @param path The path to the directory containing the Docker file. This parameter is required.
     * @param options Docker build options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImage fromBuild(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.DockerBuildOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.DockerImage.class, "fromBuild", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.DockerImage.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * (experimental) Builds a Docker image.
     * <p>
     * @param path The path to the directory containing the Docker file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImage fromBuild(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.DockerImage.class, "fromBuild", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.DockerImage.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * (experimental) Reference an image on DockerHub or another online registry.
     * <p>
     * @param image the image name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.DockerImage fromRegistry(final @org.jetbrains.annotations.NotNull java.lang.String image) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.DockerImage.class, "fromRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.DockerImage.class), new Object[] { java.util.Objects.requireNonNull(image, "image is required") });
    }

    /**
     * (experimental) Copies a file or directory out of the Docker image to the local filesystem.
     * <p>
     * If <code>outputPath</code> is omitted the destination path is a temporary directory.
     * <p>
     * @return the destination path
     * @param imagePath the path in the Docker image. This parameter is required.
     * @param outputPath the destination path for the copy operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String cp(final @org.jetbrains.annotations.NotNull java.lang.String imagePath, final @org.jetbrains.annotations.Nullable java.lang.String outputPath) {
        return software.amazon.jsii.Kernel.call(this, "cp", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(imagePath, "imagePath is required"), outputPath });
    }

    /**
     * (experimental) Copies a file or directory out of the Docker image to the local filesystem.
     * <p>
     * If <code>outputPath</code> is omitted the destination path is a temporary directory.
     * <p>
     * @return the destination path
     * @param imagePath the path in the Docker image. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String cp(final @org.jetbrains.annotations.NotNull java.lang.String imagePath) {
        return software.amazon.jsii.Kernel.call(this, "cp", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(imagePath, "imagePath is required") });
    }

    /**
     * (experimental) Runs a Docker image.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void run(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.DockerRunOptions options) {
        software.amazon.jsii.Kernel.call(this, "run", software.amazon.jsii.NativeType.VOID, new Object[] { options });
    }

    /**
     * (experimental) Runs a Docker image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void run() {
        software.amazon.jsii.Kernel.call(this, "run", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Provides a stable representation of this image for JSON serialization.
     * <p>
     * @return The overridden image name if set or image hash name in that order
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String toJSON() {
        return software.amazon.jsii.Kernel.call(this, "toJSON", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The Docker image.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getImage() {
        return software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
