package software.amazon.awscdk.core;

/**
 * (experimental) Representation of validation results.
 * <p>
 * Models a tree of validation errors so that we have as much information as possible
 * about the failure that occurred.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * ValidationResults validationResults;
 * ValidationResult validationResult = new ValidationResult("errorMessage", validationResults);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.590Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.ValidationResult")
public class ValidationResult extends software.amazon.jsii.JsiiObject {

    protected ValidationResult(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ValidationResult(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param errorMessage
     * @param results
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ValidationResult(final @org.jetbrains.annotations.Nullable java.lang.String errorMessage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.ValidationResults results) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { errorMessage, results });
    }

    /**
     * @param errorMessage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ValidationResult(final @org.jetbrains.annotations.Nullable java.lang.String errorMessage) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { errorMessage });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ValidationResult() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Turn a failed validation into an exception.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void assertSuccess() {
        software.amazon.jsii.Kernel.call(this, "assertSuccess", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * (experimental) Return a string rendering of the tree of validation failures.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String errorTree() {
        return software.amazon.jsii.Kernel.call(this, "errorTree", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Wrap this result with an error message, if it concerns an error.
     * <p>
     * @param message This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ValidationResult prefix(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        return software.amazon.jsii.Kernel.call(this, "prefix", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ValidationResult.class), new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getErrorMessage() {
        return software.amazon.jsii.Kernel.get(this, "errorMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsSuccess() {
        return software.amazon.jsii.Kernel.get(this, "isSuccess", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ValidationResults getResults() {
        return software.amazon.jsii.Kernel.get(this, "results", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ValidationResults.class));
    }
}
